/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.tooltips.generators;

import com.ibm.team.build.common.model.CompileProblemType;
import com.ibm.team.build.common.model.ICompileProblem;
import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.ui.tooltips.generators.AbstractBuildHTMLGenerator;
import com.ibm.team.jface.preview.HTMLGenerator;
import org.eclipse.core.runtime.IProgressMonitor;

public class CompileProblemHTMLGenerator
extends AbstractBuildHTMLGenerator {
    ICompileProblem fCompileProblem;

    public CompileProblemHTMLGenerator(ICompileProblem compileProblem) {
        ValidationHelper.validateNotNull((String)"compileProblem", (Object)compileProblem);
        this.fCompileProblem = compileProblem;
    }

    @Override
    protected void createFocusControl(HTMLGenerator.Composite parent, IProgressMonitor monitor) {
        AbstractBuildHTMLGenerator.CustomTable table = new AbstractBuildHTMLGenerator.CustomTable(this, parent, 1);
        table.setCSSClass("results");
        table.setBorderCSSClass("borderless");
        table.setFirstRowCSSClass("bold");
        this.createLabel(table, this.fCompileProblem.getCompileSource().getSourceName());
        this.createLabel(table, "");
        String source = this.fCompileProblem.getSourceText();
        String prefix = source.substring(0, this.fCompileProblem.getSourceStart());
        String problem = source.substring(this.fCompileProblem.getSourceStart(), this.fCompileProblem.getSourceEnd() + 1);
        String suffix = source.substring(this.fCompileProblem.getSourceEnd() + 1);
        String type = this.fCompileProblem.getProblemType() == CompileProblemType.ERROR ? "ERROR" : "WARNING";
        this.createLabelFromXML(table, "&nbsp;&nbsp;" + type + " -&nbsp;&nbsp;" + this.escape(this.fCompileProblem.getMessageText()));
        this.createLabel(table, "");
        AbstractBuildHTMLGenerator.Cell cell = new AbstractBuildHTMLGenerator.Cell(this, table);
        this.createLabelFromXML(cell, "&nbsp;&nbsp;" + this.fCompileProblem.getLineNumber() + ":");
        this.createLabelFromXML(cell, "&nbsp;&nbsp;&nbsp;" + this.escape(prefix));
        this.createLabel(cell, problem).setCSSClass("red");
        this.createLabel(cell, suffix);
    }

    @Override
    protected void createHoverControl(HTMLGenerator.Composite composite, IProgressMonitor monitor) {
        this.createFocusControl(composite, monitor);
    }
}

