/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.tooltips.generators;

import com.ibm.team.build.common.model.BuildState;
import com.ibm.team.build.common.model.BuildStatus;
import com.ibm.team.build.common.model.IBuildEngine;
import com.ibm.team.build.common.model.IBuildRequest;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.internal.common.helper.BuildActivityHelper;
import com.ibm.team.build.internal.common.helper.TimeFormatHelper;
import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.common.model.dto.IBuildResultRecord;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.editors.result.BuildResultEditorMessages;
import com.ibm.team.build.internal.ui.helper.BuildEngineTextHelper;
import com.ibm.team.build.internal.ui.helper.BuildResultTextHelper;
import com.ibm.team.build.internal.ui.helper.BuildResultTimeHelper;
import com.ibm.team.build.internal.ui.helper.BuildStateTextHelper;
import com.ibm.team.build.internal.ui.helper.ContributorHelper;
import com.ibm.team.build.internal.ui.jobs.TeamBuildJobHelper;
import com.ibm.team.build.internal.ui.tooltips.generators.AbstractBuildHTMLGenerator;
import com.ibm.team.build.internal.ui.tooltips.generators.TooltipsGeneratorsMessages;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.jface.preview.HTMLGenerator;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;

public class BuildResultRecordHTMLGenerator
extends AbstractBuildHTMLGenerator {
    private IBuildResultRecord fBuildResultRecord;
    private IBuildResult fBuildResult;
    private IBuildEngine[] fPotentialHandlers;

    public BuildResultRecordHTMLGenerator(IBuildResultRecord buildResultRecord) {
        ValidationHelper.validateNotNull((String)"buildResultRecord", (Object)buildResultRecord);
        this.fBuildResultRecord = buildResultRecord;
        this.fBuildResult = this.fBuildResultRecord.getBuildResult();
    }

    @Override
    protected void createFocusControl(HTMLGenerator.Composite composite, IProgressMonitor monitor) {
        try {
            this.fBuildResult = this.ensureFieldsForFocus(this.fBuildResult, monitor);
            this.fPotentialHandlers = this.fetchPotentialHandlers(monitor);
        }
        catch (TeamRepositoryException exception) {
            BuildUIPlugin.log(exception);
            this.createLabel(composite, TooltipsGeneratorsMessages.BuildResultRecordHTMLGenerator_ERROR_MESSAGE);
            this.createLineBreak(composite);
            this.createLabel(composite, TeamBuildJobHelper.getStatusMessage(exception));
            return;
        }
        HTMLGenerator.Section section = new HTMLGenerator.Section((HTMLGenerator)this, composite, (HTMLGenerator.Control)this.createLabel(BuildResultTextHelper.getLabel(this.fBuildResult)));
        if (this.fBuildResult.getState() == BuildState.NOT_STARTED) {
            this.createPendingRequestSection((HTMLGenerator.Composite)section);
        } else {
            this.createStatusSection((HTMLGenerator.Composite)section, this.fBuildResult, this.fBuildResultRecord);
        }
        this.createLineBreak((HTMLGenerator.Composite)section);
        this.createGeneralInformationSection(section, monitor);
    }

    private IBuildEngine[] fetchPotentialHandlers(IProgressMonitor monitor) throws TeamRepositoryException {
        ITeamRepository teamRepository;
        IBuildRequest buildRequest = this.findStartRequest();
        if (buildRequest != null && !buildRequest.getPotentialHandlers().isEmpty() && (teamRepository = this.getTeamRepository((IItemHandle)this.fBuildResult)) != null) {
            List potentialHandlers = teamRepository.itemManager().fetchCompleteItems(buildRequest.getPotentialHandlers(), 0, monitor);
            return potentialHandlers.toArray(new IBuildEngine[potentialHandlers.size()]);
        }
        return new IBuildEngine[0];
    }

    protected void createPendingRequestSection(HTMLGenerator.Composite parent) {
        HTMLGenerator.Section section = this.createNonIndentedSection(parent, (HTMLGenerator.Control)this.createLabel(TooltipsGeneratorsMessages.BuildResultRecordHTMLGenerator_REQUEST_SECTION_TITLE));
        AbstractBuildHTMLGenerator.CustomTable table = this.createLayoutTable((HTMLGenerator.Composite)section, 2);
        this.createLabel(table, TooltipsGeneratorsMessages.BuildResultRecordHTMLGenerator_BUILD_STATE_INTRO);
        this.createLabel(table, BuildStateTextHelper.getText(BuildState.NOT_STARTED));
        IBuildRequest request = this.findStartRequest();
        if (request != null) {
            this.createLabel(table, TooltipsGeneratorsMessages.BuildResultRecordHTMLGenerator_REQUEST_TIME_INTRO);
            this.createLabel(table, TimeFormatHelper.getReadableTimeDif((Date)request.getCreated()));
            this.addRequestorInfo(table);
            this.addPotentialHandlersInfo(table);
        }
    }

    protected void addRequestorInfo(AbstractBuildHTMLGenerator.CustomTable table) {
        if (this.fBuildResultRecord.isScheduledBuild()) {
            this.createLabel(table, TooltipsGeneratorsMessages.BuildResultRecordHTMLGenerator_REQUESTOR_INTRO);
            this.createLabel(table, BuildResultTextHelper.getScheduledBuildRequestorText());
        } else {
            IContributor requestor = this.fBuildResultRecord.getRequestor();
            if (requestor != null) {
                this.createLabel(table, TooltipsGeneratorsMessages.BuildResultRecordHTMLGenerator_REQUESTOR_INTRO);
                this.createLabel(table, ContributorHelper.getContributorLabelText(requestor));
            }
        }
    }

    protected void addPotentialHandlersInfo(AbstractBuildHTMLGenerator.CustomTable table) {
        this.createLabel(table, TooltipsGeneratorsMessages.BuildResultRecordHTMLGenerator_TARGET_ENGINES);
        if (this.fPotentialHandlers != null && this.fPotentialHandlers.length > 0) {
            this.createLabel(table, this.getEngineIds(this.fPotentialHandlers));
        } else {
            this.createLabel(table, TooltipsGeneratorsMessages.BuildResultRecordHTMLGenerator_ANY_SUPPORTING_ENGINE);
        }
    }

    protected String getEngineIds(IBuildEngine[] buildEngines) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < buildEngines.length) {
            if (i != 0) {
                sb.append(TooltipsGeneratorsMessages.BuildResultRecordHTMLGenerator_ENGINES_SEPARATOR);
            }
            sb.append(buildEngines[i] == null ? TooltipsGeneratorsMessages.BuildResultRecordHTMLGenerator_UNKNOWN_ENGINE : buildEngines[i].getId());
            ++i;
        }
        return sb.toString();
    }

    private IBuildRequest findStartRequest() {
        IBuildRequest[] allRequests = this.fBuildResultRecord.getBuildRequests();
        int i = 0;
        while (i < allRequests.length) {
            if ("com.ibm.team.build.action.requestBuild".equals(allRequests[i].getBuildAction().getAction())) {
                return allRequests[i];
            }
            ++i;
        }
        return null;
    }

    @Override
    protected void createHoverControl(HTMLGenerator.Composite composite, IProgressMonitor monitor) {
        String progressPercentString;
        try {
            this.fBuildResult = this.ensureFieldsforHover(this.fBuildResult, monitor);
        }
        catch (TeamRepositoryException exception) {
            BuildUIPlugin.log(exception);
            this.createLabel(composite, TooltipsGeneratorsMessages.BuildResultRecordHTMLGenerator_ERROR_MESSAGE);
            this.createLineBreak(composite);
            this.createLabel(composite, TeamBuildJobHelper.getStatusMessage(exception));
            return;
        }
        HTMLGenerator.Section section = new HTMLGenerator.Section((HTMLGenerator)this, composite, (HTMLGenerator.Control)this.createLabel(BuildResultTextHelper.getLabel(this.fBuildResult)));
        section.setCSSClass("outermost");
        AbstractBuildHTMLGenerator.CustomTable table = new AbstractBuildHTMLGenerator.CustomTable((HTMLGenerator.Composite)section, 2);
        table.setCSSClass("layout");
        table.setFirstRowCSSClass("first");
        table.setBorderCSSClass("borderless");
        this.createLabel(table, TooltipsGeneratorsMessages.BuildResultRecordHTMLGenerator_BUILD_STATUS_INTRO);
        BuildState buildState = this.fBuildResult.getState();
        String headerText = buildState.equals((Object)BuildState.IN_PROGRESS) ? (!(progressPercentString = BuildResultTimeHelper.getProgressPercentString(this.fBuildResult, this.fBuildResultRecord)).equals("") ? NLS.bind((String)TooltipsGeneratorsMessages.BuildResultRecordHTMLGenerator_IN_PROGRESS_STRING, (Object)progressPercentString) : BuildStateTextHelper.getText(buildState)) : BuildStateTextHelper.getText(buildState);
        HTMLGenerator.Label buildStateLabel = this.createLabel(table, headerText);
        if (buildState.equals((Object)BuildState.IN_PROGRESS)) {
            String lastUpdateTime;
            buildStateLabel.setImage(this.getStatusImageURL(this.fBuildResult));
            String currentActivityLabel = BuildActivityHelper.getCurrentActivityText((Collection)this.fBuildResultRecord.getCurrentBuildActivities());
            if (currentActivityLabel != null && !currentActivityLabel.equals("")) {
                this.createLabel(table, TooltipsGeneratorsMessages.BuildResultRecordHTMLGenerator_CURRENT_ACTIVITY);
                this.createLabel(table, currentActivityLabel);
            }
            if ((lastUpdateTime = BuildResultTimeHelper.getLastUpdateTimeString(this.fBuildResultRecord)) != null && !lastUpdateTime.equals("")) {
                this.createLabel(table, TooltipsGeneratorsMessages.BuildResultRecordHTMLGenerator_LAST_UPDATE);
                this.createLabel(table, BuildResultTimeHelper.getLastUpdateTimeString(this.fBuildResultRecord));
            }
            this.addRequestorInfo(table);
        } else {
            this.addRequestorInfo(table);
            if (buildState.equals((Object)BuildState.COMPLETED) || buildState.equals((Object)BuildState.INCOMPLETE)) {
                this.createLabel(table, TooltipsGeneratorsMessages.BuildResultRecordHTMLGenerator_BUILD_ENGINE_INTRO);
                this.createLabel(table, BuildEngineTextHelper.getBuildEngineText(this.fBuildResultRecord));
                this.createLabel(table, BuildResultEditorMessages.StatusSection_DURATION);
                this.createLabel(table, BuildResultTimeHelper.getDurationString(this.fBuildResult));
                if (buildState.equals((Object)BuildState.COMPLETED)) {
                    buildStateLabel.setImage(this.getStatusImageURL(this.fBuildResult));
                }
                this.createLabel(table, TooltipsGeneratorsMessages.BuildResultRecordHTMLGenerator_TAGS_INTRO);
                if (this.fBuildResultRecord.getBuildResult().getTags().length() != 0) {
                    this.createLabel(table, this.fBuildResultRecord.getBuildResult().getTags());
                } else {
                    this.createLabel(table, TooltipsGeneratorsMessages.BuildResultRecordHTMLGenerator_NO_TAGS);
                }
            }
        }
    }

    private IBuildResult ensureFieldsForFocus(IBuildResult result, IProgressMonitor monitor) throws TeamRepositoryException {
        if (!(this.hasBuildTimeInformation(result) && this.hasBuildStateAndStatus(result) && this.hasModifiedTimeIfNeeded(result))) {
            ITeamRepository repository = this.getTeamRepository((IItemHandle)result);
            if (repository == null) {
                throw new TeamRepositoryException(TooltipsGeneratorsMessages.BuildResultRecordHTMLGenerator_EXCEPTION_MESSAGE);
            }
            result = (IBuildResult)repository.itemManager().fetchCompleteItem((IItemHandle)result, 0, monitor);
        }
        return result;
    }

    private boolean hasModifiedTimeIfNeeded(IBuildResult result) {
        return result.getState() != BuildState.IN_PROGRESS || result.isPropertySet(IItem.MODIFIED_PROPERTY);
    }

    private boolean hasBuildTimeInformation(IBuildResult result) {
        return result.getState() == BuildState.IN_PROGRESS && result.isPropertySet(IBuildResult.PROPERTY_BUILD_START_TIME) || result.isPropertySet(IBuildResult.PROPERTY_BUILD_TIME_TAKEN);
    }

    private IBuildResult ensureFieldsforHover(IBuildResult result, IProgressMonitor monitor) throws TeamRepositoryException {
        if (!this.hasBuildStateAndStatus(result)) {
            ITeamRepository repository = this.getTeamRepository((IItemHandle)result);
            if (repository == null) {
                throw new TeamRepositoryException(TooltipsGeneratorsMessages.BuildResultRecordHTMLGenerator_EXCEPTION_MESSAGE);
            }
            result = (IBuildResult)repository.itemManager().fetchCompleteItem((IItemHandle)result, 0, monitor);
        }
        return result;
    }

    private boolean hasBuildStateAndStatus(IBuildResult result) {
        return result.isPropertySet(IBuildResult.PROPERTY_BUILD_STATE) && result.isPropertySet(IBuildResult.PROPERTY_BUILD_STATUS);
    }

    private void createGeneralInformationSection(HTMLGenerator.Section parent, IProgressMonitor monitor) {
        HTMLGenerator.Link link;
        HTMLGenerator.Section generalInfoSection = new HTMLGenerator.Section((HTMLGenerator)this, (HTMLGenerator.Composite)parent, (HTMLGenerator.Control)this.createLabel(TooltipsGeneratorsMessages.BuildResultRecordHTMLGenerator_GENERAL_INFORMATION_SECTION_TITLE));
        generalInfoSection.setCSSClass("left");
        AbstractBuildHTMLGenerator.CustomTable table = new AbstractBuildHTMLGenerator.CustomTable((HTMLGenerator.Composite)generalInfoSection, 2);
        table.setCSSClass("nowrap");
        table.setBorderCSSClass("borderless");
        table.setFirstRowCSSClass("first");
        this.createLabel(table, TooltipsGeneratorsMessages.BuildResultRecordHTMLGenerator_BUILD_DEFINITION_INTRO);
        ITeamRepository teamRepository = this.getTeamRepository((IItemHandle)this.fBuildResultRecord.getBuildDefinition());
        if (teamRepository != null) {
            link = this.createItemLink(table, (IItemHandle)this.fBuildResultRecord.getBuildDefinition(), teamRepository, (IProgressMonitor)this.createSubMonitor(monitor, 1));
            this.createLabel((HTMLGenerator.Composite)link, this.fBuildResultRecord.getBuildDefinition().getId());
        } else {
            this.createLabel(table, this.fBuildResultRecord.getBuildDefinition().getId());
        }
        this.createLabel(table, TooltipsGeneratorsMessages.BuildResultRecordHTMLGenerator_BUILD_ENGINE_INTRO);
        teamRepository = this.getTeamRepository((IItemHandle)this.fBuildResultRecord.getBuildEngine());
        if (teamRepository != null) {
            link = this.createItemLink(table, (IItemHandle)this.fBuildResultRecord.getBuildEngine(), teamRepository, (IProgressMonitor)this.createSubMonitor(monitor, 1));
            this.createLabel((HTMLGenerator.Composite)link, BuildEngineTextHelper.getBuildEngineText(this.fBuildResultRecord));
        } else {
            this.createLabel(table, BuildEngineTextHelper.getBuildEngineText(this.fBuildResultRecord));
        }
        this.createLabel(table, TooltipsGeneratorsMessages.BuildResultRecordHTMLGenerator_BUILD_HISTORY_INTRO);
        int count = this.fBuildResultRecord.getBuildCount();
        this.createLabel(table, String.valueOf(count));
        this.createLabel(table, TooltipsGeneratorsMessages.BuildResultRecordHTMLGenerator_TAGS_INTRO);
        if (this.fBuildResultRecord.getBuildResult().getTags().length() != 0) {
            this.createLabel(table, this.fBuildResultRecord.getBuildResult().getTags());
        } else {
            this.createLabel(table, TooltipsGeneratorsMessages.BuildResultRecordHTMLGenerator_NO_TAGS);
        }
        this.createLabel(table, TooltipsGeneratorsMessages.BuildResultRecordHTMLGenerator_DELETEALLOW_STATUS_INTRO);
        this.createLabel(table, this.fBuildResult.isDeleteAllowed() ? TooltipsGeneratorsMessages.BuildResultRecordHTLMGenerator_DELETEALLOW_STATUS_TRUE : TooltipsGeneratorsMessages.BuildResultRecordHTLMGenerator_DELETEALLOW_STATUS_FALSE);
    }

    protected void createStatusSection(HTMLGenerator.Composite parent, IBuildResult result, IBuildResultRecord record) {
        String progressPercentString;
        BuildState buildState = result.getState();
        String headerText = buildState.equals((Object)BuildState.IN_PROGRESS) ? (!(progressPercentString = BuildResultTimeHelper.getProgressPercentString(result, this.fBuildResultRecord)).equals("") ? NLS.bind((String)TooltipsGeneratorsMessages.BuildResultRecordHTMLGenerator_IN_PROGRESS_STRING, (Object)progressPercentString) : BuildStateTextHelper.getText(buildState)) : BuildStateTextHelper.getText(buildState);
        HTMLGenerator.Label buildStateLabel = this.createLabel(headerText);
        buildStateLabel.setImage(this.getStatusImageURL(result));
        HTMLGenerator.Section statusSection1 = new HTMLGenerator.Section((HTMLGenerator)this, parent, (HTMLGenerator.Control)buildStateLabel);
        statusSection1.setCSSClass(this.getStatusCSSClass(result));
        AbstractBuildHTMLGenerator.CustomTable statusSection = new AbstractBuildHTMLGenerator.CustomTable((HTMLGenerator.Composite)statusSection1, 2);
        statusSection.setCSSClass("results");
        statusSection.setBorderCSSClass("borderless");
        statusSection.setFirstRowCSSClass("first");
        if (buildState.equals((Object)BuildState.IN_PROGRESS)) {
            String estimatedCompletion;
            String currentActivityMessage = BuildActivityHelper.getCurrentActivityText((Collection)record.getCurrentBuildActivities());
            if (!currentActivityMessage.equals("")) {
                this.createLabel(statusSection, BuildResultEditorMessages.StatusSection_ACTIVITY_MESSAGE);
                this.createLabel(statusSection, currentActivityMessage);
            }
            if (!(estimatedCompletion = BuildResultTimeHelper.getEstimatedCompletionTimeString(result, this.fBuildResultRecord)).equals("")) {
                this.createLabel(statusSection, BuildResultEditorMessages.StatusSection_ESTIMATED_COMPLETION);
                this.createLabel(statusSection, estimatedCompletion);
            }
            this.createLabel(statusSection, BuildResultEditorMessages.StatusSection_LAST_UPDATE);
            this.createLabel(statusSection, BuildResultTimeHelper.getLastUpdateTimeString(record));
        }
        this.createLabel(statusSection, BuildResultEditorMessages.StatusSection_DURATION);
        this.createLabel(statusSection, BuildResultTimeHelper.getDurationString(result));
        this.createLabel(statusSection, BuildResultEditorMessages.StatusSection_STARTED_AT);
        this.createLabel(statusSection, BuildResultTimeHelper.getStartTimeString(result));
        if (!buildState.equals((Object)BuildState.IN_PROGRESS)) {
            if (result.getState() == BuildState.INCOMPLETE) {
                this.createLabel(statusSection, BuildResultEditorMessages.StatusSection_ABANDONED_BY);
                String abandonerName = TooltipsGeneratorsMessages.BuildResultRecordHTMLGenerator_UNKNOWN_ABANDONER;
                IContributor abandoner = this.fBuildResultRecord.getAbandoner();
                if (abandoner != null) {
                    abandonerName = abandoner.getName();
                }
                this.createLabel(statusSection, NLS.bind((String)TooltipsGeneratorsMessages.BuildResultRecordHTMLGenerator_ABANDONED_AT, (Object)abandonerName, (Object)BuildResultTimeHelper.getCompletedTime(result)));
            } else {
                this.createLabel(statusSection, BuildResultEditorMessages.StatusSection_COMPLETED_AT);
                this.createLabel(statusSection, BuildResultTimeHelper.getCompletedTime(result));
            }
        }
        this.addRequestorInfo(statusSection);
    }

    protected String getStatusCSSClass(IBuildResult buildResult) {
        String cssClass = buildResult.getStatus() == BuildStatus.ERROR ? "errorstatus" : (buildResult.getStatus() == BuildStatus.WARNING ? "warningstatus" : "okstatus");
        return cssClass;
    }

    protected String getStatusImageURL(IBuildResult buildResult) {
        ImageDescriptor image = BuildUIPlugin.getImageDescriptor("icons/ovr16/success_ovr.gif");
        JazzResources.registerPath((ImageDescriptor)image, (String)"com.ibm.team.build.ui", (String)"icons/ovr16/success_ovr.gif");
        if (buildResult.getState() == BuildState.INCOMPLETE) {
            image = BuildUIPlugin.getImageDescriptor("icons/obj16/abanblds_obj.gif");
            JazzResources.registerPath((ImageDescriptor)image, (String)"com.ibm.team.build.ui", (String)"icons/obj16/abanblds_obj.gif");
        } else if (buildResult.getStatus() == BuildStatus.ERROR) {
            image = BuildUIPlugin.getImageDescriptor("icons/ovr16/failed_ovr.gif");
            JazzResources.registerPath((ImageDescriptor)image, (String)"com.ibm.team.build.ui", (String)"icons/ovr16/failed_ovr.gif");
        } else if (buildResult.getStatus() == BuildStatus.WARNING) {
            image = BuildUIPlugin.getImageDescriptor("icons/ovr16/warn_ovr.gif");
            JazzResources.registerPath((ImageDescriptor)image, (String)"com.ibm.team.build.ui", (String)"icons/ovr16/warn_ovr.gif");
        }
        return JazzResources.createDataURLForImageDescriptor((ImageDescriptor)image);
    }
}

