/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.tooltips.generators;

import com.ibm.team.build.client.iterator.IBuildResultRecordIterator;
import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.common.model.dto.IBuildResultRecord;
import com.ibm.team.build.internal.ui.jobs.TeamBuildJobHelper;
import com.ibm.team.build.internal.ui.query.BuildQuery;
import com.ibm.team.build.internal.ui.query.BuildQueryForBuildQueue;
import com.ibm.team.build.internal.ui.tooltips.generators.AbstractBuildHTMLGenerator;
import com.ibm.team.build.internal.ui.tooltips.generators.DescendingRequestTimeComparator;
import com.ibm.team.build.internal.ui.tooltips.generators.TooltipsGeneratorsMessages;
import com.ibm.team.jface.preview.HTMLGenerator;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class BuildQueryHTMLGenerator
extends AbstractBuildHTMLGenerator {
    private BuildQuery fQuery;

    public BuildQueryHTMLGenerator(BuildQuery query) {
        ValidationHelper.validateNotNull((String)"query", (Object)query);
        this.fQuery = query;
    }

    @Override
    protected void createFocusControl(HTMLGenerator.Composite parent, IProgressMonitor monitor) {
        this.createTeaserHTML(parent);
        this.createResultsHTML(parent, monitor);
        this.createConditionsHTML(parent);
    }

    @Override
    protected void createHoverControl(HTMLGenerator.Composite composite, IProgressMonitor monitor) {
        this.createTeaserHTML(composite);
        this.createConditionsHTML(composite);
    }

    protected void createConditionsHTML(HTMLGenerator.Composite composite) {
        if (this.fQuery instanceof BuildQueryForBuildQueue) {
            HTMLGenerator.Section conditions = new HTMLGenerator.Section((HTMLGenerator)this, composite, (HTMLGenerator.Control)this.createLabel(TooltipsGeneratorsMessages.BuildQueryHTMLGenerator_CONDITIONS));
            AbstractBuildHTMLGenerator.CustomTable table = this.createDetailsTable((HTMLGenerator.Composite)conditions, 2);
            this.createLabel(table, TooltipsGeneratorsMessages.BuildQueryHTMLGenerator_OR).setCSSClass("bold");
            this.createLabel(table, TooltipsGeneratorsMessages.BuildQueryHTMLGenerator_BUILD_IN_PROGRESS);
            this.createEmptyCell(table);
            this.createLabel(table, TooltipsGeneratorsMessages.BuildQueryHTMLGenerator_BUILD_NOT_STARTED);
        }
    }

    protected void createResultsHTML(HTMLGenerator.Composite composite, IProgressMonitor monitor) {
        try {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)3);
            IBuildResultRecordIterator resultIterator = this.fQuery.doIterativeQuery((IProgressMonitor)subMonitor.newChild(1));
            LinkedList<IBuildResultRecord> records = new LinkedList<IBuildResultRecord>();
            SubMonitor child = subMonitor.newChild(1);
            child.setWorkRemaining(resultIterator.size());
            while (resultIterator.hasNext()) {
                IBuildResultRecord[] results;
                IBuildResultRecord[] iBuildResultRecordArray = results = resultIterator.next(10, (IProgressMonitor)child.newChild(1));
                int n = results.length;
                int n2 = 0;
                while (n2 < n) {
                    IBuildResultRecord buildResultRecord = iBuildResultRecordArray[n2];
                    records.add(buildResultRecord);
                    ++n2;
                }
            }
            this.sort(records);
            this.createBuildsSection(composite, records.toArray(new IBuildResultRecord[records.size()]), resultIterator.size(), this.fQuery.getTeamRepository(), (IProgressMonitor)subMonitor.newChild(1));
        }
        catch (TeamRepositoryException exception) {
            this.createLabel(composite, TooltipsGeneratorsMessages.BuildQueryHTMLGenerator_ERROR_RUNNING_QUERY);
            this.createLineBreak(composite);
            this.createLabel(composite, TeamBuildJobHelper.getStatusMessage(exception));
        }
    }

    private void sort(List<IBuildResultRecord> records) {
        Collections.sort(records, new DescendingRequestTimeComparator());
    }

    protected void createTeaserHTML(HTMLGenerator.Composite composite) {
        this.createLabel(composite, this.getName()).setCSSClass("bold");
        this.createLineBreak(composite);
        String description = this.getDescription();
        if (description.length() > 0) {
            this.createLabel(composite, this.getDescription());
            this.createLineBreak(composite);
        }
        this.createLineBreak(composite);
    }

    protected AbstractBuildHTMLGenerator.CustomTable createDetailsTable(HTMLGenerator.Composite parent, int columns) {
        AbstractBuildHTMLGenerator.CustomTable table = new AbstractBuildHTMLGenerator.CustomTable(parent, columns);
        table.setCSSClass("details");
        table.setFirstRowCSSClass("first");
        return table;
    }

    private String getName() {
        if (this.fQuery instanceof BuildQueryForBuildQueue) {
            return TooltipsGeneratorsMessages.BuildQueryHTMLGenerator_BUILD_QUEUE_QUERY_NAME;
        }
        return this.fQuery.getName();
    }

    private String getDescription() {
        if (this.fQuery instanceof BuildQueryForBuildQueue) {
            return TooltipsGeneratorsMessages.BuildQueryHTMLGenerator_BUILD_QUEUE_QUERY_DESCRIPTION;
        }
        return this.fQuery.getDescription();
    }
}

