/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.tooltips.generators;

import com.ibm.team.build.common.model.BuildStatus;
import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.common.model.IBuildEngine;
import com.ibm.team.build.common.model.IBuildEngineHandle;
import com.ibm.team.build.internal.client.ITeamBuildRecordClient;
import com.ibm.team.build.internal.common.helper.TimeFormatHelper;
import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.common.model.dto.IBuildEngineStatusRecord;
import com.ibm.team.build.internal.common.model.dto.IInProgressBuild;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.jobs.TeamBuildJobHelper;
import com.ibm.team.build.internal.ui.query.BuildQueryByEngine;
import com.ibm.team.build.internal.ui.query.BuildQueryRow;
import com.ibm.team.build.internal.ui.tooltips.BuildQueryHyperlinkHandler;
import com.ibm.team.build.internal.ui.tooltips.generators.AbstractBuildHTMLGenerator;
import com.ibm.team.build.internal.ui.tooltips.generators.TooltipsGeneratorsMessages;
import com.ibm.team.jface.preview.HTMLGenerator;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.net.URI;
import java.sql.Timestamp;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;

public class BuildEngineStatusRecordHTMLGenerator
extends AbstractBuildHTMLGenerator {
    private IBuildEngineStatusRecord fBuildEngineStatusRecord;
    private IBuildEngineHandle fBuildEngineHandle;
    private IProjectAreaHandle fProjectAreaHandle;

    public BuildEngineStatusRecordHTMLGenerator(IBuildEngineStatusRecord record, IProjectAreaHandle projectAreaHandle) {
        ValidationHelper.validateNotNull((String)"record", (Object)record);
        this.fBuildEngineStatusRecord = record;
        this.fBuildEngineHandle = record.getBuildEngine();
        this.fProjectAreaHandle = projectAreaHandle;
    }

    public BuildEngineStatusRecordHTMLGenerator(IBuildEngineHandle engineHandle, IProjectAreaHandle projectAreaHandle) {
        ValidationHelper.validateNotNull((String)"engineHandle", (Object)engineHandle);
        this.fBuildEngineHandle = engineHandle;
        this.fProjectAreaHandle = projectAreaHandle;
    }

    @Override
    protected void createFocusControl(HTMLGenerator.Composite parent, IProgressMonitor monitor) {
        try {
            this.fBuildEngineStatusRecord = this.fetchBuildEngineStatusRecord(monitor);
        }
        catch (TeamRepositoryException exception) {
            BuildUIPlugin.log(exception);
            this.createLabel(parent, TooltipsGeneratorsMessages.BuildEngineStatusRecordHTMLGenerator_ERROR_MESSAGE);
            this.createLabel(parent, TeamBuildJobHelper.getStatusMessage(exception));
            return;
        }
        IBuildEngine buildEngine = this.fBuildEngineStatusRecord.getBuildEngine();
        HTMLGenerator.Section outermostSection = new HTMLGenerator.Section((HTMLGenerator)this, parent, this.getFocusTitleControl(buildEngine, monitor));
        outermostSection.setCSSClass("outermost");
        parent = outermostSection;
        this.displayLastContactWarning(parent, true);
        this.createTeaser(parent);
        this.createLineBreak(parent);
        this.createRunningBuildsSection(parent, monitor);
        this.createLineBreak(parent);
        this.createSupportedDefinitionList(parent, monitor);
    }

    private HTMLGenerator.Control getFocusTitleControl(IBuildEngine buildEngine, IProgressMonitor monitor) {
        AbstractBuildHTMLGenerator.CustomTable titleTable = this.createLayoutTable(null, 3);
        titleTable.setBorderCSSClass("padded-right");
        this.createLabel(titleTable, buildEngine.getId()).setCSSClass("bold");
        ITeamRepository repository = this.getTeamRepository((IItemHandle)buildEngine);
        if (repository != null) {
            this.createShowBuildsLink(titleTable, repository);
            HTMLGenerator.Link link = this.createItemLink(titleTable, (IItemHandle)buildEngine, repository, monitor);
            this.createLabel((HTMLGenerator.Composite)link, TooltipsGeneratorsMessages.BuildEngineHTMLGenerator_OPEN_ENGINE_LINK);
        } else {
            this.createEmptyCell(titleTable);
        }
        return titleTable;
    }

    private void createShowBuildsLink(HTMLGenerator.Composite composite, ITeamRepository repository) {
        IBuildEngine buildEngine = this.fBuildEngineStatusRecord.getBuildEngine();
        if (this.fProjectAreaHandle != null) {
            BuildQueryByEngine query = new BuildQueryByEngine(buildEngine.getId(), null, new BuildQueryRow.Factory(), (IBuildEngineHandle)buildEngine, this.fProjectAreaHandle, repository);
            URI uri = new BuildQueryHyperlinkHandler().createHyperlink(query, null).getURI();
            HTMLGenerator.Link link = new HTMLGenerator.Link((HTMLGenerator)this, composite, uri.toString());
            this.createLabel((HTMLGenerator.Composite)link, TooltipsGeneratorsMessages.BuildEngineHTMLGenerator_SHOW_BUILDS);
        } else {
            this.createLabel(composite, "");
        }
    }

    @Override
    protected void createHoverControl(HTMLGenerator.Composite composite, IProgressMonitor monitor) {
        try {
            this.fBuildEngineStatusRecord = this.fetchBuildEngineStatusRecord(monitor);
        }
        catch (TeamRepositoryException exception) {
            BuildUIPlugin.log(exception);
            this.createLabel(composite, TooltipsGeneratorsMessages.BuildEngineStatusRecordHTMLGenerator_ERROR_MESSAGE);
            this.createLineBreak(composite);
            this.createLabel(composite, TeamBuildJobHelper.getStatusMessage(exception));
            return;
        }
        if (this.displayLastContactWarning(composite, false)) {
            return;
        }
        IBuildEngine buildEngine = this.fBuildEngineStatusRecord.getBuildEngine();
        this.createLabel(composite, buildEngine.getId()).setCSSClass("bold");
        AbstractBuildHTMLGenerator.CustomTable table = new AbstractBuildHTMLGenerator.CustomTable(composite, 2);
        table.setCSSClass("layout");
        table.setFirstRowCSSClass("first");
        table.setBorderCSSClass("borderless");
        this.createLabel(table, TooltipsGeneratorsMessages.BuildEngineHTMLGenerator_ACTIVATION_INTRO);
        this.createIsActiveLabel(table);
        this.createLabel(table, TooltipsGeneratorsMessages.BuildEngineHTMLGenerator_LAST_CONTACT_INTRO);
        this.createLastContactTimeLabel(table);
    }

    private boolean displayLastContactWarning(HTMLGenerator.Composite composite, boolean includeAdvice) {
        if (this.fBuildEngineStatusRecord.isEngineInWarningState()) {
            if (this.fBuildEngineStatusRecord.getLastContactTime() == null) {
                this.createLastContactWarning(composite, TooltipsGeneratorsMessages.BuildEngineStatusRecordHTMLGenerator_NEVER_CONTACTED, includeAdvice);
                return true;
            }
            if (this.fBuildEngineStatusRecord.isMonitoringThresholdExceeded()) {
                this.createLastContactWarning(composite, NLS.bind((String)TooltipsGeneratorsMessages.BuildEngineStatusRecordHTMLGenerator_THRESHOLD_EXCEEDED, (Object)this.fBuildEngineStatusRecord.getBuildEngine().getMonitoringThreshold()), includeAdvice);
                return true;
            }
        }
        return false;
    }

    private void createLastContactWarning(HTMLGenerator.Composite composite, String message, boolean includeAdvice) {
        HTMLGenerator.Label label = this.createLabel(TooltipsGeneratorsMessages.BuildEngineStatusRecordHTMLGenerator_ENGINE_NOT_RUNNING);
        label.setImage(this.getStatusImageURL(BuildStatus.WARNING));
        HTMLGenerator.Section section = this.createNonIndentedSection(composite, (HTMLGenerator.Control)label);
        this.createLineBreak((HTMLGenerator.Composite)section);
        this.createLabel((HTMLGenerator.Composite)section, message);
        if (includeAdvice) {
            this.createLineBreak((HTMLGenerator.Composite)section);
            this.createLineBreak((HTMLGenerator.Composite)section);
            this.createLabel((HTMLGenerator.Composite)section, TooltipsGeneratorsMessages.BuildEngineStatusRecordHTMLGenerator_ENGINE_NOT_RUNNING_ADVICE);
        }
        this.createLineBreak(composite);
    }

    private void createTeaser(HTMLGenerator.Composite composite) {
        HTMLGenerator.Section section = this.createNonIndentedSection(composite, (HTMLGenerator.Control)this.createLabel(TooltipsGeneratorsMessages.BuildEngineHTMLGenerator_GENERAL_INFORMATION_SECTION_TITLE));
        AbstractBuildHTMLGenerator.CustomTable table = this.createLayoutTable((HTMLGenerator.Composite)section, 2);
        this.createLabel(table, TooltipsGeneratorsMessages.BuildEngineStatusRecordHTMLGenerator_DESCRIPTION_INTRO);
        this.createLabel(table, this.getEngineDescription());
        this.createLabel(table, TooltipsGeneratorsMessages.BuildEngineHTMLGenerator_ACTIVATION_INTRO);
        this.createIsActiveLabel(table);
        this.createLabel(table, TooltipsGeneratorsMessages.BuildEngineHTMLGenerator_LAST_CONTACT_INTRO);
        this.createLastContactTimeLabel(table);
    }

    private String getEngineDescription() {
        String description = this.fBuildEngineStatusRecord.getBuildEngine().getDescription();
        if (description.length() == 0) {
            description = TooltipsGeneratorsMessages.BuildEngineStatusRecordHTMLGenerator_NO_DESCRIPTION;
        }
        return description;
    }

    protected void createRunningBuildsSection(HTMLGenerator.Composite composite, IProgressMonitor monitor) {
        IInProgressBuild[] inProgressBuilds = this.fBuildEngineStatusRecord.getInProgressBuilds();
        int numberOfResultsToShow = Math.min(inProgressBuilds.length, 10);
        String inProgressSectionTitle = numberOfResultsToShow != inProgressBuilds.length ? NLS.bind((String)TooltipsGeneratorsMessages.BuildEngineHTMLGenerator_IN_PROGRESS_PARTIAL_LIST_BUILD_TITLE, (Object)numberOfResultsToShow, (Object)inProgressBuilds.length) : TooltipsGeneratorsMessages.BuildEngineHTMLGenerator_IN_PROGRESS_BUILD_TITLE;
        composite = this.createNonIndentedSection(composite, (HTMLGenerator.Control)this.createLabel(inProgressSectionTitle));
        AbstractBuildHTMLGenerator.CustomTable table = this.createLayoutTable(composite, 3);
        ITeamRepository repository = this.getTeamRepository((IItemHandle)this.fBuildEngineHandle);
        if (inProgressBuilds.length == 0) {
            this.createLabel(table, TooltipsGeneratorsMessages.BuildEngineHTMLGenerator_NO_BUILDS_IN_PROGRESS);
        } else {
            int i = 0;
            while (i < numberOfResultsToShow) {
                this.createResultTableRowHTML(table, inProgressBuilds[i], repository, monitor);
                ++i;
            }
        }
    }

    private void createResultTableRowHTML(AbstractBuildHTMLGenerator.CustomTable table, IInProgressBuild inProgressBuild, ITeamRepository teamRepository, IProgressMonitor monitor) {
        this.createLabel(table, "").setImage(this.getStatusImageURL(inProgressBuild.getStatus()));
        HTMLGenerator.Link link = this.createItemLink(table, (IItemHandle)inProgressBuild.getBuildResult(), teamRepository, monitor);
        this.createLabel((HTMLGenerator.Composite)link, inProgressBuild.getLabel());
        String activityLabel = inProgressBuild.getCurrentBuildActivityLabel();
        if (!activityLabel.equals("")) {
            this.createLabel(table, NLS.bind((String)TooltipsGeneratorsMessages.BuildEngineHTMLGenerator_CURRENT_ACTIVITY_INTRO, (Object)activityLabel));
        } else {
            this.createEmptyCell(table);
        }
    }

    protected void createSupportedDefinitionList(HTMLGenerator.Composite composite, IProgressMonitor monitor) {
        HTMLGenerator.Section section = this.createNonIndentedSection(composite, (HTMLGenerator.Control)this.createLabel(TooltipsGeneratorsMessages.BuildEngineHTMLGenerator_BUILD_DEFINITION_TITLE));
        ITeamRepository teamRepository = this.getTeamRepository((IItemHandle)this.fBuildEngineHandle);
        if (teamRepository != null) {
            boolean isSectionEmpty = true;
            List<IBuildDefinition> supportedDefinitions = null;
            try {
                supportedDefinitions = this.fetchBuildDefinitions(teamRepository, this.fBuildEngineStatusRecord.getBuildEngine().getSupportedBuildDefinitions(), monitor);
            }
            catch (TeamRepositoryException exception) {
                BuildUIPlugin.log(exception);
                this.createLabel((HTMLGenerator.Composite)section, TooltipsGeneratorsMessages.BuildEngineHTMLGenerator_ERROR_GETTING_DEFINITION);
                this.createLineBreak((HTMLGenerator.Composite)section);
                this.createLabel((HTMLGenerator.Composite)section, TeamBuildJobHelper.getStatusMessage(exception));
                return;
            }
            Collections.sort(supportedDefinitions, new Comparator<IBuildDefinition>(){
                private Collator collator = Collator.getInstance();

                @Override
                public int compare(IBuildDefinition buildDefinition1, IBuildDefinition buildDefinition2) {
                    return this.collator.compare(buildDefinition1.getId(), buildDefinition2.getId());
                }
            });
            Iterator<IBuildDefinition> iter = supportedDefinitions.iterator();
            while (iter.hasNext()) {
                IBuildDefinition definition = iter.next();
                HTMLGenerator.Link link = this.createItemLink((HTMLGenerator.Composite)section, (IItemHandle)definition, teamRepository, monitor);
                this.createLabel((HTMLGenerator.Composite)link, definition.getId());
                isSectionEmpty = false;
                if (!iter.hasNext()) continue;
                this.createLineBreak((HTMLGenerator.Composite)section);
            }
            if (isSectionEmpty) {
                this.createLabel((HTMLGenerator.Composite)section, NLS.bind((String)TooltipsGeneratorsMessages.BuildEngineHTMLGenerator_NO_SUPPORTED_BUILD_DEFINITIONS, (Object)this.fBuildEngineStatusRecord.getBuildEngine().getId()));
            }
        }
    }

    protected List<IBuildDefinition> fetchBuildDefinitions(ITeamRepository teamRepository, List<IBuildDefinitionHandle> buildDefinitionHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        List definitions = teamRepository.itemManager().fetchCompleteItems(this.fBuildEngineStatusRecord.getBuildEngine().getSupportedBuildDefinitions(), 0, monitor);
        ArrayList<IBuildDefinition> nonNullDefinitions = new ArrayList<IBuildDefinition>();
        for (IBuildDefinition current : definitions) {
            if (current == null) continue;
            nonNullDefinitions.add(current);
        }
        return nonNullDefinitions;
    }

    private void createIsActiveLabel(HTMLGenerator.Composite composite) {
        String labelText = this.fBuildEngineStatusRecord.getBuildEngine().isActive() ? TooltipsGeneratorsMessages.BuildEngineHTMLGenerator_ACTIVE : TooltipsGeneratorsMessages.BuildEngineHTMLGenerator_NOT_ACTIVE;
        this.createLabel(composite, labelText);
    }

    protected void createLastContactTimeLabel(HTMLGenerator.Composite composite) {
        String readableLastContact;
        String labelText = null;
        Timestamp lastContactTimestamp = this.fBuildEngineStatusRecord.getLastContactTime();
        labelText = lastContactTimestamp == null ? TooltipsGeneratorsMessages.BuildEngineHTMLGenerator_NO_CONTACT_TIME : (readableLastContact = TimeFormatHelper.getReadableTimeDif((Date)lastContactTimestamp));
        this.createLabel(composite, labelText);
    }

    protected IBuildEngineStatusRecord fetchBuildEngineStatusRecord(IProgressMonitor monitor) throws TeamRepositoryException {
        ITeamBuildRecordClient client = (ITeamBuildRecordClient)this.getTeamRepository((IItemHandle)this.fBuildEngineHandle).getClientLibrary(ITeamBuildRecordClient.class);
        return client.getBuildEngineStatusRecord(this.fBuildEngineHandle, monitor);
    }
}

