/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.tooltips.generators;

import com.ibm.team.build.common.model.BuildState;
import com.ibm.team.build.common.model.BuildStatus;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.internal.common.helper.BuildActivityHelper;
import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.common.model.dto.IBuildResultRecord;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.helper.BuildResultTextHelper;
import com.ibm.team.build.internal.ui.tooltips.generators.TooltipsGeneratorsMessages;
import com.ibm.team.foundation.common.URIReference;
import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.foundation.rcp.core.hyperlinks.Hyperlinks;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.jface.itemview.MarkupUtil;
import com.ibm.team.jface.preview.HTMLGenerator;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.Location;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;

public abstract class AbstractBuildHTMLGenerator
extends HTMLGenerator {
    public static final String GENERAL_CSS = "BUILD_CSS";
    protected static final int MAX_RESULT_COUNT = 10;

    public void generateHead(HashMap map) {
        if (map.containsKey(GENERAL_CSS)) {
            return;
        }
        StringBuffer css = new StringBuffer();
        css.append("<style type=\"text/css\">");
        css.append("body { overflow: auto; }\n");
        css.append("p.teaser { ").append(MarkupUtil.getDefaultFont()).append(" }\n");
        css.append(".boldgrey { font-weight: bold; color: #666666}\n");
        css.append(".");
        css.append("bold");
        css.append(" { font-weight: bold;}\n");
        css.append(".");
        css.append("red");
        css.append(" { color: red;}\n");
        css.append("table.");
        css.append("properties");
        css.append(" { border-collapse: collapse; empty-cells: show; border: 1px solid #E5E5E5; ").append(MarkupUtil.getDefaultFont()).append(" }\n");
        css.append("table.");
        css.append("details");
        css.append(" { empty-cells:hide; border: 1px solid #E5E5E5; ").append(MarkupUtil.getDefaultFont()).append(" }\n");
        css.append("table.");
        css.append("results");
        css.append(" { empty-cells:hide; ").append(MarkupUtil.getDefaultFont()).append(" }\n");
        css.append("table.");
        css.append("layout");
        css.append(" { empty-cells:hide; margin-left: -1px; ").append(MarkupUtil.getDefaultFont()).append(" }\n");
        css.append("table.").append("nowrap").append(" { empty-cells:hide; ").append(MarkupUtil.getDefaultFont()).append(" }\n");
        css.append("table.").append("nowrap").append(".td {white-space:nowrap; }\n");
        css.append("td { border-top: 1px solid #CCCCCC; vertical-align: top; }\n");
        css.append("td.");
        css.append("borderless");
        css.append(" {border: 0px; text-align: left; vertical-align: top; padding-left: 0px; }\n");
        css.append("td.");
        css.append("all").append(" { border: 1px solid #CCCCCC; }\n");
        css.append("td.").append("padded-right").append(" { padding-right: 8px;} \n");
        css.append("tr.");
        css.append("first");
        css.append(" td { border-top: 0px; }\n");
        css.append("div.");
        css.append("outermost");
        css.append(" {margin: 8px 8px 8px 8px }\n");
        css.append("div.");
        css.append("noindent");
        css.append(" {margin: 0px 0px 0px 0px }\n");
        css.append("div.");
        css.append("okstatus");
        css.append(" {background: lightgreen; float: left; clear: left; width: 50%; left: 55%; }\n");
        css.append("div.");
        css.append("warningstatus");
        css.append(" {background: yellow; float: left; clear: left; width: 50%; left: 55%; }\n");
        css.append("div.");
        css.append("errorstatus");
        css.append(" {background: mistyrose; float: left; clear: left; width: 50%; left: 55%; }\n");
        css.append("div.");
        css.append("right");
        css.append(" {float: right; width: 50%; left: 55%; padding-bottom: 5%; }\n");
        css.append("div.").append("left");
        css.append(" {float: left; clear: left; width: 50%; left: 55%; padding-bottom: 5%; }\n");
        if (this.getInfo().isHoverTooltip) {
            css.append("a:link { text-decoration: none; color: black; }\n");
        } else {
            css.append("a:link { color: #0000FF; text-decoration: none; }\n");
        }
        if (this.getInfo().isHoverTooltip) {
            css.append("a:visited { color: black; text-decoration: none; }\n");
        } else {
            css.append("a:visited { color: #0000FF; text-decoration: none; }\n");
        }
        css.append("a:hover { color: #000080; text-decoration: underline; }\n");
        css.append("ul { list-style-type: none; }\n");
        css.append("</style>");
        map.put(GENERAL_CSS, css.toString());
    }

    protected abstract void createFocusControl(HTMLGenerator.Composite var1, IProgressMonitor var2);

    protected abstract void createHoverControl(HTMLGenerator.Composite var1, IProgressMonitor var2);

    protected ITeamRepository getTeamRepository(IItemHandle itemHandle) {
        Object originObject;
        if (itemHandle != null && (originObject = itemHandle.getOrigin()) != null && originObject instanceof ITeamRepository) {
            return (ITeamRepository)originObject;
        }
        return null;
    }

    protected String getStatusImageURL(BuildStatus status) {
        ImageDescriptor image;
        if (status == BuildStatus.ERROR) {
            image = BuildUIPlugin.getImageDescriptor("icons/ovr16/failed_ovr.gif");
            JazzResources.registerPath((ImageDescriptor)image, (String)"com.ibm.team.build.ui", (String)"icons/ovr16/failed_ovr.gif");
        } else if (status == BuildStatus.WARNING) {
            image = BuildUIPlugin.getImageDescriptor("icons/ovr16/warn_ovr.gif");
            JazzResources.registerPath((ImageDescriptor)image, (String)"com.ibm.team.build.ui", (String)"icons/ovr16/warn_ovr.gif");
        } else {
            image = BuildUIPlugin.getImageDescriptor("icons/ovr16/success_ovr.gif");
            JazzResources.registerPath((ImageDescriptor)image, (String)"com.ibm.team.build.ui", (String)"icons/ovr16/success_ovr.gif");
        }
        return JazzResources.createDataURLForImageDescriptor((ImageDescriptor)image);
    }

    protected HTMLGenerator.Link createItemLink(HTMLGenerator.Composite parent, IItemHandle item, ITeamRepository repository, IProgressMonitor monitor) {
        URIReference uriReference = Hyperlinks.create((Object)item, (IProgressMonitor)monitor);
        if (uriReference == null) {
            URI itemUri = Location.itemLocation((IItemHandle)item, (String)repository.getRepositoryURI()).toAbsoluteUri();
            return new HTMLGenerator.Link((HTMLGenerator)this, parent, itemUri.toString());
        }
        return new HTMLGenerator.Link((HTMLGenerator)this, parent, uriReference.getURI().toString());
    }

    protected void createControl(HTMLGenerator.Composite composite, IProgressMonitor progressMonitor) {
        if (this.getInfo().isHoverTooltip) {
            this.createHoverControl(composite, progressMonitor);
        } else if (this.getInfo().isFocusTooltip) {
            this.createFocusControl(composite, progressMonitor);
        }
    }

    protected void createControl(HTMLGenerator.Composite composite) {
        this.createControl(composite, (IProgressMonitor)new NullProgressMonitor());
    }

    protected void createBuildsSection(HTMLGenerator.Composite composite, IBuildResultRecord[] records, int totalNumRecords, ITeamRepository repository, IProgressMonitor monitor) {
        ValidationHelper.validateNotNull((String)"composite", (Object)composite);
        ValidationHelper.validateNotNull((String)"records", (Object[])records);
        ValidationHelper.validateNotNullElements((String)"records", (Object[])records);
        int numberOfResultsToShow = Math.min(10, records.length);
        String sectionTitle = numberOfResultsToShow < totalNumRecords ? NLS.bind((String)TooltipsGeneratorsMessages.AbstractBuildHTMLGenerator_BUILD_SECTION_TITLE_TRUNCATED_LIST, (Object)10, (Object)totalNumRecords) : TooltipsGeneratorsMessages.BuildDefinitionHTMLGenerator_BUILD_SECTION_TITLE;
        HTMLGenerator.Section resultSection = new HTMLGenerator.Section((HTMLGenerator)this, composite, (HTMLGenerator.Control)this.createLabel(sectionTitle));
        if (records.length > 0) {
            int columns = 4;
            if (repository != null) {
                CustomTable table = this.createResultsTable((HTMLGenerator.Composite)resultSection, columns);
                int i = 0;
                while (i < numberOfResultsToShow) {
                    this.createResultTableRowHTML(table, records[i], repository, monitor);
                    ++i;
                }
            }
        } else {
            this.createLabel((HTMLGenerator.Composite)resultSection, TooltipsGeneratorsMessages.AbstractBuildHTMLGenerator_NO_BUILDS);
        }
    }

    protected void createResultTableRowHTML(CustomTable table, IBuildResultRecord record, ITeamRepository teamRepository, IProgressMonitor monitor) {
        IBuildResult result = record.getBuildResult();
        this.createLabel(table, "").setImage(this.getStatusImageURL(result.getStatus()));
        this.createLabel(table, "").setImage(this.getStateImageURL(result));
        if (result.getState() == BuildState.NOT_STARTED) {
            this.createLabel(table, record.getBuildDefinition().getId());
        } else {
            HTMLGenerator.Link link = this.createItemLink(table, (IItemHandle)result, teamRepository, monitor);
            this.createLabel((HTMLGenerator.Composite)link, BuildResultTextHelper.getLabel(result));
        }
        if (result.getState() == BuildState.IN_PROGRESS) {
            String activityLabel = BuildActivityHelper.getCurrentActivityText((Collection)record.getCurrentBuildActivities());
            if (!activityLabel.equals("")) {
                this.createLabel(table, NLS.bind((String)TooltipsGeneratorsMessages.BuildEngineHTMLGenerator_CURRENT_ACTIVITY_INTRO, (Object)activityLabel));
            } else {
                this.createBlankCell(table);
            }
        } else {
            this.createBlankCell(table);
        }
    }

    protected CustomTable createResultsTable(HTMLGenerator.Composite parent, int columns) {
        CustomTable table = new CustomTable(parent, columns);
        table.setCSSClass("results");
        table.setFirstRowCSSClass("first");
        return table;
    }

    protected CustomTable createLayoutTable(HTMLGenerator.Composite parent, int columns) {
        CustomTable table = new CustomTable(parent, columns);
        table.setCSSClass("layout");
        table.setFirstRowCSSClass("first");
        table.setBorderCSSClass("borderless");
        return table;
    }

    protected HTMLGenerator.Section createNonIndentedSection(HTMLGenerator.Composite parent, HTMLGenerator.Control title) {
        HTMLGenerator.Section section = new HTMLGenerator.Section((HTMLGenerator)this, parent, title);
        section.setCSSClass("noindent");
        return section;
    }

    protected HTMLGenerator.Label createLabel(String plainText) {
        return this.createLabel(null, plainText);
    }

    protected HTMLGenerator.Label createLabel(HTMLGenerator.Composite parent, String plainText) {
        return new HTMLGenerator.Label((HTMLGenerator)this, parent, XMLString.createFromPlainText((String)plainText));
    }

    protected HTMLGenerator.Label createLabelFromXML(HTMLGenerator.Composite parent, String xmlText) {
        return new HTMLGenerator.Label((HTMLGenerator)this, parent, XMLString.createFromXMLText((String)xmlText));
    }

    protected void createEmptyCell(CustomTable parent) {
        this.createLabel(parent, "");
    }

    protected void createBlankCell(CustomTable parent) {
        this.createLabelFromXML(parent, "&nbsp;");
    }

    protected HTMLGenerator.LineBreak createLineBreak(HTMLGenerator.Composite parent) {
        return new HTMLGenerator.LineBreak((HTMLGenerator)this, parent);
    }

    protected String escape(String plainText) {
        return XMLString.createFromPlainText((String)plainText).getXMLText();
    }

    protected String getStateImageURL(IBuildResult result) {
        BuildState state = result.getState();
        ImageDescriptor image = BuildUIPlugin.getImageDescriptor("icons/obj16/bld_rslt.gif");
        JazzResources.registerPath((ImageDescriptor)image, (String)"com.ibm.team.build.ui", (String)"icons/obj16/bld_rslt.gif");
        if (state == BuildState.IN_PROGRESS) {
            image = BuildUIPlugin.getImageDescriptor("icons/obj16/rung_bld.gif");
            JazzResources.registerPath((ImageDescriptor)image, (String)"com.ibm.team.build.ui", (String)"icons/obj16/rung_bld.gif");
        } else if (state == BuildState.INCOMPLETE) {
            image = BuildUIPlugin.getImageDescriptor("icons/obj16/bldrsltabandoned_obj.gif");
            JazzResources.registerPath((ImageDescriptor)image, (String)"com.ibm.team.build.ui", (String)"icons/obj16/bldrsltabandoned_obj.gif");
        } else if (state == BuildState.CANCELED) {
            image = BuildUIPlugin.getImageDescriptor("icons/obj16/build_result_obj.gif");
            JazzResources.registerPath((ImageDescriptor)image, (String)"com.ibm.team.build.ui", (String)"icons/obj16/build_result_obj.gif");
        } else if (state == BuildState.NOT_STARTED) {
            image = BuildUIPlugin.getImageDescriptor("icons/obj16/pendingblds_obj.gif");
            JazzResources.registerPath((ImageDescriptor)image, (String)"com.ibm.team.build.ui", (String)"icons/obj16/pendingblds_obj.gif");
        }
        return JazzResources.createDataURLForImageDescriptor((ImageDescriptor)image);
    }

    protected SubProgressMonitor createSubMonitor(IProgressMonitor parent, int ticks) {
        if (parent == null) {
            parent = new NullProgressMonitor();
        }
        return new SubProgressMonitor(parent, ticks);
    }

    protected class Cell
    extends HTMLGenerator.Composite {
        public Cell(CustomTable parent) {
            super((HTMLGenerator)AbstractBuildHTMLGenerator.this, (HTMLGenerator.Composite)parent);
        }

        public void appendTo(StringBuffer buffer) {
            HTMLGenerator.Control[] controls = this.getComponents();
            int i = 0;
            while (i < controls.length) {
                controls[i].appendTo(buffer);
                ++i;
            }
        }
    }

    public class CustomTable
    extends HTMLGenerator.Composite {
        private int fColumns;
        private String fFirstRowCss;
        private String fBorderCss;

        public CustomTable(HTMLGenerator.Composite parent, int columns) {
            super((HTMLGenerator)AbstractBuildHTMLGenerator.this, parent);
            this.fColumns = columns;
        }

        public void setFirstRowCSSClass(String clazz) {
            this.fFirstRowCss = clazz;
        }

        public void setBorderCSSClass(String clazz) {
            this.fBorderCss = clazz;
        }

        public void appendTo(StringBuffer buffer) {
            int row = 0;
            int column = 0;
            buffer.append("<table");
            if (this.getCSSClass() != null) {
                buffer.append(" class=\"");
                buffer.append(this.getCSSClass());
                buffer.append("\"");
            }
            buffer.append(">");
            HTMLGenerator.Control[] components = this.getComponents();
            int i = 0;
            while (i < components.length) {
                HTMLGenerator.Control control = components[i];
                if (column == 0) {
                    buffer.append("\n <tr");
                    if (row == 0 && this.fFirstRowCss != null) {
                        buffer.append(" class=\"");
                        buffer.append(this.fFirstRowCss);
                        buffer.append("\"");
                    }
                    buffer.append(">");
                }
                buffer.append("\n    <td");
                if (this.fBorderCss != null) {
                    buffer.append(" class=\"");
                    buffer.append(this.fBorderCss);
                    buffer.append("\"");
                }
                buffer.append(">");
                control.appendTo(buffer);
                buffer.append("</td>");
                if (++column >= this.fColumns) {
                    buffer.append("\n  </tr>");
                    column = 0;
                    ++row;
                }
                ++i;
            }
            buffer.append("\n</table>");
        }
    }
}

