/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.tooltips.adaptors.domain;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.common.model.dto.IBuildEngineStatusRecord;
import com.ibm.team.build.internal.ui.domain.BuildDefinitionQueryNode;
import com.ibm.team.build.internal.ui.domain.BuildDomainQueryNode;
import com.ibm.team.build.internal.ui.domain.BuildEngineQueryNode;
import com.ibm.team.build.internal.ui.query.BuildQuery;
import com.ibm.team.build.internal.ui.tooltips.adaptors.domain.AbstractBuildDomainAdapter;
import com.ibm.team.build.internal.ui.tooltips.generators.BuildDefinitionHTMLGenerator;
import com.ibm.team.build.internal.ui.tooltips.generators.BuildEngineStatusRecordHTMLGenerator;
import com.ibm.team.build.internal.ui.tooltips.generators.BuildQueryHTMLGenerator;
import com.ibm.team.jface.preview.HTMLGenerator;
import com.ibm.team.jface.preview.IDomainAdapter;
import com.ibm.team.process.common.IProjectAreaHandle;
import org.eclipse.core.runtime.IProgressMonitor;

public class BuildDomainAdapter
extends AbstractBuildDomainAdapter
implements IDomainAdapter {
    protected Object convertToDomainObject(Object object) {
        if (object instanceof BuildDomainQueryNode) {
            return object;
        }
        return null;
    }

    @Override
    protected HTMLGenerator getGenerator(Object input, IProgressMonitor monitor) {
        HTMLGenerator generator = null;
        if (input instanceof BuildEngineQueryNode) {
            IBuildEngineStatusRecord record = ((BuildEngineQueryNode)input).getBuildEngineStatusRecord();
            IProjectAreaHandle projectAreaHandle = ((BuildEngineQueryNode)input).getProjectAreaHandle();
            generator = this.createHTMLGenerator(record, projectAreaHandle);
        } else if (input instanceof BuildDefinitionQueryNode) {
            IBuildDefinition definition = ((BuildDefinitionQueryNode)input).getBuildDefinition();
            generator = this.createHTMLGenerator(definition);
        } else {
            BuildDomainQueryNode node = (BuildDomainQueryNode)input;
            generator = this.createHTMLGenerator(node.getQuery());
        }
        return generator;
    }

    protected HTMLGenerator createHTMLGenerator(IBuildEngineStatusRecord record, IProjectAreaHandle projectAreaHandle) {
        ValidationHelper.validateNotNull((String)"record", (Object)record);
        return new BuildEngineStatusRecordHTMLGenerator(record, projectAreaHandle);
    }

    protected HTMLGenerator createHTMLGenerator(IBuildDefinition definition) {
        return new BuildDefinitionHTMLGenerator(definition);
    }

    protected HTMLGenerator createHTMLGenerator(BuildQuery query) {
        return new BuildQueryHTMLGenerator(query);
    }
}

