/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.tooltips.adaptors.domain;

import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.build.internal.client.ITeamBuildRecordClient;
import com.ibm.team.build.internal.common.model.dto.IBuildResultRecord;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.jobs.TeamBuildJobHelper;
import com.ibm.team.build.internal.ui.tooltips.adaptors.domain.AbstractBuildDomainAdapter;
import com.ibm.team.build.internal.ui.tooltips.adaptors.domain.TooltipDomainAdaptorMessages;
import com.ibm.team.build.internal.ui.tooltips.generators.BuildResultRecordHTMLGenerator;
import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.jface.preview.HTMLGenerator;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public abstract class AbstractBuildResultDomainAdapter
extends AbstractBuildDomainAdapter {
    protected HTMLGenerator createHTMLGenerator(IBuildResultHandle handle, ITeamRepository repository, IProgressMonitor monitor) {
        HTMLGenerator htmlGenerator = null;
        try {
            if (repository != null) {
                IBuildResultRecord resultRecord = this.fetchResultRecord(handle, repository, monitor);
                htmlGenerator = new BuildResultRecordHTMLGenerator(resultRecord);
            }
        }
        catch (ItemNotFoundException exception) {
            htmlGenerator = new HTMLGenerator(){

                protected void createControl(HTMLGenerator.Composite composite) {
                    new HTMLGenerator.Label((HTMLGenerator)this, composite, XMLString.createFromPlainText((String)TooltipDomainAdaptorMessages.BuildChangeEventDomainAdapter_ITEM_NOT_FOUND_MESSAGE));
                }
            };
        }
        catch (TeamRepositoryException exception) {
            BuildUIPlugin.log(exception);
            htmlGenerator = new HTMLGenerator(){

                protected void createControl(HTMLGenerator.Composite composite) {
                    new HTMLGenerator.Label((HTMLGenerator)this, composite, XMLString.createFromPlainText((String)TooltipDomainAdaptorMessages.BuildChangeEventDomainAdapter_ERROR_MESSAGE));
                    new HTMLGenerator.LineBreak((HTMLGenerator)this, composite);
                    new HTMLGenerator.Label((HTMLGenerator)this, composite, XMLString.createFromPlainText((String)TeamBuildJobHelper.getStatusMessage(exception)));
                }
            };
        }
        return htmlGenerator;
    }

    protected IBuildResultRecord fetchResultRecord(IBuildResultHandle handle, ITeamRepository repository, IProgressMonitor monitor) throws TeamRepositoryException {
        ITeamBuildRecordClient client = (ITeamBuildRecordClient)repository.getClientLibrary(ITeamBuildRecordClient.class);
        return client.getBuildResultRecord(handle, IBuildResult.PROPERTIES_VIEW_ITEM, (IProgressMonitor)(monitor != null ? new SubProgressMonitor(monitor, 1) : monitor));
    }

    public String generateTitle(Object input) {
        return TooltipDomainAdaptorMessages.AbstractBuildResultDomainAdapter_BUILD_RESULT_TITLE;
    }
}

