/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.tooltips;

import com.ibm.team.build.common.model.IBuildEngine;
import com.ibm.team.build.common.model.IBuildEngineHandle;
import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.helper.ItemNotFoundHelper;
import com.ibm.team.build.internal.ui.tooltips.AbstractBuildItemHyperlinkHandler;
import com.ibm.team.build.internal.ui.tooltips.TooltipsMessages;
import com.ibm.team.build.internal.ui.tooltips.jobs.OpenBuildEngineEditorJob;
import com.ibm.team.foundation.common.URIReference;
import com.ibm.team.foundation.rcp.core.hyperlinks.ContextProvider;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.net.URI;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class BuildEngineHyperlinkHandler
extends AbstractBuildItemHyperlinkHandler {
    public Object resolve(URI uri, ContextProvider provider) throws TeamRepositoryException {
        Location location = this.getLocationForUriNoException(uri);
        if (location == null) {
            return null;
        }
        IBuildEngineHandle buildEngineHandle = this.getBuildEngineHandle(location);
        if (buildEngineHandle == null) {
            return null;
        }
        ITeamRepository teamRepository = this.getTeamRepository(location, null);
        if (teamRepository == null) {
            return null;
        }
        return (IBuildEngine)teamRepository.itemManager().fetchCompleteItem((IItemHandle)buildEngineHandle, 0, null);
    }

    public boolean links(Object object) {
        if (object instanceof IBuildEngineHandle) {
            return true;
        }
        return super.links(object);
    }

    public URIReference createHyperlink(Object object, IProgressMonitor monitor) {
        ITeamRepository teamRepository;
        IBuildEngineHandle buildEngineHandle;
        URI uri;
        if (object instanceof IBuildEngineHandle && (uri = BuildEngineHyperlinkHandler.getAbsoluteURI((IItemHandle)(buildEngineHandle = (IBuildEngineHandle)object), teamRepository = (ITeamRepository)buildEngineHandle.getOrigin())) != null) {
            IBuildEngine buildEngine;
            try {
                buildEngine = this.getBuildEngineForCreateHyperlink(buildEngineHandle, teamRepository);
            }
            catch (TeamRepositoryException exception) {
                BuildUIPlugin.log(exception);
                return null;
            }
            if (buildEngine != null) {
                String label = buildEngine.getId();
                String details = NLS.bind((String)TooltipsMessages.BuildEngineHyperlinkHandler_LINK_TEXT, (Object)buildEngine.getId());
                return new URIReference(label, details, uri);
            }
        }
        return super.createHyperlink(object, monitor);
    }

    public IStatus open2(URI uri, ContextProvider provider, IProgressMonitor monitor) {
        try {
            IBuildEngine buildEngine = this.fetchBuildEngine(uri, monitor);
            IProcessArea processArea = this.fetchProcessArea(buildEngine, monitor);
            new OpenBuildEngineEditorJob(buildEngine, processArea, (ITeamRepository)buildEngine.getOrigin(), null).schedule();
            return Status.OK_STATUS;
        }
        catch (ItemNotFoundException exception) {
            ItemNotFoundHelper.handleDeletedBuildItem((IItemHandle)exception.getData(), 4);
            return Status.OK_STATUS;
        }
        catch (TeamRepositoryException exception) {
            BuildUIPlugin.log(exception);
            return new Status(4, BuildUIPlugin.getUniqueIdentifier(), 4, TooltipsMessages.BuildEngineHyperlinkHandler_EXCEPTION_FETCHING_ENGINE, (Throwable)exception);
        }
    }

    protected IBuildEngine fetchBuildEngine(URI uri, IProgressMonitor monitor) throws TeamRepositoryException {
        Location location = this.getLocationFor(uri);
        if (location == null) {
            throw new TeamRepositoryException(NLS.bind((String)TooltipsMessages.BuildEngineHyperlinkHandler_INVALID_URI, (Object)uri.toString()));
        }
        ITeamRepository repository = this.getTeamRepository(location, null);
        if (repository == null) {
            throw new TeamRepositoryException(NLS.bind((String)TooltipsMessages.BuildEngineHyperlinkHandler_NO_REPOSITORY, (Object)uri.toString()));
        }
        IBuildEngineHandle buildEngineHandle = this.getBuildEngineHandle(location);
        if (buildEngineHandle == null) {
            throw new TeamRepositoryException(NLS.bind((String)TooltipsMessages.BuildEngineHyperlinkHandler_NO_BUILD_ENGINE, (Object)uri.toString()));
        }
        return (IBuildEngine)repository.itemManager().fetchCompleteItem((IItemHandle)buildEngineHandle, 0, monitor);
    }

    private IProcessArea fetchProcessArea(IBuildEngine buildEngine, IProgressMonitor monitor) throws TeamRepositoryException {
        ITeamRepository repository = (ITeamRepository)buildEngine.getOrigin();
        return (IProcessArea)repository.itemManager().fetchCompleteItem((IItemHandle)buildEngine.getProcessArea(), 0, monitor);
    }

    protected boolean hasRequiredCreateHyperlinkProperties(IBuildEngine buildEngine) {
        return buildEngine.isPropertySet(IBuildEngine.PROPERTY_ID);
    }

    public boolean handles(URI uri) {
        if (uri.getQuery() != null) {
            return false;
        }
        Location location = this.getLocationForUriNoException(uri);
        if (location == null) {
            return false;
        }
        IBuildEngineHandle buildEngineHandle = this.getBuildEngineHandle(location);
        return buildEngineHandle != null;
    }

    protected IBuildEngineHandle getBuildEngineHandle(Location location) {
        ValidationHelper.validateNotNull((String)"location", (Object)location);
        if (location.getItemHandle() instanceof IBuildEngineHandle) {
            return (IBuildEngineHandle)location.getItemHandle();
        }
        return null;
    }

    protected IBuildEngine getBuildEngineForCreateHyperlink(IBuildEngineHandle buildEngineHandle, ITeamRepository teamRepository) throws TeamRepositoryException {
        IBuildEngine buildEngine;
        ValidationHelper.validateNotNull((String)"buildEngineHandle", (Object)buildEngineHandle);
        if (teamRepository == null) {
            return null;
        }
        if (buildEngineHandle instanceof IBuildEngine && this.hasRequiredCreateHyperlinkProperties(buildEngine = (IBuildEngine)buildEngineHandle)) {
            return buildEngine;
        }
        ArrayList<String> properties = new ArrayList<String>();
        properties.add(IBuildEngine.PROPERTY_ID);
        return (IBuildEngine)teamRepository.itemManager().fetchPartialItem((IItemHandle)buildEngineHandle, 0, properties, null);
    }
}

