/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.tooltips;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildEngine;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.foundation.rcp.core.hyperlinks.HyperlinkHandler;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.net.URI;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class AbstractBuildItemHyperlinkHandler
extends HyperlinkHandler {
    public static URI getAbsoluteURI(IItemHandle buildItemHandle, ITeamRepository teamRepository) {
        ValidationHelper.validateNotNull((String)"buildItemHandle", (Object)buildItemHandle);
        if (teamRepository == null) {
            return null;
        }
        try {
            Location location = Location.itemLocation((IItemHandle)buildItemHandle, (String)AbstractBuildItemHyperlinkHandler.getRepositoryUri(teamRepository));
            return location.toAbsoluteUri();
        }
        catch (Exception exception) {
            BuildUIPlugin.log(exception);
            return null;
        }
    }

    private static String getRepositoryUri(ITeamRepository repository) {
        String publicUriRoot = repository.publicUriRoot();
        if (publicUriRoot != null) {
            return publicUriRoot;
        }
        return repository.getRepositoryURI();
    }

    public boolean resolves(URI uri) {
        return this.handles(uri);
    }

    protected Location getLocationFor(URI uri) throws TeamRepositoryException {
        if (uri == null) {
            return null;
        }
        Location location = Location.location((URI)uri);
        if (!location.isAbsolute()) {
            return null;
        }
        return location;
    }

    protected Location getLocationForUriNoException(URI uri) {
        try {
            return this.getLocationFor(uri);
        }
        catch (TeamRepositoryException exception) {
            return null;
        }
        catch (IllegalArgumentException exception) {
            return null;
        }
    }

    protected ITeamRepository getTeamRepository(Location location, IProgressMonitor monitor) throws TeamRepositoryException {
        ValidationHelper.validateNotNull((String)"location", (Object)location);
        return this.getTeamRepository(location.getRepoUri(), monitor);
    }

    protected ITeamRepository getTeamRepository(String uri, IProgressMonitor monitor) throws TeamRepositoryException {
        ITeamRepository[] repositories;
        String repositoryURI = this.stripTrailingSlash(uri);
        ITeamRepository[] iTeamRepositoryArray = repositories = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
        int n = repositories.length;
        int n2 = 0;
        while (n2 < n) {
            ITeamRepository teamRepository = iTeamRepositoryArray[n2];
            if (this.stripTrailingSlash(teamRepository.getRepositoryURI()).equals(repositoryURI) && teamRepository.loggedIn()) {
                return teamRepository;
            }
            ++n2;
        }
        try {
            return TeamPlatform.getTeamRepositoryService().getTeamRepository(repositoryURI, monitor);
        }
        catch (IllegalArgumentException exception) {
            return null;
        }
    }

    private String stripTrailingSlash(String string) {
        if (string != null && string.endsWith("/")) {
            return string.substring(0, string.length() - 1);
        }
        return string;
    }

    public IItemType guessItemType(URI uri) {
        String uriString = uri.toString();
        if (uriString.contains("com.ibm.team.build.viewEngineResults")) {
            return IBuildEngine.ITEM_TYPE;
        }
        if (uriString.contains("com.ibm.team.build.viewDefinition")) {
            return IBuildDefinition.ITEM_TYPE;
        }
        if (uriString.contains("com.ibm.team.build.viewResult")) {
            return IBuildResult.ITEM_TYPE;
        }
        return super.guessItemType(uri);
    }
}

