/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.teamcentral;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.domain.BuildDefinitionQueryNode;
import com.ibm.team.build.internal.ui.listeners.AbstractBuildDefinitionChangeListener;
import com.ibm.team.build.internal.ui.teamcentral.BuildSectionContentProvider;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.viewers.StructuredViewer;

public class BuildSectionItemChangeListener
extends AbstractBuildDefinitionChangeListener {
    private BuildSectionContentProvider fContentProvider;

    public BuildSectionItemChangeListener(BuildSectionContentProvider buildSectionContentProvider, List<BuildDefinitionQueryNode> nodes) throws IllegalArgumentException {
        ValidationHelper.validateNotNull((String)"nodes", nodes);
        this.fContentProvider = buildSectionContentProvider;
        for (BuildDefinitionQueryNode buildDefinitionQueryNode : nodes) {
            this.getItemIdToNodesMap().put(buildDefinitionQueryNode.getBuildDefinition().getItemId().getUuidValue(), buildDefinitionQueryNode);
        }
    }

    @Override
    protected Object getParent() {
        return null;
    }

    @Override
    protected IProjectAreaHandle getProjectAreaHandle() {
        return null;
    }

    @Override
    protected boolean shouldShowDefinition(IBuildDefinition definition, IProgressMonitor monitor) {
        if (this.isSectionCustomized()) {
            return false;
        }
        Object originObject = definition.getOrigin();
        if (!(originObject instanceof ITeamRepository)) {
            return false;
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            IProcessAreaHandle processAreaHandle;
            ITeamRepository repository = (ITeamRepository)originObject;
            IContributor user = repository.loggedInContributor();
            if (!definition.isPropertySet(IBuildDefinition.PROPERTY_PROCESS_AREA)) {
                definition = (IBuildDefinition)repository.itemManager().fetchCompleteItem((IItemHandle)definition, 0, (IProgressMonitor)progress.newChild(50));
            }
            if ((processAreaHandle = definition.getProcessArea()) != null) {
                IProcessArea processArea = (IProcessArea)repository.itemManager().fetchCompleteItem((IItemHandle)processAreaHandle, 0, (IProgressMonitor)progress.newChild(50));
                return processArea.hasMember((IContributorHandle)user);
            }
            return false;
        }
        catch (TeamRepositoryException exception) {
            return false;
        }
    }

    @Override
    protected void addNodesToViewer(Object parent, Object[] nodes) {
        this.fContentProvider.addNodes(nodes);
    }

    @Override
    public StructuredViewer getViewer() {
        return this.fContentProvider.getTableViewer();
    }

    @Override
    protected void removeNodesFromViewer(Object parent, Object[] nodes) {
        this.fContentProvider.removeNodes(nodes);
    }

    protected boolean isSectionCustomized() {
        return BuildUIPlugin.getDefault().getPreferenceStore().getBoolean("team.central.build.section.is.customized");
    }
}

