/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.teamcentral;

import com.ibm.team.build.common.model.BuildStatus;
import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.internal.client.BuildRecordEventManager;
import com.ibm.team.build.internal.client.IBuildDefinitionStatusRecordListener;
import com.ibm.team.build.internal.client.ITeamBuildRecordClient;
import com.ibm.team.build.internal.common.model.dto.IBuildDefinitionStatusRecord;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.domain.BuildDefinitionQueryNode;
import com.ibm.team.build.internal.ui.helper.EnterpriseHelper;
import com.ibm.team.build.internal.ui.jobs.TeamBuildJob;
import com.ibm.team.build.internal.ui.listeners.AbstractBuildDefinitionChangeListener;
import com.ibm.team.build.internal.ui.listeners.BuildDefinitionStatusRecordListener;
import com.ibm.team.build.internal.ui.teamcentral.BuildSection;
import com.ibm.team.build.internal.ui.teamcentral.BuildSectionItemChangeListener;
import com.ibm.team.build.internal.ui.teamcentral.BuildSectionMessages;
import com.ibm.team.build.internal.ui.teamcentral.FetchSelectedBuildsStrategy;
import com.ibm.team.build.internal.ui.teamcentral.FetchTeamBuildsStrategy;
import com.ibm.team.build.internal.ui.teamcentral.IFetchStrategy;
import com.ibm.team.build.internal.ui.teamcentral.TeamRepositoryListener;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ISharedItemChangeListener;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.ITeamRepositoryService;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;

public class BuildSectionContentProvider
implements IStructuredContentProvider {
    protected TableViewer fTableViewer;
    private boolean fIsInitialized;
    private List<BuildDefinitionQueryNode> fBuildDefinitionQueryNodes;
    protected IBuildDefinitionStatusRecordListener fBuildDefinitionRecordListener;
    private Map<ITeamRepository, AbstractBuildDefinitionChangeListener> fRepositoryToItemChangeListeners;
    private BuildSection fBuildSection;
    private IFetchStrategy fFetchStrategy;
    private TeamRepositoryListener fTeamRepositoryListener;
    private boolean fUserInitiatedFetch;

    public BuildSectionContentProvider(BuildSection parent) {
        this.fBuildSection = parent;
        this.fRepositoryToItemChangeListeners = new HashMap<ITeamRepository, AbstractBuildDefinitionChangeListener>();
        this.fTeamRepositoryListener = new TeamRepositoryListener();
        this.startRepositoryListening();
    }

    private void startRepositoryListening() {
        ITeamRepositoryService teamRepositoryService = TeamPlatform.getTeamRepositoryService();
        teamRepositoryService.addRepositoryServiceListener((ITeamRepositoryService.IRepositoryServiceListener)this.fTeamRepositoryListener);
        ITeamRepository[] repositories = teamRepositoryService.getTeamRepositories();
        int i = 0;
        while (i < repositories.length) {
            repositories[i].addLoginParticipant((ITeamRepository.ILoginParticipant)this.fTeamRepositoryListener);
            ++i;
        }
    }

    private void stopRepositoryListening() {
        ITeamRepositoryService teamRepositoryService = TeamPlatform.getTeamRepositoryService();
        teamRepositoryService.removeRepositoryServiceListener((ITeamRepositoryService.IRepositoryServiceListener)this.fTeamRepositoryListener);
        ITeamRepository[] repositories = teamRepositoryService.getTeamRepositories();
        int i = 0;
        while (i < repositories.length) {
            repositories[i].removeLoginParticipant((ITeamRepository.ILoginParticipant)this.fTeamRepositoryListener);
            ++i;
        }
    }

    public Object[] getElements(Object inputElement) {
        if (!this.isInitialized()) {
            return new String[]{BuildSectionMessages.BuildEventSectionContentProvider_FETCH_JOB_NAME};
        }
        return this.fBuildDefinitionQueryNodes.toArray(new BuildDefinitionQueryNode[this.fBuildDefinitionQueryNodes.size()]);
    }

    public boolean isInitialized() {
        return this.fIsInitialized;
    }

    public void dispose() {
        this.removeListeners();
    }

    protected void removeListeners() {
        this.stopRepositoryListening();
        this.stopBuildRecordListening();
        this.stopAllItemChangeListening();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (viewer instanceof TableViewer) {
            this.fTableViewer = (TableViewer)viewer;
            this.fTeamRepositoryListener.setTableViewer(this.fTableViewer);
            this.fIsInitialized = false;
            if (newInput != null) {
                this.fFetchStrategy = this.createStrategy(newInput);
                this.initialize();
            }
        }
    }

    private IFetchStrategy createStrategy(Object newInput) {
        if (newInput instanceof List) {
            return new FetchSelectedBuildsStrategy((List)newInput);
        }
        return new FetchTeamBuildsStrategy();
    }

    private void initialize() {
        TeamBuildJob job = this.createFetchJob();
        this.scheduleJobWithProgress((Job)job);
    }

    protected void setFetchJobFlag(boolean isUserInitiated) {
        this.fUserInitiatedFetch = isUserInitiated;
    }

    protected TeamBuildJob createFetchJob() {
        String jobName = BuildSectionMessages.BuildEventSectionContentProvider_FETCH_JOB_NAME;
        return new TeamBuildJob(jobName, this.fUserInitiatedFetch){

            protected IStatus runProtected(IProgressMonitor monitor) throws TeamRepositoryException {
                ArrayList<TeamRepositoryException> errors = new ArrayList<TeamRepositoryException>();
                final int numberOfFailures = BuildSectionContentProvider.this.fetchAndCreateNodes(errors, monitor);
                BuildSectionContentProvider.this.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!BuildSectionContentProvider.this.isTableViewerDisposed()) {
                            BuildSectionContentProvider.this.getTableViewer().refresh();
                        }
                        BuildSectionContentProvider.this.updateHeader(numberOfFailures);
                    }
                });
                if (errors.size() > 0) {
                    IStatus[] childStatuses = new IStatus[errors.size()];
                    int i = 0;
                    while (i < childStatuses.length) {
                        ITeamRepository repository = (ITeamRepository)((TeamRepositoryException)((Object)errors.get(i))).getOrigin();
                        String repoId = repository.getName();
                        if (repoId == null || repoId.length() == 0) {
                            repoId = repository.getRepositoryURI();
                        }
                        String errorMessage = NLS.bind((String)BuildSectionMessages.BuildEventSectionContentProvider_ERRORS_DURING_FETCH_FROM_REPOSITORY_X, (Object)repoId);
                        childStatuses[i] = this.createStatus(errorMessage, (Exception)errors.get(i));
                        ++i;
                    }
                    if (childStatuses.length == 1) {
                        return childStatuses[0];
                    }
                    String message = BuildSectionMessages.BuildEventSectionContentProvider_ERRORS_DURING_FETCH;
                    return new MultiStatus(BuildUIPlugin.getUniqueIdentifier(), 0, childStatuses, message, null);
                }
                return Status.OK_STATUS;
            }
        };
    }

    private boolean isTableViewerDisposed() {
        TableViewer tableViewer = this.getTableViewer();
        return tableViewer == null || tableViewer.getTable().isDisposed();
    }

    protected synchronized int fetchAndCreateNodes(List<TeamRepositoryException> errors, IProgressMonitor monitor) {
        this.setBuildDefinitionQueryNodes(new ArrayList<BuildDefinitionQueryNode>());
        this.stopAllItemChangeListening();
        this.stopBuildRecordListening();
        ITeamRepository[] repositories = this.getFetchStrategy().getTeamRepositories();
        ArrayList<BuildDefinitionQueryNode> tempNodes = new ArrayList<BuildDefinitionQueryNode>();
        int i = 0;
        while (i < repositories.length) {
            ITeamRepository repository = repositories[i];
            try {
                IBuildDefinitionStatusRecord[] records = this.getFetchStrategy().fetchBuildDefinitionStatusRecords(repository, (IProgressMonitor)(monitor == null ? monitor : new SubProgressMonitor(monitor, 3)));
                tempNodes.clear();
                int recordIndex = 0;
                while (recordIndex < records.length) {
                    if (!EnterpriseHelper.isEnterpriseDefinition(records[recordIndex].getBuildDefinition())) {
                        BuildDefinitionQueryNode node = new BuildDefinitionQueryNode(repository, records[recordIndex]);
                        tempNodes.add(node);
                    }
                    ++recordIndex;
                }
                this.startItemChangeListening(repository, null, tempNodes);
                this.getBuildDefinitionQueryNodes().addAll(tempNodes);
            }
            catch (TeamRepositoryException exception) {
                if (exception.getOrigin() == null) {
                    exception.setOrigin((Object)repository);
                }
                errors.add(exception);
            }
            ++i;
        }
        this.startBuildRecordListening();
        this.fIsInitialized = true;
        int numberOfFailures = this.getNumberOfBuildsWithStatus(BuildStatus.ERROR);
        return numberOfFailures;
    }

    private void stopAllItemChangeListening() {
        Set<Map.Entry<ITeamRepository, AbstractBuildDefinitionChangeListener>> entrySet = this.fRepositoryToItemChangeListeners.entrySet();
        for (Map.Entry<ITeamRepository, AbstractBuildDefinitionChangeListener> entry : entrySet) {
            entry.getKey().itemManager().removeItemChangeListener(IBuildDefinition.ITEM_TYPE, (ISharedItemChangeListener)entry.getValue());
        }
        this.fRepositoryToItemChangeListeners.clear();
    }

    private void startItemChangeListening(ITeamRepository teamRepository, IProjectAreaHandle projectAreaHandle, List<BuildDefinitionQueryNode> nodes) {
        AbstractBuildDefinitionChangeListener newListener = this.createItemChangeListener(projectAreaHandle, nodes);
        this.fRepositoryToItemChangeListeners.put(teamRepository, newListener);
        teamRepository.itemManager().addItemChangeListener(IBuildDefinition.ITEM_TYPE, (ISharedItemChangeListener)newListener);
    }

    private AbstractBuildDefinitionChangeListener createItemChangeListener(IProjectAreaHandle projectAreaHandle, List<BuildDefinitionQueryNode> nodes) {
        return new BuildSectionItemChangeListener(this, nodes);
    }

    protected void startBuildRecordListening() {
        if (this.fBuildDefinitionRecordListener != null) {
            BuildRecordEventManager.getInstance().removeListener(this.fBuildDefinitionRecordListener);
        }
        BuildDefinitionQueryNode[] nodes = this.getBuildDefinitionQueryNodes().toArray(new BuildDefinitionQueryNode[this.getBuildDefinitionQueryNodes().size()]);
        this.fBuildDefinitionRecordListener = new BuildDefinitionStatusRecordListener((StructuredViewer)this.getTableViewer(), nodes){

            @Override
            public void recordsReceived(IBuildDefinitionStatusRecord[] records) {
                super.recordsReceived(records);
                final int count = BuildSectionContentProvider.this.getNumberOfBuildsWithStatus(BuildStatus.ERROR);
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        BuildSectionContentProvider.this.updateHeader(count);
                    }
                });
            }
        };
        BuildRecordEventManager.getInstance().addListener(this.fBuildDefinitionRecordListener);
    }

    protected void stopBuildRecordListening() {
        if (this.fBuildDefinitionRecordListener != null) {
            BuildRecordEventManager.getInstance().removeListener(this.fBuildDefinitionRecordListener);
        }
        this.fBuildDefinitionRecordListener = null;
    }

    protected boolean isRepositoryOfInterest(ITeamRepository repository) {
        return this.fRepositoryToItemChangeListeners.containsKey(repository);
    }

    protected void scheduleJobWithProgress(Job job) {
        this.fBuildSection.getSectionSite().getProgressService().schedule(job);
    }

    protected void asyncExec(Runnable runnable) {
        Display.getDefault().asyncExec(runnable);
    }

    protected IBuildDefinitionStatusRecord[] getBuildDefinitionStatusRecords(ITeamBuildRecordClient client, Set<String> buildDefinitionsToRefresh, IProgressMonitor progressMonitor) throws TeamRepositoryException {
        return client.getBuildDefinitionStatusRecords(buildDefinitionsToRefresh.toArray(new String[buildDefinitionsToRefresh.size()]), progressMonitor);
    }

    public TableViewer getTableViewer() {
        return this.fTableViewer;
    }

    protected void setBuildDefinitionQueryNodes(List<BuildDefinitionQueryNode> nodes) {
        this.fBuildDefinitionQueryNodes = nodes;
    }

    public List<BuildDefinitionQueryNode> getBuildDefinitionQueryNodes() {
        return this.fBuildDefinitionQueryNodes;
    }

    protected IBuildDefinitionStatusRecordListener getBuildDefinitionRecordListener() {
        return this.fBuildDefinitionRecordListener;
    }

    protected void updateHeader(int numberOfFailedBuilds) {
        if (this.fBuildSection != null) {
            this.fBuildSection.updateTeaser(numberOfFailedBuilds);
        }
    }

    public synchronized int getNumberOfBuildsWithStatus(BuildStatus status) {
        if (!this.isInitialized()) {
            return 0;
        }
        int numberBuilds = 0;
        for (BuildDefinitionQueryNode node : this.getBuildDefinitionQueryNodes()) {
            if (!status.equals((Object)node.getStatus())) continue;
            ++numberBuilds;
        }
        return numberBuilds;
    }

    protected void removeNodes(Object[] nodes) {
        Object[] objectArray = nodes;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            this.getBuildDefinitionQueryNodes().remove(object);
            ++n2;
        }
        if (!this.isTableViewerDisposed()) {
            this.getTableViewer().remove(nodes);
        }
        new Job(BuildSectionMessages.BuildSectionContentProvider_CALCULATE_FAILING_BUILDS_JOB_NAME){

            protected IStatus run(IProgressMonitor monitor) {
                int numberOfFailingBuilds = BuildSectionContentProvider.this.getNumberOfBuildsWithStatus(BuildStatus.ERROR);
                BuildSectionContentProvider.this.updateHeader(numberOfFailingBuilds);
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    protected void addNodes(Object[] nodes) {
        Object[] objectArray = nodes;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            this.getBuildDefinitionQueryNodes().add((BuildDefinitionQueryNode)object);
            ++n2;
        }
        if (!this.isTableViewerDisposed()) {
            this.getTableViewer().add(nodes);
        }
    }

    public Map<ITeamRepository, AbstractBuildDefinitionChangeListener> getRepositoryToItemChangeListeners() {
        return this.fRepositoryToItemChangeListeners;
    }

    protected IFetchStrategy getFetchStrategy() {
        return this.fFetchStrategy;
    }
}

