/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.scm;

import com.ibm.team.build.common.model.BuildStatus;
import com.ibm.team.build.common.model.IBuildResultContribution;
import com.ibm.team.build.internal.ui.scm.Messages;
import com.ibm.team.build.ui.editors.result.AbstractBuildResultContributionProvider;
import com.ibm.team.build.ui.editors.result.AbstractBuildResultPage;
import com.ibm.team.build.ui.editors.result.IBuildResultContext;
import com.ibm.team.filesystem.ui.views.TeamPlaceEditorInput;
import com.ibm.team.filesystem.ui.views.TeamPlacePart2;
import com.ibm.team.filesystem.ui.wrapper.AbstractPlaceWrapper;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.scm.common.IWorkspace;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.editor.FormEditor;

public class WorkspaceContributionProvider
extends AbstractBuildResultContributionProvider {
    private IWorkspace fWorkspace;

    public WorkspaceContributionProvider(FormEditor buildEditor, String id, IBuildResultContext context) {
        super(buildEditor, id, context);
    }

    @Override
    public void initializeContributionProvider(IProgressMonitor monitor) throws Exception {
        this.fWorkspace = null;
        ITeamRepository repository = this.getBuildResultContext().getTeamRepository();
        IBuildResultContribution[] contributions = this.getContributions();
        if (contributions.length > 0) {
            try {
                this.fWorkspace = (IWorkspace)repository.itemManager().fetchCompleteItem(contributions[0].getExtendedContribution(), 0, monitor);
            }
            catch (ItemNotFoundException itemNotFoundException) {
                // empty catch block
            }
        }
    }

    @Override
    public BuildStatus getStatus() {
        return BuildStatus.INFO;
    }

    @Override
    public String getSummaryText() {
        if (this.fWorkspace == null) {
            return Messages.WorkspaceContributionProvider_NO_WORKSPACE;
        }
        return this.fWorkspace.getName();
    }

    @Override
    public boolean isSummaryLink() {
        return this.fWorkspace != null;
    }

    @Override
    public void summaryLinkActivated() {
        IWorkbenchPage page;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null) {
            TeamPlacePart2.open((IWorkbenchPage)page, (TeamPlaceEditorInput)TeamPlaceEditorInput.newForEdit((AbstractPlaceWrapper)AbstractPlaceWrapper.newWrapper((IWorkspace)this.fWorkspace)));
        }
    }

    @Override
    public DragSourceAdapter getSummaryLinkDragAdapter() {
        if (this.fWorkspace != null) {
            return new DragSourceAdapter(){

                public void dragStart(DragSourceEvent event) {
                    AbstractPlaceWrapper wrapper = AbstractPlaceWrapper.newWrapper((IWorkspace)WorkspaceContributionProvider.this.fWorkspace);
                    StructuredSelection selection = new StructuredSelection((Object)wrapper);
                    LocalSelectionTransfer.getTransfer().setSelection((ISelection)selection);
                }

                public void dragSetData(DragSourceEvent event) {
                    if (LocalSelectionTransfer.getTransfer().isSupportedType(event.dataType)) {
                        event.data = LocalSelectionTransfer.getTransfer().getSelection();
                    }
                }

                public void dragFinished(DragSourceEvent event) {
                    LocalSelectionTransfer.getTransfer().setSelection(null);
                }
            };
        }
        return null;
    }

    @Override
    public AbstractBuildResultPage getBuildResultPage() {
        return null;
    }

    @Override
    public String[] getExtendedContributionIds() {
        return new String[]{"buildWorkspace"};
    }

    @Override
    public String getSummaryTitle() {
        return Messages.WorkspaceContributionProvider_SUMMARY_TITLE;
    }
}

