/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.scm;

import com.ibm.team.build.client.ClientFactory;
import com.ibm.team.build.client.ITeamBuildClient;
import com.ibm.team.build.common.model.IBuildResultContribution;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.build.internal.common.model.dto.IBuildResultRecord;
import com.ibm.team.build.internal.ui.actions.AbstractRepositoryActionDelegate;
import com.ibm.team.build.internal.ui.scm.Messages;
import com.ibm.team.filesystem.ui.changes.ChangesViewUtil;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.common.IBaselineSet;
import com.ibm.team.scm.common.IBaselineSetHandle;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class CompareBuildsActionDelegate
extends AbstractRepositoryActionDelegate {
    protected IStructuredSelection fSelection;

    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        this.fSelection = (IStructuredSelection)selection;
    }

    @Override
    protected void performAction(IProgressMonitor progressMonitor) throws TeamRepositoryException {
        Object[] elements = this.fSelection.toArray();
        if (elements.length > 1 && elements[0] instanceof IBuildResultRecord && elements[1] instanceof IBuildResultRecord) {
            IBuildResultRecord record1 = (IBuildResultRecord)elements[0];
            IBuildResultRecord record2 = (IBuildResultRecord)elements[1];
            final IBaselineSet[] snapshots = this.getSnapshots((IBuildResultHandle)record1.getBuildResult(), (IBuildResultHandle)record2.getBuildResult(), progressMonitor);
            if (snapshots[0] != null && snapshots[1] != null) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        CompareBuildsActionDelegate.this.openChangeExplorer(snapshots[0], snapshots[1]);
                    }
                });
            } else {
                String buildId = snapshots[0] == null ? record1.getBuildResult().getLabel() : record2.getBuildResult().getLabel();
                String message = NLS.bind((String)Messages.CompareBuildsAction_NO_SNAPSHOT, (Object)buildId);
                this.showWarningDialog(Messages.AbstractRepositoryActionDelegate_NO_SNAPSHOT_TITLE, message);
            }
        }
    }

    protected void openChangeExplorer(IBaselineSet snapshot1, IBaselineSet snapshot2) {
        IWorkbenchPage page;
        IBaselineSet snapshot2Handle;
        IBaselineSet snapshot1Handle;
        if (snapshot1.modified().getTime() > snapshot2.modified().getTime()) {
            snapshot1Handle = snapshot1;
            snapshot2Handle = snapshot2;
        } else {
            snapshot2Handle = snapshot1;
            snapshot1Handle = snapshot2;
        }
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null) {
            ChangesViewUtil.compareSnapshotWithSnapshot((IWorkbenchPage)page, (ITeamRepository)((ITeamRepository)snapshot1.getOrigin()), (IBaselineSetHandle)snapshot1Handle, (IBaselineSetHandle)snapshot2Handle);
        }
    }

    @Override
    protected String getConfirmationMessage() {
        return null;
    }

    @Override
    protected String getJobLabel() {
        return Messages.CompareBuildsAction_JOB_LABEL;
    }

    protected IBaselineSet[] getSnapshots(IBuildResultHandle buildResultHandle1, IBuildResultHandle buildResultHandle2, IProgressMonitor monitor) throws TeamRepositoryException {
        IBaselineSet[] snapshots = new IBaselineSet[2];
        ITeamRepository teamRepository = (ITeamRepository)buildResultHandle1.getOrigin();
        ITeamBuildClient buildClient = ClientFactory.getTeamBuildClient((ITeamRepository)teamRepository);
        IBuildResultContribution[] contributions = buildClient.getBuildResultContributions(buildResultHandle1, "buildSnapshot", null);
        if (contributions.length > 0) {
            snapshots[0] = (IBaselineSet)teamRepository.itemManager().fetchCompleteItem(contributions[0].getExtendedContribution(), 0, null);
        }
        if ((contributions = buildClient.getBuildResultContributions(buildResultHandle2, "buildSnapshot", null)).length > 0) {
            snapshots[1] = (IBaselineSet)teamRepository.itemManager().fetchCompleteItem(contributions[0].getExtendedContribution(), 0, null);
        }
        return snapshots;
    }
}

