/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.scm;

import com.ibm.team.build.client.ITeamBuildClient;
import com.ibm.team.build.common.model.BuildStatus;
import com.ibm.team.build.common.model.IBuildResultContribution;
import com.ibm.team.build.internal.common.model.query.BaseBuildResultContributionsQueryModel;
import com.ibm.team.build.internal.ui.scm.Messages;
import com.ibm.team.build.ui.editors.result.AbstractBuildResultContributionProvider;
import com.ibm.team.build.ui.editors.result.AbstractBuildResultPage;
import com.ibm.team.build.ui.editors.result.IBuildResultContext;
import com.ibm.team.filesystem.ui.changes.ChangesViewUtil;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.query.IDataQuery;
import com.ibm.team.repository.common.query.IDataQueryPage;
import com.ibm.team.repository.common.query.IDataRow;
import com.ibm.team.repository.common.query.ast.IField;
import com.ibm.team.repository.common.query.ast.INumeric;
import com.ibm.team.repository.common.query.ast.IPredicate;
import com.ibm.team.repository.common.query.ast.IQueryModel;
import com.ibm.team.repository.common.query.ast.ISelectionElement;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IBaselineSet;
import com.ibm.team.scm.common.IBaselineSetHandle;
import com.ibm.team.scm.common.dto.IChangeHistorySyncReport;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.editor.FormEditor;

public class ChangeContributionProvider
extends AbstractBuildResultContributionProvider {
    protected IBaselineSet fPreviousBuildSnapshot;
    private IBaselineSet fCurrentBuildSnapshot;
    private IBaselineSetHandle fCurrentBuildSnapshotHandle;
    private IChangeHistorySyncReport fSnapshotComparison;

    public ChangeContributionProvider(FormEditor buildEditor, String id, IBuildResultContext context) {
        super(buildEditor, id, context);
    }

    @Override
    public void initializeContributionProvider(IProgressMonitor monitor) throws Exception {
        this.fPreviousBuildSnapshot = null;
        this.fCurrentBuildSnapshot = null;
        this.fCurrentBuildSnapshotHandle = null;
        this.fetchSnapshots(monitor);
    }

    @Override
    public BuildStatus getStatus() {
        return BuildStatus.INFO;
    }

    @Override
    public String getSummaryText() {
        if (this.fCurrentBuildSnapshotHandle == null) {
            return Messages.ChangeContributionProvider_NO_SNAPSHOT;
        }
        if (this.fPreviousBuildSnapshot == null) {
            return Messages.ChangeContributionProvider_NO_SNAPSHOT_PREVIOUS;
        }
        return Messages.ChangeContributionProvider_OPEN_CHANGE_EXPLORER;
    }

    @Override
    public boolean isSummaryLink() {
        return this.fPreviousBuildSnapshot != null && this.fCurrentBuildSnapshot != null;
    }

    @Override
    public void summaryLinkActivated() {
        IWorkbenchPage page;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null) {
            ChangesViewUtil.compareSnapshotWithSnapshot((IWorkbenchPage)page, (ITeamRepository)((ITeamRepository)this.fCurrentBuildSnapshot.getOrigin()), (IBaselineSetHandle)this.fCurrentBuildSnapshot, (IBaselineSetHandle)this.fPreviousBuildSnapshot);
        }
    }

    @Override
    public DragSourceAdapter getSummaryLinkDragAdapter() {
        if (this.fSnapshotComparison != null) {
            return new DragSourceAdapter(){

                public void dragStart(DragSourceEvent event) {
                    StructuredSelection selection = new StructuredSelection((Object)ChangeContributionProvider.this.fSnapshotComparison);
                    LocalSelectionTransfer.getTransfer().setSelection((ISelection)selection);
                }

                public void dragSetData(DragSourceEvent event) {
                    if (LocalSelectionTransfer.getTransfer().isSupportedType(event.dataType)) {
                        event.data = LocalSelectionTransfer.getTransfer().getSelection();
                    }
                }

                public void dragFinished(DragSourceEvent event) {
                    LocalSelectionTransfer.getTransfer().setSelection(null);
                }
            };
        }
        return null;
    }

    private IBaselineSetHandle getSnapshot(IBuildResultContribution[] contributions, IProgressMonitor monitor) {
        if (contributions.length > 0) {
            return (IBaselineSetHandle)contributions[0].getExtendedContribution();
        }
        return null;
    }

    private void fetchSnapshots(IProgressMonitor monitor) throws TeamRepositoryException {
        IBaselineSetHandle previousBuildSnapshotHandle;
        IBuildResultContext context = this.getBuildResultContext();
        ITeamRepository repository = (ITeamRepository)context.getBuildResult().getOrigin();
        this.fCurrentBuildSnapshotHandle = this.getSnapshot(this.getContributions(), monitor);
        if (this.fCurrentBuildSnapshotHandle != null && (previousBuildSnapshotHandle = this.getPreviousSnapshot(context, monitor)) != null) {
            ArrayList<IBaselineSetHandle> snapshotHandles = new ArrayList<IBaselineSetHandle>();
            snapshotHandles.add(this.fCurrentBuildSnapshotHandle);
            snapshotHandles.add(previousBuildSnapshotHandle);
            List items = repository.itemManager().fetchCompleteItems(snapshotHandles, 0, monitor);
            this.fCurrentBuildSnapshot = (IBaselineSet)items.get(0);
            this.fPreviousBuildSnapshot = (IBaselineSet)items.get(1);
            if (this.fCurrentBuildSnapshot != null && this.fPreviousBuildSnapshot != null) {
                IWorkspaceManager wm = SCMPlatform.getWorkspaceManager((ITeamRepository)repository);
                this.fSnapshotComparison = wm.compareBaselineSets((IBaselineSetHandle)this.fCurrentBuildSnapshot, (IBaselineSetHandle)this.fPreviousBuildSnapshot, null, monitor);
            }
        }
    }

    private IBaselineSetHandle getPreviousSnapshot(IBuildResultContext context, IProgressMonitor monitor) throws TeamRepositoryException {
        ITeamRepository repository = (ITeamRepository)context.getBuildResult().getOrigin();
        ITeamBuildClient client = (ITeamBuildClient)repository.getClientLibrary(ITeamBuildClient.class);
        BaseBuildResultContributionsQueryModel.BuildResultContributionsQueryModel model = BaseBuildResultContributionsQueryModel.BuildResultContributionsQueryModel.ROOT;
        IDataQuery query = (IDataQuery)IDataQuery.FACTORY.newInstance((IQueryModel)model);
        query.select((ISelectionElement)model.contributions().extendedContribution().itemId());
        IPredicate isSameDefinition = model.buildResult().buildDefinition()._eq(query.newItemHandleArg());
        IPredicate isNotMe = model.buildResult()._eq(query.newItemHandleArg())._not();
        IPredicate startTimeLessEqual = model.buildResult().buildStartTime()._ltOrEq((INumeric)query.newLongArg());
        IPredicate hasSnapshot = model.contributions().extendedContributionTypeId()._eq("buildSnapshot");
        query.orderByDsc((IField)model.buildResult().buildStartTime());
        IPredicate filter = isSameDefinition._and(startTimeLessEqual)._and(hasSnapshot)._and(isNotMe);
        query.filter(filter);
        query.setResultLimit(1);
        IDataQueryPage queryPage = client.uncommittedQueryData(query, new Object[]{context.getBuildResult().getBuildDefinition(), context.getBuildResult(), context.getBuildResult().getBuildStartTime()}, 1, monitor);
        if (queryPage.getResultSize() > 0) {
            IDataRow row = queryPage.getRow(0);
            UUID snapshotUUID = row.getUUID(0);
            return (IBaselineSetHandle)IBaselineSet.ITEM_TYPE.createItemHandle(snapshotUUID, null);
        }
        return null;
    }

    @Override
    public AbstractBuildResultPage getBuildResultPage() {
        return null;
    }

    @Override
    public String[] getExtendedContributionIds() {
        return new String[]{"buildSnapshot"};
    }

    @Override
    public String getSummaryTitle() {
        return Messages.ChangeContributionProvider_SUMMARY_TITLE;
    }
}

