/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.scm;

import com.ibm.team.build.client.ITeamBuildClient;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.common.model.IBuildResultContribution;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.build.internal.common.model.query.BaseBuildResultContributionsQueryModel;
import com.ibm.team.filesystem.rcp.ui.workitems.lcs.input.ILcsChangeSetProvider;
import com.ibm.team.filesystem.ui.item.ISnapshotProvider;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.PermissionDeniedException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.query.IDataQuery;
import com.ibm.team.repository.common.query.IDataQueryPage;
import com.ibm.team.repository.common.query.IDataRow;
import com.ibm.team.repository.common.query.ast.IField;
import com.ibm.team.repository.common.query.ast.INumeric;
import com.ibm.team.repository.common.query.ast.IPredicate;
import com.ibm.team.repository.common.query.ast.IQueryModel;
import com.ibm.team.repository.common.query.ast.ISelectionElement;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IBaselineSet;
import com.ibm.team.scm.common.IBaselineSetHandle;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.dto.IChangeHistorySyncReport;
import com.ibm.team.workitem.common.model.IDeliverable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class BuildScmItemProviderAdapterFactory
implements IAdapterFactory {
    private static final Class[] fSupportedTypes = new Class[]{ILcsChangeSetProvider.class, ISnapshotProvider.class};

    public Class[] getAdapterList() {
        return fSupportedTypes;
    }

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        IBuildResultHandle buildResultHandle;
        Object origin;
        if (adaptableObject instanceof IBuildResultHandle && adapterType == ILcsChangeSetProvider.class && (origin = (buildResultHandle = (IBuildResultHandle)adaptableObject).getOrigin()) instanceof ITeamRepository) {
            ITeamRepository buildResultRepo = (ITeamRepository)origin;
            return new BuildResultChangesProvider(buildResultRepo, buildResultHandle);
        }
        if ((adaptableObject instanceof IBuildResultHandle || adaptableObject instanceof IDeliverable) && adapterType == ISnapshotProvider.class) {
            IDeliverable release;
            IItemHandle artifact;
            buildResultHandle = null;
            if (adaptableObject instanceof IBuildResultHandle) {
                buildResultHandle = (IBuildResultHandle)adaptableObject;
            } else if (adaptableObject instanceof IDeliverable && (artifact = (release = (IDeliverable)adaptableObject).getArtifact()) instanceof IBuildResultHandle) {
                buildResultHandle = (IBuildResultHandle)artifact;
            }
            if (buildResultHandle != null && (origin = buildResultHandle.getOrigin()) instanceof ITeamRepository) {
                ITeamRepository buildResultRepo = (ITeamRepository)origin;
                return new BuildResultSnapshotProvider(buildResultRepo, buildResultHandle);
            }
        }
        return null;
    }

    private abstract class AbstractBuildResultScmItemProvider {
        private ITeamRepository fRepo;
        private IBuildResultHandle fBuildResultHandle;

        public AbstractBuildResultScmItemProvider(ITeamRepository repo, IBuildResultHandle buildResultHandle) {
            if (repo == null) {
                throw new IllegalArgumentException("'repo' must not be null.");
            }
            if (buildResultHandle == null) {
                throw new IllegalArgumentException("'buildResultHandle' must not be null.");
            }
            this.fRepo = repo;
            this.fBuildResultHandle = buildResultHandle;
        }

        public ITeamRepository getRepository() {
            return this.fRepo;
        }

        public IBuildResultHandle getBuildResultHandle() {
            return this.fBuildResultHandle;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!super.equals(o)) {
                return false;
            }
            if (this.getClass() != o.getClass()) {
                return false;
            }
            BuildResultSnapshotProvider other = (BuildResultSnapshotProvider)o;
            if (this.fRepo == null ? other.getRepository() != null : !this.fRepo.equals(other.getRepository())) {
                return false;
            }
            return !(this.fBuildResultHandle == null ? other.getBuildResultHandle() != null : !this.fBuildResultHandle.sameItemId((IItemHandle)other.getBuildResultHandle()));
        }

        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.fRepo == null ? 0 : this.fRepo.hashCode());
            result = 31 * result + (this.fBuildResultHandle == null ? 0 : this.fBuildResultHandle.getItemId().hashCode());
            return result;
        }
    }

    private class BuildResultChangesProvider
    extends AbstractBuildResultScmItemProvider
    implements ILcsChangeSetProvider {
        public BuildResultChangesProvider(ITeamRepository repo, IBuildResultHandle buildResultHandle) {
            super(repo, buildResultHandle);
        }

        public Map<ITeamRepository, Map<UUID, IChangeSetHandle>> getChangeSets(IProgressMonitor monitor) throws IllegalArgumentException, TeamRepositoryException {
            IBuildResult buildResult;
            IBaselineSetHandle previousBuildSnapshotHandle;
            IItem fetchedObject;
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            HashMap<ITeamRepository, Map<UUID, IChangeSetHandle>> changeSets = new HashMap<ITeamRepository, Map<UUID, IChangeSetHandle>>();
            ITeamRepository repo = this.getRepository();
            IBaselineSetHandle buildSnapshotHandle = null;
            ITeamBuildClient client = (ITeamBuildClient)repo.getClientLibrary(ITeamBuildClient.class);
            IBuildResultContribution[] contribution = client.getBuildResultContributions(this.getBuildResultHandle(), new String[]{"buildSnapshot"}, (IProgressMonitor)progress.newChild(25));
            if (contribution.length > 0) {
                buildSnapshotHandle = (IBaselineSetHandle)contribution[0].getExtendedContribution();
            }
            if (buildSnapshotHandle != null && (fetchedObject = repo.itemManager().fetchCompleteItem((IItemHandle)this.getBuildResultHandle(), 0, (IProgressMonitor)progress.newChild(25))) instanceof IBuildResult && (previousBuildSnapshotHandle = this.getPreviousSnapshot(buildResult = (IBuildResult)fetchedObject, (IProgressMonitor)progress.newChild(25))) != null) {
                IWorkspaceManager wm = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
                try {
                    IChangeHistorySyncReport snapshotComparison = wm.compareBaselineSets(buildSnapshotHandle, previousBuildSnapshotHandle, null, (IProgressMonitor)progress.newChild(25));
                    this.mergeChangeSets(changeSets, snapshotComparison.outgoingChangeSets());
                    this.mergeChangeSets(changeSets, snapshotComparison.incomingChangeSets());
                }
                catch (ItemNotFoundException itemNotFoundException) {
                }
                catch (PermissionDeniedException permissionDeniedException) {
                    // empty catch block
                }
            }
            return changeSets;
        }

        private void mergeChangeSets(Map<ITeamRepository, Map<UUID, IChangeSetHandle>> allChangeSets, List toMerge) {
            for (Object object : toMerge) {
                IChangeSetHandle changeSet;
                if (!(object instanceof IChangeSetHandle) || !((changeSet = (IChangeSetHandle)object).getOrigin() instanceof ITeamRepository)) continue;
                ITeamRepository repo = (ITeamRepository)changeSet.getOrigin();
                Map<UUID, IChangeSetHandle> currentChangeSets = null;
                if (allChangeSets.containsKey(repo)) {
                    currentChangeSets = allChangeSets.get(repo);
                }
                if (currentChangeSets == null) {
                    currentChangeSets = new HashMap<UUID, IChangeSetHandle>(1);
                }
                currentChangeSets.put(changeSet.getItemId(), changeSet);
                allChangeSets.put(repo, currentChangeSets);
            }
        }

        private IBaselineSetHandle getPreviousSnapshot(IBuildResult buildResult, IProgressMonitor monitor) throws TeamRepositoryException {
            ITeamRepository repository = (ITeamRepository)buildResult.getOrigin();
            ITeamBuildClient client = (ITeamBuildClient)repository.getClientLibrary(ITeamBuildClient.class);
            BaseBuildResultContributionsQueryModel.BuildResultContributionsQueryModel model = BaseBuildResultContributionsQueryModel.BuildResultContributionsQueryModel.ROOT;
            IDataQuery query = (IDataQuery)IDataQuery.FACTORY.newInstance((IQueryModel)model);
            query.select((ISelectionElement)model.contributions().extendedContribution().itemId());
            IPredicate isSameDefinition = model.buildResult().buildDefinition()._eq(query.newItemHandleArg());
            IPredicate isNotMe = model.buildResult()._eq(query.newItemHandleArg())._not();
            IPredicate startTimeLessEqual = model.buildResult().buildStartTime()._ltOrEq((INumeric)query.newLongArg());
            IPredicate hasSnapshot = model.contributions().extendedContributionTypeId()._eq("buildSnapshot");
            query.orderByDsc((IField)model.buildResult().buildStartTime());
            IPredicate filter = isSameDefinition._and(startTimeLessEqual)._and(hasSnapshot)._and(isNotMe);
            query.filter(filter);
            query.setResultLimit(1);
            IDataQueryPage queryPage = client.uncommittedQueryData(query, new Object[]{buildResult.getBuildDefinition(), buildResult, buildResult.getBuildStartTime()}, 1, monitor);
            if (queryPage.getResultSize() > 0) {
                IDataRow row = queryPage.getRow(0);
                UUID snapshotUUID = row.getUUID(0);
                return (IBaselineSetHandle)IBaselineSet.ITEM_TYPE.createItemHandle(snapshotUUID, null);
            }
            return null;
        }
    }

    private class BuildResultSnapshotProvider
    extends AbstractBuildResultScmItemProvider
    implements ISnapshotProvider {
        public BuildResultSnapshotProvider(ITeamRepository repo, IBuildResultHandle buildResultHandle) {
            super(repo, buildResultHandle);
        }

        public Map<ITeamRepository, Map<UUID, IBaselineSetHandle>> getSnapshots(IProgressMonitor monitor) throws IllegalArgumentException, TeamRepositoryException {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            IBaselineSetHandle snapshotHandle = null;
            ITeamBuildClient client = (ITeamBuildClient)this.getRepository().getClientLibrary(ITeamBuildClient.class);
            IBuildResultContribution[] contribution = client.getBuildResultContributions(this.getBuildResultHandle(), new String[]{"buildSnapshot"}, (IProgressMonitor)progress.newChild(100));
            if (contribution.length > 0) {
                snapshotHandle = (IBaselineSetHandle)contribution[0].getExtendedContribution();
            }
            if (snapshotHandle != null && snapshotHandle.getOrigin() instanceof ITeamRepository) {
                Map<UUID, IBaselineSetHandle> snapshotEntry = Collections.singletonMap(snapshotHandle.getItemId(), snapshotHandle);
                return Collections.singletonMap((ITeamRepository)snapshotHandle.getOrigin(), snapshotEntry);
            }
            return Collections.EMPTY_MAP;
        }
    }
}

