/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.scm;

import com.ibm.team.build.client.ClientFactory;
import com.ibm.team.build.client.ITeamBuildClient;
import com.ibm.team.build.common.model.IBuildResultContribution;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.build.internal.scm.SourceControlUtility;
import com.ibm.team.build.internal.ui.actions.AbstractRepositoryActionDelegate;
import com.ibm.team.build.internal.ui.scm.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.common.IBaselineSetHandle;
import com.ibm.team.workitem.common.model.IDeliverable;
import com.ibm.team.workitem.common.model.IDeliverableHandle;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;

public class AssociateReleaseToBuildSnapshotActionDelegate
extends AbstractRepositoryActionDelegate {
    private IStructuredSelection fSelection;

    public void selectionChanged(IAction action, ISelection selection) {
        this.fSelection = (IStructuredSelection)selection;
        boolean containsBuildResult = false;
        for (Object o : this.fSelection.toList()) {
            IDeliverable release;
            IItemHandle artifact;
            if (!(o instanceof IDeliverable) || !((artifact = (release = (IDeliverable)o).getArtifact()) instanceof IBuildResultHandle)) continue;
            containsBuildResult = true;
            break;
        }
        action.setEnabled(containsBuildResult);
    }

    @Override
    protected String getConfirmationMessage() {
        if (this.fSelection.size() == 1) {
            return Messages.AssociateReleaseToBuildSnapshotActionDelegate_ConfirmationMessage;
        }
        return Messages.AssociateReleaseToBuildSnapshotActionDelegate_ConfirmationMessagePlural;
    }

    @Override
    protected int getConfirmationDialogImageType() {
        return 5;
    }

    @Override
    protected String getJobLabel() {
        return Messages.AssociateReleaseToBuildSnapshotActionDelegate_JobLabel;
    }

    @Override
    protected void performAction(IProgressMonitor progressMonitor) throws TeamRepositoryException {
        if (this.fSelection == null || this.fSelection.isEmpty()) {
            return;
        }
        HashMap<IDeliverable, IBuildResultHandle> releasesWithBuilds = new HashMap<IDeliverable, IBuildResultHandle>();
        for (Object o : this.fSelection.toList()) {
            IDeliverable release;
            IItemHandle artifact;
            if (!(o instanceof IDeliverable) || !((artifact = (release = (IDeliverable)o).getArtifact()) instanceof IBuildResultHandle)) continue;
            releasesWithBuilds.put(release, (IBuildResultHandle)artifact);
        }
        if (releasesWithBuilds.isEmpty()) {
            return;
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)progressMonitor, (int)(releasesWithBuilds.size() * 2));
        for (Map.Entry entry : releasesWithBuilds.entrySet()) {
            try {
                ITeamRepository repo = (ITeamRepository)((IBuildResultHandle)entry.getValue()).getOrigin();
                ITeamBuildClient buildClient = ClientFactory.getTeamBuildClient((ITeamRepository)repo);
                IBuildResultContribution[] contributions = buildClient.getBuildResultContributions((IBuildResultHandle)entry.getValue(), "buildSnapshot", (IProgressMonitor)subMonitor.newChild(1));
                if (contributions.length <= 0) continue;
                IBaselineSetHandle snapshotHandle = (IBaselineSetHandle)contributions[0].getExtendedContribution();
                SourceControlUtility.associateReleaseToSnapshot((ITeamRepository)repo, (IBaselineSetHandle)snapshotHandle, (IDeliverableHandle)((IDeliverableHandle)entry.getKey()), null, (IProgressMonitor)subMonitor.newChild(1));
                SourceControlUtility.associateBuildResultToSnapshot((ITeamRepository)repo, (IBaselineSetHandle)snapshotHandle, (IBuildResultHandle)((IBuildResultHandle)entry.getValue()), null, (IProgressMonitor)subMonitor.newChild(1));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

