/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.query;

import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.ui.query.BuildQuery;
import com.ibm.team.build.internal.ui.query.BuildQueryRow;
import com.ibm.team.build.internal.ui.views.query.BuildQueryRowComparator;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.UUID;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;

public class BuildQueryResult {
    private final ITeamRepository fTeamRepository;
    private final BuildQuery fBuildQuery;
    private long fQueryDurationMillis;
    private int fQuerySize;
    private final HashMap<UUID, BuildQueryRow> fBuildResultUUIDToBuildQueryRow;
    private final ArrayList<BuildQueryRow> fBuildQueryRows = new ArrayList();
    private Timestamp fReferenceTime;

    public BuildQueryResult(ITeamRepository teamRepository, BuildQuery buildQuery) {
        ValidationHelper.validateNotNull((String)"teamRepository", (Object)teamRepository);
        ValidationHelper.validateNotNull((String)"buildQuery", (Object)buildQuery);
        this.fTeamRepository = teamRepository;
        this.fBuildQuery = buildQuery;
        this.fBuildResultUUIDToBuildQueryRow = new HashMap();
        this.resetReferenceTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRow(BuildQueryRow row) {
        ValidationHelper.validateNotNull((String)"row", (Object)row);
        BuildQueryResult buildQueryResult = this;
        synchronized (buildQueryResult) {
            this.fBuildResultUUIDToBuildQueryRow.put(row.getBuildResult().getItemId(), row);
            this.fBuildQueryRows.add(row);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean removeRow(UUID buildResultUUID) {
        ValidationHelper.validateNotNull((String)"buildResultUUID", (Object)buildResultUUID);
        BuildQueryResult buildQueryResult = this;
        synchronized (buildQueryResult) {
            if (this.fBuildResultUUIDToBuildQueryRow.remove(buildResultUUID) != null) {
                Iterator<BuildQueryRow> iter = this.fBuildQueryRows.iterator();
                while (iter.hasNext()) {
                    BuildQueryRow buildQueryRow = iter.next();
                    if (!buildResultUUID.equals((Object)buildQueryRow.getBuildResult().getItemId())) continue;
                    iter.remove();
                    return true;
                }
            }
            return false;
        }
    }

    public boolean hasRowFor(UUID buildResultUUID) {
        return this.fBuildResultUUIDToBuildQueryRow.containsKey(buildResultUUID);
    }

    public ITeamRepository getTeamRepository() {
        return this.fTeamRepository;
    }

    public BuildQuery getBuildQuery() {
        return this.fBuildQuery;
    }

    public long getQueryDurationMillis() {
        return this.fQueryDurationMillis;
    }

    public void initQueryDurationMillis(long queryDurationMillis) {
        this.fQueryDurationMillis = queryDurationMillis;
    }

    public int getQuerySize() {
        return this.fQuerySize;
    }

    public void setQuerySize(int querySize) {
        this.fQuerySize = querySize;
    }

    public Timestamp getReferenceTime() {
        return this.fReferenceTime;
    }

    public void resetReferenceTime() {
        this.fReferenceTime = new Timestamp(System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BuildQueryRow[] getRows() {
        BuildQueryResult buildQueryResult = this;
        synchronized (buildQueryResult) {
            return this.fBuildQueryRows.toArray(new BuildQueryRow[this.fBuildQueryRows.size()]);
        }
    }

    public BuildQueryRow getRow(int index) {
        return this.fBuildQueryRows.get(index);
    }

    public BuildQueryRow getRow(UUID buildResultUUID) {
        return this.fBuildResultUUIDToBuildQueryRow.get(buildResultUUID);
    }

    public int getRowCount() {
        return this.fBuildResultUUIDToBuildQueryRow.size();
    }

    public synchronized void sort(final BuildQueryRowComparator[] rowComparators) throws IllegalArgumentException {
        ValidationHelper.validateNotNull((String)"rowComparators", (Object[])rowComparators);
        BuildQueryRow[] rows = this.getRows();
        Arrays.sort(rows, new Comparator<BuildQueryRow>(){

            @Override
            public int compare(BuildQueryRow o1, BuildQueryRow o2) {
                BuildQueryRowComparator[] buildQueryRowComparatorArray = rowComparators;
                int n = rowComparators.length;
                int n2 = 0;
                while (n2 < n) {
                    BuildQueryRowComparator comparator = buildQueryRowComparatorArray[n2];
                    int comparison = comparator.compare(o1, o2);
                    if (comparison != 0) {
                        return comparison;
                    }
                    ++n2;
                }
                return 0;
            }
        });
        this.clear();
        BuildQueryRow[] buildQueryRowArray = rows;
        int n = rows.length;
        int n2 = 0;
        while (n2 < n) {
            BuildQueryRow buildQueryRow = buildQueryRowArray[n2];
            this.addRow(buildQueryRow);
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clear() {
        BuildQueryResult buildQueryResult = this;
        synchronized (buildQueryResult) {
            this.fBuildResultUUIDToBuildQueryRow.clear();
            this.fBuildQueryRows.clear();
        }
    }
}

