/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.query;

import com.ibm.team.build.internal.common.model.dto.IBuildResultSearchCriteria;
import com.ibm.team.build.internal.ui.query.BuildQuery;
import com.ibm.team.build.internal.ui.query.BuildQueryColumnKind;
import com.ibm.team.build.internal.ui.query.BuildQueryRow;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.rcp.ui.teamnavigator.ConnectedProjectAreaRegistry;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class BuildQueryForBuildQueue
extends BuildQuery {
    private IProjectAreaHandle fProjectAreaHandle;

    public BuildQueryForBuildQueue(String name, String description, BuildQueryRow.Factory buildQueryRowFactory, IProjectAreaHandle projectAreaHandle, ITeamRepository teamRepository) {
        super(name, description, buildQueryRowFactory, teamRepository);
        this.fProjectAreaHandle = projectAreaHandle;
    }

    public BuildQueryColumnKind[] getDefaultSortColumns() {
        return new BuildQueryColumnKind[]{BuildQueryColumnKind.StartTime, BuildQueryColumnKind.StartTime};
    }

    protected List<IProjectAreaHandle> getConnectedProjectAreas() {
        return ConnectedProjectAreaRegistry.getDefault().getConnectedProjectAreas(this.getTeamRepository());
    }

    @Override
    protected IBuildResultSearchCriteria getBuildQueryCriteria(IProgressMonitor monitor) throws TeamRepositoryException {
        List<IProjectAreaHandle> projectAreas;
        List<IProjectAreaHandle> list = projectAreas = this.fProjectAreaHandle != null ? Collections.singletonList(this.fProjectAreaHandle) : this.getConnectedProjectAreas();
        if (projectAreas.isEmpty()) {
            return null;
        }
        return IBuildResultSearchCriteria.BUILDER.inProjectAreas(projectAreas).inQueue();
    }
}

