/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.query;

import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.common.model.dto.IBuildResultSearchCriteria;
import com.ibm.team.build.internal.ui.query.BuildQuery;
import com.ibm.team.build.internal.ui.query.BuildQueryColumnKind;
import com.ibm.team.build.internal.ui.query.BuildQueryRow;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.Arrays;
import org.eclipse.core.runtime.IProgressMonitor;

public class BuildQueryByTag
extends BuildQuery {
    private String fTag;
    private IBuildDefinitionHandle[] fDefinitions;
    private IProjectAreaHandle fProjectAreaHandle;

    public BuildQueryByTag(String name, String description, BuildQueryRow.Factory buildQueryRowFactory, IBuildDefinitionHandle[] buildDefinitionHandles, String tag, ITeamRepository teamRepository) {
        super(name, description, buildQueryRowFactory, teamRepository);
        this.validateTags("tag", tag);
        ValidationHelper.validateNotEmpty((String)"buildDefinitionHandles", (Object[])buildDefinitionHandles);
        ValidationHelper.validateNotNullElements((String)"buildDefinitionHandles", (Object[])buildDefinitionHandles);
        this.fTag = tag;
        this.fDefinitions = buildDefinitionHandles;
    }

    public BuildQueryByTag(String name, String description, BuildQueryRow.Factory buildQueryRowFactory, IProjectAreaHandle projectAreaHandle, String tag, ITeamRepository teamRepository) {
        super(name, description, buildQueryRowFactory, teamRepository);
        this.validateTags("tag", tag);
        ValidationHelper.validateNotNull((String)"projectAreaHandle", (Object)projectAreaHandle);
        this.fTag = tag;
        this.fProjectAreaHandle = projectAreaHandle;
    }

    private void validateTags(String parameterName, String parameterValue) throws IllegalArgumentException {
        ValidationHelper.validateNotNull((String)parameterName, (Object)parameterValue);
        ValidationHelper.validateNotEmpty((String)parameterName, (String)parameterValue);
    }

    public BuildQueryColumnKind[] getDefaultSortColumns() {
        return new BuildQueryColumnKind[]{BuildQueryColumnKind.StartTime, BuildQueryColumnKind.StartTime};
    }

    @Override
    protected IBuildResultSearchCriteria getBuildQueryCriteria(IProgressMonitor monitor) throws TeamRepositoryException {
        return (this.fDefinitions == null ? IBuildResultSearchCriteria.BUILDER.inProjectArea(this.fProjectAreaHandle) : IBuildResultSearchCriteria.BUILDER.forDefinitions(Arrays.asList(this.fDefinitions))).withTag(this.fTag);
    }
}

