/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.query;

import com.ibm.team.build.common.model.IBuildEngineHandle;
import com.ibm.team.build.internal.common.model.dto.IBuildResultSearchCriteria;
import com.ibm.team.build.internal.ui.query.BuildQuery;
import com.ibm.team.build.internal.ui.query.BuildQueryColumnKind;
import com.ibm.team.build.internal.ui.query.BuildQueryRow;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import org.eclipse.core.runtime.IProgressMonitor;

public class BuildQueryByEngine
extends BuildQuery {
    private IBuildEngineHandle fBuildEngineHandle;
    private IProjectAreaHandle fProjectAreaHandle;

    public BuildQueryByEngine(String name, String description, BuildQueryRow.Factory buildQueryRowFactory, IBuildEngineHandle buildEngineHandle, IProjectAreaHandle projectAreaHandle, ITeamRepository teamRepository) {
        super(name, description, buildQueryRowFactory, teamRepository);
        this.fBuildEngineHandle = buildEngineHandle;
        this.fProjectAreaHandle = projectAreaHandle;
    }

    @Override
    protected IBuildResultSearchCriteria getBuildQueryCriteria(IProgressMonitor monitor) throws TeamRepositoryException {
        return this.fBuildEngineHandle == null ? null : IBuildResultSearchCriteria.BUILDER.forEngine(this.fBuildEngineHandle);
    }

    public BuildQueryColumnKind[] getDefaultSortColumns() {
        return new BuildQueryColumnKind[]{BuildQueryColumnKind.StartTime, BuildQueryColumnKind.StartTime};
    }

    public IBuildEngineHandle getBuildEngineHandle() {
        return this.fBuildEngineHandle;
    }

    public IProjectAreaHandle getProjectAreaHandle() {
        return this.fProjectAreaHandle;
    }
}

