/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.query;

import com.ibm.team.build.client.ClientFactory;
import com.ibm.team.build.client.ITeamBuildClient;
import com.ibm.team.build.client.ITeamBuildRequestClient;
import com.ibm.team.build.client.iterator.IBuildResultRecordIterator;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.internal.client.ITeamBuildRecordClient;
import com.ibm.team.build.internal.client.iterator.BuildResultRecordIterator;
import com.ibm.team.build.internal.common.helper.PropertyHelper;
import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.common.model.dto.IBuildResultSearchCriteria;
import com.ibm.team.build.internal.ui.query.BuildQueryRow;
import com.ibm.team.build.internal.ui.query.IBuildQueryColumnKind;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public abstract class BuildQuery {
    private final String fName;
    private String fDescription;
    private final BuildQueryRow.Factory fBuildQueryRowFactory;
    private final ITeamRepository fTeamRepository;

    public BuildQuery(String name, String description, BuildQueryRow.Factory buildQueryRowFactory, ITeamRepository teamRepository) {
        ValidationHelper.validateNotNull((String)"name", (Object)name);
        ValidationHelper.validateNotNull((String)"teamRepository", (Object)teamRepository);
        ValidationHelper.validateNotNull((String)"buildQueryRowFactory", (Object)buildQueryRowFactory);
        this.fName = name;
        this.fTeamRepository = teamRepository;
        this.fBuildQueryRowFactory = buildQueryRowFactory;
        this.fDescription = description != null ? description : name;
    }

    public String getName() {
        return this.fName;
    }

    public String getDescription() {
        return this.fDescription;
    }

    public String getDisplayPreferencesKey() {
        return null;
    }

    public final IBuildResultRecordIterator doIterativeQuery(IProgressMonitor monitor) throws TeamRepositoryException {
        return this.doIterativeQuery(true, false, monitor);
    }

    public final IBuildResultRecordIterator doIterativeQuery(boolean includePersonalBuilds, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.doIterativeQuery(includePersonalBuilds, false, monitor);
    }

    public final IBuildResultRecordIterator doIterativeQuery(boolean includeAllPersonalBuilds, boolean includeMyPersonalBuilds, IProgressMonitor monitor) throws TeamRepositoryException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        String[] buildResultProperties = PropertyHelper.union((String[])IBuildResult.PROPERTIES_VIEW_ITEM, (String[])new String[]{IBuildResult.PROPERTY_BUILD_REQUESTS});
        IBuildResultSearchCriteria buildQueryCriteria = this.getBuildQueryCriteria(monitor);
        if (buildQueryCriteria == null) {
            return BuildResultRecordIterator.getEmptyResultRecordIterator((ITeamRepository)this.getTeamRepository());
        }
        buildQueryCriteria.includePersonalBuilds(includeAllPersonalBuilds);
        buildQueryCriteria.includeMyPersonalBuilds(includeMyPersonalBuilds);
        return this.getRecordClient().getBuildResultRecords(buildQueryCriteria, buildResultProperties, monitor);
    }

    public BuildQueryRow.Factory getRowFactory() {
        return this.fBuildQueryRowFactory;
    }

    protected abstract IBuildResultSearchCriteria getBuildQueryCriteria(IProgressMonitor var1) throws TeamRepositoryException;

    public abstract IBuildQueryColumnKind[] getDefaultSortColumns();

    public ITeamRepository getTeamRepository() {
        return this.fTeamRepository;
    }

    protected ITeamBuildClient getBuildClient() {
        return ClientFactory.getTeamBuildClient((ITeamRepository)this.fTeamRepository);
    }

    protected ITeamBuildRecordClient getRecordClient() {
        return (ITeamBuildRecordClient)this.fTeamRepository.getClientLibrary(ITeamBuildRecordClient.class);
    }

    protected ITeamBuildRequestClient getRequestClient() {
        return ClientFactory.getTeamBuildRequestClient((ITeamRepository)this.fTeamRepository);
    }

    protected IItemManager getItemManager() {
        return this.fTeamRepository.itemManager();
    }
}

