/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.properties;

import com.ibm.team.build.ui.properties.AbstractBuildPropertyEditor;
import com.ibm.team.build.ui.properties.IBuildPropertyEditorContext;
import com.ibm.team.filesystem.ui.WORKSPACES_OR_STREAMS;
import com.ibm.team.filesystem.ui.WorkspaceAndStreamSelectionDialog;
import com.ibm.team.filesystem.ui.wrapper.AbstractPlaceWrapper;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Shell;

public class WorkspacePropertyEditor
extends AbstractBuildPropertyEditor {
    @Override
    public boolean editProperty(IBuildPropertyEditorContext context) {
        IWorkspace workspace = this.openWorkspaceChooserDialog(context.getShell(), context.getTeamRepository());
        if (workspace != null) {
            context.getProperty().setValue(workspace.getItemId().getUuidValue());
            return true;
        }
        return false;
    }

    @Override
    public String getPropertyValueLabel(IBuildPropertyEditorContext context, IProgressMonitor monitor) throws TeamRepositoryException {
        String workspaceUuid;
        String label = workspaceUuid = context.getProperty().getValue();
        if (workspaceUuid.length() > 0) {
            IWorkspaceHandle workspaceHandle = (IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(UUID.valueOf((String)workspaceUuid), null);
            IWorkspace workspace = this.fetchWorkspace(workspaceHandle, context.getTeamRepository(), monitor);
            label = workspace.getName();
        }
        return label;
    }

    protected IWorkspace fetchWorkspace(IWorkspaceHandle workspaceHandle, ITeamRepository teamRepository, IProgressMonitor monitor) throws TeamRepositoryException {
        return (IWorkspace)teamRepository.itemManager().fetchCompleteItem((IItemHandle)workspaceHandle, 0, monitor);
    }

    protected IWorkspace openWorkspaceChooserDialog(Shell shell, ITeamRepository teamRepository) {
        AbstractPlaceWrapper wrapper = WorkspaceAndStreamSelectionDialog.getWorkspaceOrStream((Shell)shell, (ITeamRepository)teamRepository, null, (WORKSPACES_OR_STREAMS)WORKSPACES_OR_STREAMS.WORKSPACES, null);
        if (wrapper != null) {
            return wrapper.getWorkspace();
        }
        return null;
    }

    @Override
    public boolean isValueSane(String value) {
        return this.isUUIDSane(value);
    }

    private boolean isUUIDSane(String uuid) {
        try {
            UUID.valueOf((String)uuid);
        }
        catch (IllegalArgumentException exception) {
            return false;
        }
        return true;
    }
}

