/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.properties;

import com.ibm.team.build.internal.ui.dialogs.RequestBuildDialog;
import com.ibm.team.build.ui.properties.AbstractBuildPropertyEditor;
import com.ibm.team.build.ui.properties.IBuildPropertyEditorContext;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.ui.dialogs.ListDialog;

public class PulldownPropertyEditor
extends AbstractBuildPropertyEditor {
    public static final String ID = "com.ibm.team.build.property.pulldown";
    private static final String PULLDOWN_VALUES_REGEXP = ".*\\s*PULLDOWN\\s*\\{(.*)\\}.*";

    @Override
    public boolean editProperty(IBuildPropertyEditorContext context) {
        Object[] result;
        String value = context.getProperty().getValue();
        String[] values = this.getValues(context);
        ListDialog dialog = new ListDialog(context.getShell());
        dialog.setLabelProvider((ILabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element.equals("")) {
                    return "-- None --";
                }
                return super.getText(element);
            }
        });
        dialog.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
        dialog.setInput((Object)values);
        if (value == null) {
            value = "";
        }
        dialog.setInitialSelections((Object[])new String[]{value});
        dialog.setTitle("Select Property Value");
        dialog.setMessage(NLS.bind((String)"Select a value for the property.", (Object)context.getProperty().getName(), (Object[])new Object[0]));
        if (dialog.open() == 0 && (result = dialog.getResult()) != null && result.length > 0) {
            value = (String)result[0];
            context.getProperty().setValue(value);
            return true;
        }
        return false;
    }

    private String[] getValues(IBuildPropertyEditorContext context) {
        String valuesGroup;
        Matcher matcher;
        ArrayList<String> values = new ArrayList<String>();
        if (!this.isContextBuildRequest(context)) {
            values.add("");
        }
        if ((matcher = Pattern.compile(PULLDOWN_VALUES_REGEXP).matcher(context.getProperty().getDescription())).matches() && (valuesGroup = matcher.group(1)) != null) {
            values.addAll(Arrays.asList(valuesGroup.split("\\|")));
        }
        return values.toArray(new String[values.size()]);
    }

    private boolean isContextBuildRequest(IBuildPropertyEditorContext context) {
        return context.getShell().getParent() != null && context.getShell().getParent().getData() instanceof RequestBuildDialog;
    }

    @Override
    public String getPropertyValueLabel(IBuildPropertyEditorContext context, IProgressMonitor monitor) throws TeamRepositoryException {
        return context.getProperty().getValue();
    }
}

