/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.properties;

import com.ibm.team.build.common.model.IBuildProperty;
import com.ibm.team.build.internal.ui.jobs.TeamBuildJob;
import com.ibm.team.build.internal.ui.properties.Messages;
import com.ibm.team.build.ui.properties.AbstractBuildPropertyEditor;
import com.ibm.team.build.ui.properties.IBuildPropertyEditorContext;
import com.ibm.team.repository.common.ItemNotFoundException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Display;

public class BuildPropertyLabelHelper {
    public void labelAvailable(String label, IBuildProperty buildProperty) {
    }

    public void getPropertyValueLabelInBackground(final AbstractBuildPropertyEditor editor, final IBuildPropertyEditorContext context) {
        TeamBuildJob job = new TeamBuildJob(Messages.BuildPropertyLabelHelper_JOB_LABEL, false){

            protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                String label = editor.getPropertyValueLabel(context, monitor);
                BuildPropertyLabelHelper.this.asyncLabelAvailable(label, context.getProperty());
                return Status.OK_STATUS;
            }

            @Override
            protected void jobFinished(IStatus status) {
                if (status.getException() instanceof ItemNotFoundException) {
                    BuildPropertyLabelHelper.this.asyncLabelAvailable(Messages.BuildPropertyLabelHelper_ITEM_NOT_FOUND, context.getProperty());
                } else if (status.getSeverity() == 4) {
                    BuildPropertyLabelHelper.this.asyncLabelAvailable(Messages.BuildPropertyLabelHelper_EXCEPTION_OCCURRED, context.getProperty());
                }
            }
        };
        job.schedule();
    }

    protected void asyncLabelAvailable(final String label, final IBuildProperty buildProperty) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                BuildPropertyLabelHelper.this.labelAvailable(label, buildProperty);
            }
        });
    }
}

