/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.properties;

import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.editors.result.BuildResultEditorMessages;
import com.ibm.team.build.internal.ui.properties.BuildPropertyEditorExtension;
import java.util.LinkedList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.osgi.util.NLS;

public class BuildPropertyEditorExtensionManager {
    public static final String EXTENSION_POINT_ID_BUILD_PROPERTY_EDITORS = "com.ibm.team.build.ui.buildPropertyEditors";
    protected static BuildPropertyEditorExtensionManager fManager = null;
    private BuildPropertyEditorExtension[] fExtentions = this.loadBuildPropertyEditorExtensions();

    protected BuildPropertyEditorExtensionManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BuildPropertyEditorExtensionManager getInstance() {
        Class<BuildPropertyEditorExtensionManager> clazz = BuildPropertyEditorExtensionManager.class;
        synchronized (BuildPropertyEditorExtensionManager.class) {
            if (fManager == null) {
                fManager = new BuildPropertyEditorExtensionManager();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return fManager;
        }
    }

    public BuildPropertyEditorExtension[] getBuildPropertyEditors() {
        return this.fExtentions;
    }

    public BuildPropertyEditorExtension getBuildPropertyEditor(String id) {
        BuildPropertyEditorExtension[] buildPropertyEditorExtensionArray = this.fExtentions;
        int n = this.fExtentions.length;
        int n2 = 0;
        while (n2 < n) {
            BuildPropertyEditorExtension extension = buildPropertyEditorExtensionArray[n2];
            if (extension.getIdAttribute().equals(id)) {
                return extension;
            }
            ++n2;
        }
        return null;
    }

    protected IConfigurationElement[] getConfigurationElements(IExtensionPoint extensionPoint) {
        return extensionPoint.getConfigurationElements();
    }

    private BuildPropertyEditorExtension[] loadBuildPropertyEditorExtensions() {
        LinkedList<BuildPropertyEditorExtension> extensions = new LinkedList<BuildPropertyEditorExtension>();
        IExtensionPoint extensionPoint = RegistryFactory.getRegistry().getExtensionPoint(EXTENSION_POINT_ID_BUILD_PROPERTY_EDITORS);
        if (extensionPoint != null) {
            IConfigurationElement[] configurationElements = this.getConfigurationElements(extensionPoint);
            int i = 0;
            while (i < configurationElements.length) {
                IConfigurationElement configElement = configurationElements[i];
                try {
                    BuildPropertyEditorExtension extension = new BuildPropertyEditorExtension(configElement);
                    if (!extensions.contains(extension)) {
                        extensions.add(extension);
                    } else {
                        this.handleDuplicateExtensions(configElement);
                    }
                }
                catch (IllegalArgumentException exception) {
                    this.handleIllegalArgumentException(exception, configElement);
                }
                ++i;
            }
        }
        return extensions.toArray(new BuildPropertyEditorExtension[extensions.size()]);
    }

    private void handleDuplicateExtensions(IConfigurationElement configElement) {
        Object[] params = new String[]{this.getExtensionFQN(configElement), configElement.getAttribute("id"), configElement.getContributor().getName()};
        String message = NLS.bind((String)BuildResultEditorMessages.BuildContributionManager_DUPLICATE_EXTENSION_POINT, (Object[])params);
        BuildUIPlugin.log(message);
    }

    private void handleIllegalArgumentException(IllegalArgumentException exception, IConfigurationElement configElement) {
        Object[] params = new String[]{this.getExtensionFQN(configElement), configElement.getContributor().getName()};
        String message = NLS.bind((String)BuildResultEditorMessages.BuildContributionManager_MISSING_OR_INVALID, (Object[])params);
        BuildUIPlugin.log(message);
    }

    private String getExtensionFQN(IConfigurationElement configElement) {
        return String.valueOf(configElement.getNamespaceIdentifier()) + "." + configElement.getName();
    }
}

