/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.listeners;

import com.ibm.team.build.client.ITeamBuildClient;
import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.internal.common.model.dto.DtoFactory;
import com.ibm.team.build.internal.common.model.dto.IBuildDefinitionStatusRecord;
import com.ibm.team.build.internal.common.model.dto.IBuildItemNamePair;
import com.ibm.team.build.internal.common.model.dto.impl.BuildDefinitionStatusRecordImpl;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.domain.BuildDefinitionQueryNode;
import com.ibm.team.build.internal.ui.domain.Messages;
import com.ibm.team.build.internal.ui.helper.EnterpriseHelper;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ISharedItemChangeEvent;
import com.ibm.team.repository.client.ISharedItemChangeListener;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Display;

public abstract class AbstractBuildDefinitionChangeListener
implements ISharedItemChangeListener {
    private final Map<String, Object> fItemIdToNodesMap = new ConcurrentHashMap<String, Object>();
    private final List<ISharedItemChangeEvent> fEventQueue = new ArrayList<ISharedItemChangeEvent>();
    private final Job fItemsChangedJob = new Job(Messages.BuildDomainItemChangeListener_JOB_LABEL){
        {
            this.setSystem(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            ArrayList events;
            List list = AbstractBuildDefinitionChangeListener.this.fEventQueue;
            synchronized (list) {
                events = new ArrayList(AbstractBuildDefinitionChangeListener.this.fEventQueue);
                AbstractBuildDefinitionChangeListener.this.fEventQueue.clear();
            }
            AbstractBuildDefinitionChangeListener.this.handleItemsChanged(events, monitor);
            return Status.OK_STATUS;
        }
    };

    protected void updateControl(HashSet<IItem> itemsToAdd, HashSet<IItem> itemsToRemove, HashSet<IItem> itemsToUpdate) {
        this.addBuildDefinitions(itemsToAdd);
        this.removeBuildDefinitions(itemsToRemove);
        this.updateBuildDefinitions(itemsToUpdate);
    }

    protected void updateBuildDefinitions(HashSet<IItem> itemsToUpdate) {
        List<IBuildDefinition> buildDefinitions = this.getItemsOfType(itemsToUpdate, IBuildDefinition.class);
        if (!buildDefinitions.isEmpty()) {
            StructuredViewer viewer;
            ArrayList<BuildDefinitionQueryNode> nodes = new ArrayList<BuildDefinitionQueryNode>();
            for (IBuildDefinition definition : buildDefinitions) {
                BuildDefinitionQueryNode node = (BuildDefinitionQueryNode)this.getItemIdToNodesMap().get(definition.getItemId().getUuidValue());
                if (node == null) continue;
                node.setBuildDefinition(definition);
                nodes.add(node);
            }
            if (!nodes.isEmpty() && (viewer = this.getViewer()) != null && !viewer.getControl().isDisposed()) {
                viewer.update(nodes.toArray(), null);
            }
        }
    }

    protected void addBuildDefinitions(HashSet<IItem> itemsToAdd) {
        List<IBuildDefinition> buildDefinitions = this.getItemsOfType(itemsToAdd, IBuildDefinition.class);
        if (!buildDefinitions.isEmpty()) {
            ArrayList<BuildDefinitionQueryNode> nodes = new ArrayList<BuildDefinitionQueryNode>();
            for (IBuildDefinition definition : buildDefinitions) {
                BuildDefinitionQueryNode definitionQueryNode;
                if (EnterpriseHelper.isEnterpriseDefinition(definition) || (definitionQueryNode = this.addBuildDefinitionToMap(definition)) == null) continue;
                nodes.add(definitionQueryNode);
            }
            if (!nodes.isEmpty()) {
                this.addNodesToViewer(this.getParent(), nodes.toArray());
            }
        }
    }

    private BuildDefinitionQueryNode addBuildDefinitionToMap(IBuildDefinition buildDefinition) {
        if (this.getItemIdToNodesMap().get(buildDefinition.getItemId().getUuidValue()) == null) {
            IBuildDefinitionStatusRecord record = this.getBuildDefinitionStatusRecord(buildDefinition);
            BuildDefinitionQueryNode node = new BuildDefinitionQueryNode((ITeamRepository)buildDefinition.getOrigin(), record);
            this.getItemIdToNodesMap().put(buildDefinition.getItemId().getUuidValue(), node);
            return node;
        }
        return null;
    }

    protected void removeBuildDefinitions(HashSet<IItem> itemsToRemove) {
        List<IBuildDefinition> buildDefinitions = this.getItemsOfType(itemsToRemove, IBuildDefinition.class);
        if (!buildDefinitions.isEmpty()) {
            ArrayList<BuildDefinitionQueryNode> nodes = new ArrayList<BuildDefinitionQueryNode>();
            for (IBuildDefinition definition : buildDefinitions) {
                Object node = this.getItemIdToNodesMap().get(definition.getItemId().getUuidValue());
                if (node == null) continue;
                nodes.add((BuildDefinitionQueryNode)node);
            }
            if (!nodes.isEmpty()) {
                ((TreeViewer)this.getViewer()).remove(nodes.toArray());
            }
        }
    }

    protected Map<String, Object> getItemIdToNodesMap() {
        return this.fItemIdToNodesMap;
    }

    protected IBuildDefinitionStatusRecord getBuildDefinitionStatusRecord(IBuildDefinition buildDefinition) {
        BuildDefinitionStatusRecordImpl record = (BuildDefinitionStatusRecordImpl)DtoFactory.eINSTANCE.createBuildDefinitionStatusRecord();
        record.setBuildDefinition(buildDefinition);
        return record;
    }

    protected void filterItemsToAdd(HashSet<IItem> itemsToAdd, IProgressMonitor monitor) {
        List<IBuildDefinition> buildDefinitions = this.getItemsOfType(itemsToAdd, IBuildDefinition.class);
        if (!buildDefinitions.isEmpty()) {
            for (IBuildDefinition definition : buildDefinitions) {
                if (this.shouldShowDefinition(definition, monitor)) continue;
                itemsToAdd.remove(definition);
            }
        }
    }

    protected abstract boolean shouldShowDefinition(IBuildDefinition var1, IProgressMonitor var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void itemsChanged(List events) {
        List<ISharedItemChangeEvent> list = this.fEventQueue;
        synchronized (list) {
            for (Object event : events) {
                if (!(event instanceof ISharedItemChangeEvent)) continue;
                this.fEventQueue.add((ISharedItemChangeEvent)event);
            }
        }
        this.fItemsChangedJob.schedule(100L);
    }

    protected void handleItemsChanged(List events, IProgressMonitor monitor) {
        final LinkedHashSet<IItem> itemsToAdd = new LinkedHashSet<IItem>();
        final LinkedHashSet<IItem> itemsToRemove = new LinkedHashSet<IItem>();
        final LinkedHashSet<IItem> itemsToUpdate = new LinkedHashSet<IItem>();
        for (Object object : events) {
            ISharedItemChangeEvent event = (ISharedItemChangeEvent)object;
            IItem sharedItem = event.getSharedItem();
            if (event.getBeforeState() == null) {
                itemsToAdd.add(sharedItem);
                continue;
            }
            if (event.getAfterState() == null) {
                itemsToRemove.add(sharedItem);
                continue;
            }
            itemsToUpdate.add(sharedItem);
        }
        this.filterItemsToAdd(itemsToAdd, monitor);
        if (itemsToAdd.size() > 0) {
            List<IBuildDefinition> unknownBuildDefinitions = this.getItemsOfType(itemsToAdd, IBuildDefinition.class);
            for (IBuildDefinition buildDefinition : unknownBuildDefinitions) {
                if (this.getItemIdToNodesMap().get(buildDefinition.getItemId()) == null) {
                    try {
                        ITeamRepository repository = (ITeamRepository)buildDefinition.getOrigin();
                        ITeamBuildClient buildClient = (ITeamBuildClient)repository.getClientLibrary(ITeamBuildClient.class);
                        IBuildItemNamePair[] pairs = buildClient.getAncestorFolders((IItemHandle)buildDefinition, null);
                        if (pairs.length <= 0) continue;
                        this.addBuildDefinitionToMap(buildDefinition);
                        itemsToAdd.remove(buildDefinition);
                    }
                    catch (Exception e) {
                        BuildUIPlugin.log(e);
                        this.addBuildDefinitionToMap(buildDefinition);
                        itemsToAdd.remove(buildDefinition);
                    }
                    continue;
                }
                itemsToAdd.remove(buildDefinition);
            }
        }
        if (itemsToAdd.size() + itemsToRemove.size() + itemsToUpdate.size() > 0) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    AbstractBuildDefinitionChangeListener.this.updateControl(itemsToAdd, itemsToRemove, itemsToUpdate);
                }
            });
        }
    }

    protected <T extends IItem> List<T> getItemsOfType(Set<IItem> items, Class<T> itemType) {
        ArrayList<IItem> typedItems = new ArrayList<IItem>();
        for (IItem item : items) {
            if (!itemType.isInstance(item)) continue;
            typedItems.add(item);
        }
        return typedItems;
    }

    protected abstract void removeNodesFromViewer(Object var1, Object[] var2);

    protected abstract void addNodesToViewer(Object var1, Object[] var2);

    public abstract StructuredViewer getViewer();

    protected abstract Object getParent();

    protected abstract IProjectAreaHandle getProjectAreaHandle();
}

