/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.jobs;

import com.ibm.team.build.common.TeamBuildStateException;
import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.jobs.Messages;
import com.ibm.team.build.internal.ui.jobs.TeamBuildJobContext;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.LoginFailureException;
import com.ibm.team.repository.common.NotLoggedInException;
import com.ibm.team.repository.common.StaleDataException;
import com.ibm.team.repository.common.transport.ConnectionException;
import com.ibm.team.repository.common.transport.HostUnknownException;
import com.ibm.team.repository.transport.client.AuthenticationException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class TeamBuildJobHelper {
    protected static final String PLUGIN_ID = BuildUIPlugin.getUniqueIdentifier();
    protected static TeamBuildJobContext fContext = new TeamBuildJobContext();

    public static IStatus convertToWarningStatus(IStatus status) {
        if (status.getSeverity() != 4) {
            return status;
        }
        if (status.getChildren().length == 0) {
            return new Status(2, PLUGIN_ID, status.getMessage(), status.getException());
        }
        IStatus[] childStatuses = status.getChildren();
        IStatus[] statuses = new IStatus[childStatuses.length];
        int i = 0;
        while (i < statuses.length) {
            statuses[i] = TeamBuildJobHelper.convertToWarningStatus(childStatuses[i]);
            ++i;
        }
        return new MultiStatus(PLUGIN_ID, status.getCode(), statuses, status.getMessage(), status.getException());
    }

    public static String getStatusMessage(Throwable throwable) {
        ValidationHelper.validateNotNull((String)"throwable", (Object)throwable);
        if (throwable instanceof ItemNotFoundException) {
            ItemNotFoundException exception = (ItemNotFoundException)throwable;
            if (exception.getData() != null) {
                return NLS.bind((String)Messages.BuildJobContext_COULD_NOT_FIND_DELETED_ITEM, (Object)((IItemHandle)exception.getData()).getItemType().getName());
            }
            return Messages.BuildJobContext_ITEM_NOT_FOUND;
        }
        if (throwable instanceof NotLoggedInException) {
            return Messages.BuildJobContext_NOT_LOGGED_IN;
        }
        if (throwable instanceof LoginFailureException) {
            return Messages.BuildJobContext_LOGIN_FAILURE;
        }
        if (throwable instanceof AuthenticationException) {
            return Messages.BuildJobContext_AUTHENTICATION_FAILURE;
        }
        if (throwable instanceof ConnectionException) {
            return Messages.BuildJobContext_CONNECTION_ERROR;
        }
        if (throwable instanceof HostUnknownException) {
            return Messages.BuildJobContext_UNKNOWN_HOST;
        }
        if (throwable instanceof TeamBuildStateException) {
            return Messages.BuildJobContext_WRONG_STATE;
        }
        if (throwable instanceof StaleDataException) {
            StaleDataException exception = (StaleDataException)throwable;
            if (exception.getData() != null) {
                return NLS.bind((String)Messages.BuildJobContext_STALE_DATA_X, (Object)((IItemHandle)exception.getData()).getItemType().getName());
            }
            return Messages.BuildJobContext_STALE_DATA;
        }
        if (throwable.getMessage() != null) {
            return throwable.getMessage();
        }
        return throwable.getClass().getSimpleName();
    }

    public static IStatus createDisplayableStatus(IStatus status) {
        IStatus displayableStatus = status;
        if (!status.isMultiStatus() && status.getException() != null) {
            Status childStatus = new Status(status.getSeverity(), PLUGIN_ID, status.getException().getClass().getName(), null);
            displayableStatus = new MultiStatus(PLUGIN_ID, 32, status.getMessage(), status.getException());
            ((MultiStatus)displayableStatus).add((IStatus)childStatus);
        }
        return displayableStatus;
    }

    public static boolean isExpectedException(Exception exception) {
        ValidationHelper.validateNotNull((String)"exception", (Object)exception);
        return fContext.isExpectedStatus(null, (IStatus)new Status(4, BuildUIPlugin.getUniqueIdentifier(), null, (Throwable)exception));
    }
}

