/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.history;

import com.ibm.team.build.internal.ui.BuildUIPlugin;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.IEncodedStreamContentAccessor;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.Differencer;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.graphics.Image;

public class BuildPropertyCompareEditorInput
extends CompareEditorInput {
    private final String leftElementContent;
    private final String rightElementContent;
    private final String leftLabel;
    private final String rightLabel;

    public BuildPropertyCompareEditorInput(String left, String right, String ancestor, String leftLabel, String rightLabel, CompareConfiguration configuration) {
        super(configuration);
        this.leftElementContent = left;
        this.rightElementContent = right;
        this.leftLabel = leftLabel;
        this.rightLabel = rightLabel;
    }

    protected Object prepareInput(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        TextElement leftElement = null;
        TextElement rightElement = null;
        if (this.leftElementContent != null) {
            leftElement = new TextElement(this.leftElementContent);
        }
        if (this.rightElementContent != null) {
            rightElement = new TextElement(this.rightElementContent);
        }
        Object ancestorElement = null;
        Differencer d = new Differencer(){

            protected Object visit(Object parent, int description, Object ancestor, Object left, Object right) {
                return new DiffNode((IDiffContainer)parent, description, (ITypedElement)ancestor, (ITypedElement)left, (ITypedElement)right);
            }
        };
        Object result = d.findDifferences(ancestorElement != null, monitor, null, ancestorElement, (Object)leftElement, (Object)rightElement);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        BuildPropertyCompareEditorInput other = (BuildPropertyCompareEditorInput)((Object)obj);
        return this.leftLabel.equals(other.leftLabel) && this.rightLabel.equals(other.rightLabel);
    }

    private String getCharset() {
        return "UTF-8";
    }

    private class TextElement
    implements ITypedElement,
    IStreamContentAccessor,
    IEncodedStreamContentAccessor {
        private final String value;

        public TextElement(String value) {
            this.value = value;
        }

        public String getName() {
            return "";
        }

        public Image getImage() {
            return null;
        }

        public String getType() {
            return "txt";
        }

        public InputStream getContents() throws CoreException {
            try {
                return new ByteArrayInputStream(this.value.getBytes(this.getCharset()));
            }
            catch (UnsupportedEncodingException e) {
                BuildUIPlugin.log(e);
                return null;
            }
        }

        public String getCharset() {
            return BuildPropertyCompareEditorInput.this.getCharset();
        }
    }
}

