/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.history;

import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.ui.history.AuditableHistoryPage;
import com.ibm.team.build.internal.ui.history.BuildPropertyCompareEditorInput;
import com.ibm.team.build.internal.ui.history.BuildUIHistoryMessages;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

public class BuildHistoryViewContextMenuListener
implements IMenuListener,
MenuListener {
    private final AuditableHistoryPage fBuildHistoryPage;

    public BuildHistoryViewContextMenuListener(AuditableHistoryPage BuildHistoryPage) {
        ValidationHelper.validateNotNull((String)"BuildHistoryPage", (Object)((Object)BuildHistoryPage));
        this.fBuildHistoryPage = BuildHistoryPage;
    }

    public void menuAboutToShow(IMenuManager manager) {
        IStructuredSelection selectedRows;
        ISelection selection = this.getBuildHistoryPage().getSelectedRows();
        if (selection instanceof IStructuredSelection && (selectedRows = (IStructuredSelection)selection).size() == 2) {
            manager.add((IAction)new CompareBuildHistoryAction(selectedRows));
        }
        manager.add((IContributionItem)new Separator());
    }

    public void menuShown(MenuEvent e) {
        Object o = e.getSource();
        if (o instanceof Menu) {
            MenuItem[] allMenuItems;
            Menu menu = (Menu)o;
            MenuItem[] menuItemArray = allMenuItems = menu.getItems();
            int n = allMenuItems.length;
            int n2 = 0;
            while (n2 < n) {
                MenuItem currentItem = menuItemArray[n2];
                if (currentItem.getData() instanceof ActionContributionItem && ((ActionContributionItem)currentItem.getData()).getAction() instanceof CompareBuildHistoryAction) {
                    menu.setDefaultItem(currentItem);
                    return;
                }
                ++n2;
            }
        }
    }

    protected AuditableHistoryPage getBuildHistoryPage() {
        return this.fBuildHistoryPage;
    }

    private static void internalOpenCompareEditor(CompareEditorInput input, IWorkbenchPage page, IReusableEditor editor) {
        if (page == null || input == null) {
            return;
        }
        if (editor != null) {
            IEditorReference editorReference = BuildHistoryViewContextMenuListener.getEditorReference((IEditorPart)editor, page);
            if (!editorReference.isDirty() && !editorReference.isPinned()) {
                IEditorInput otherInput = editor.getEditorInput();
                if (otherInput.equals(input)) {
                    BuildHistoryViewContextMenuListener.showEditor(page, editor);
                }
            } else {
                CompareUI.openCompareEditorOnPage((CompareEditorInput)input, (IWorkbenchPage)page);
            }
        } else {
            CompareUI.openCompareEditorOnPage((CompareEditorInput)input, (IWorkbenchPage)page);
        }
    }

    public static IEditorReference getEditorReference(IEditorPart editor, IWorkbenchPage page) {
        IEditorReference[] editorReferences = page.getEditorReferences();
        int i = 0;
        while (i < editorReferences.length) {
            if (editor.equals(editorReferences[i].getEditor(false))) {
                return editorReferences[i];
            }
            ++i;
        }
        return null;
    }

    public static IReusableEditor findReusableEditor(CompareEditorInput input, IWorkbenchPage page) {
        IEditorReference[] editorRefs = page.getEditorReferences();
        int i = 0;
        while (i < editorRefs.length) {
            IReusableEditor re;
            IEditorPart part = editorRefs[i].getEditor(false);
            if (part instanceof IReusableEditor && input.equals((re = (IReusableEditor)part).getEditorInput())) {
                return re;
            }
            ++i;
        }
        return null;
    }

    private static void showEditor(final IWorkbenchPage page, final IReusableEditor editor) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                if (OpenStrategy.activateOnOpen()) {
                    page.activate((IWorkbenchPart)editor);
                } else {
                    page.bringToTop((IWorkbenchPart)editor);
                }
            }
        });
    }

    public void menuHidden(MenuEvent e) {
    }

    public class CompareBuildHistoryAction
    extends Action {
        private final IStructuredSelection fSelectedRows;

        public CompareBuildHistoryAction(IStructuredSelection selectedRows) {
            super(BuildUIHistoryMessages.AuditableHistoryPage_COMPARE_PROPERTIES);
            ValidationHelper.validateNotNull((String)"selectedRows", (Object)selectedRows);
            this.fSelectedRows = selectedRows;
        }

        public void run() {
            Object[] selectedElements = this.fSelectedRows.toArray();
            if (selectedElements != null) {
                Object leftElement = selectedElements[0];
                Object rightElement = selectedElements[1];
                String leftLabel = BuildHistoryViewContextMenuListener.this.getBuildHistoryPage().getCompareInputItemLabel(leftElement);
                String rightLabel = BuildHistoryViewContextMenuListener.this.getBuildHistoryPage().getCompareInputItemLabel(rightElement);
                CompareConfiguration configuration = new CompareConfiguration();
                configuration.setLeftEditable(false);
                configuration.setRightEditable(false);
                configuration.setLeftLabel(leftLabel);
                configuration.setRightLabel(rightLabel);
                BuildPropertyCompareEditorInput input = new BuildPropertyCompareEditorInput(BuildHistoryViewContextMenuListener.this.getBuildHistoryPage().getPropertiesAsText(leftElement), BuildHistoryViewContextMenuListener.this.getBuildHistoryPage().getPropertiesAsText(rightElement), null, leftLabel, rightLabel, configuration);
                String title = BuildHistoryViewContextMenuListener.this.getBuildHistoryPage().getInputID();
                input.setTitle(title != null ? String.valueOf(title) + "-" + BuildUIHistoryMessages.AuditableHistoryPage_COMPARE_TITLE : BuildUIHistoryMessages.AuditableHistoryPage_COMPARE_TITLE);
                BuildHistoryViewContextMenuListener.internalOpenCompareEditor(input, BuildHistoryViewContextMenuListener.this.fBuildHistoryPage.getSite().getPage(), BuildHistoryViewContextMenuListener.findReusableEditor(input, BuildHistoryViewContextMenuListener.this.fBuildHistoryPage.getSite().getPage()));
            }
        }
    }
}

