/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.history;

import com.ibm.team.build.common.model.IBuildEngine;
import com.ibm.team.build.common.model.IBuildProperty;
import com.ibm.team.build.internal.common.helper.TimeFormatHelper;
import com.ibm.team.build.internal.ui.history.AuditableHistoryPage;
import com.ibm.team.build.internal.ui.history.BuildUIHistoryMessages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import java.util.Date;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class BuildEngineHistoryPage
extends AuditableHistoryPage {
    public String getName() {
        Object input = this.getInput();
        if (input instanceof IBuildEngine) {
            return ((IBuildEngine)input).getId();
        }
        return "";
    }

    public boolean isValidInput(Object object) {
        return object instanceof IBuildEngine;
    }

    @Override
    protected void computeHistory(Object element, AuditableHistoryPage.StateCollector collector, IProgressMonitor monitor) {
        if (element instanceof IBuildEngine) {
            IBuildEngine definition = (IBuildEngine)element;
            ITeamRepository repository = (ITeamRepository)definition.getOrigin();
            this.computeAuditableHistory(repository, (IAuditableHandle)definition, collector, monitor);
        }
    }

    @Override
    protected String getPropertiesAsText(Object element) {
        IBuildEngine engine = (IBuildEngine)element;
        String propetiesText = "";
        List properties = engine.getProperties();
        if (properties != null) {
            for (IBuildProperty property : properties) {
                if (!property.isGenericEditAllowed()) continue;
                propetiesText = String.valueOf(propetiesText) + property.getName() + "=" + property.getValue() + "\n";
            }
        }
        return propetiesText;
    }

    @Override
    protected String getCompareInputItemLabel(Object element) {
        IBuildEngine engine = (IBuildEngine)element;
        Date modified = engine.modified();
        if (modified != null) {
            return TimeFormatHelper.getDateString((long)modified.getTime());
        }
        return BuildUIHistoryMessages.AuditableHistoryLabelProvider_UNKNOWN_TIME;
    }

    @Override
    protected String getInputID() {
        IBuildEngine engine = (IBuildEngine)this.getInput();
        if (engine != null) {
            return engine.getId();
        }
        return null;
    }
}

