/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.history;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildProperty;
import com.ibm.team.build.internal.common.helper.TimeFormatHelper;
import com.ibm.team.build.internal.ui.history.AuditableHistoryPage;
import com.ibm.team.build.internal.ui.history.BuildUIHistoryMessages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import java.util.Date;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class BuildDefinitionHistoryPage
extends AuditableHistoryPage {
    public String getName() {
        Object input = this.getInput();
        if (input instanceof IBuildDefinition) {
            return ((IBuildDefinition)input).getId();
        }
        return "";
    }

    public boolean isValidInput(Object object) {
        return object instanceof IBuildDefinition;
    }

    @Override
    protected void computeHistory(Object element, AuditableHistoryPage.StateCollector collector, IProgressMonitor monitor) {
        if (element instanceof IBuildDefinition) {
            IBuildDefinition definition = (IBuildDefinition)element;
            ITeamRepository repository = (ITeamRepository)definition.getOrigin();
            this.computeAuditableHistory(repository, (IAuditableHandle)definition, collector, monitor);
        }
    }

    @Override
    protected String getPropertiesAsText(Object element) {
        IBuildDefinition definition = (IBuildDefinition)element;
        String propetiesText = "";
        List properties = definition.getProperties();
        if (properties != null) {
            for (IBuildProperty property : properties) {
                if (!property.isGenericEditAllowed()) continue;
                propetiesText = String.valueOf(propetiesText) + property.getName() + "=" + property.getValue() + "\n";
            }
        }
        return propetiesText;
    }

    @Override
    protected String getCompareInputItemLabel(Object element) {
        IBuildDefinition definition = (IBuildDefinition)element;
        Date modified = definition.modified();
        if (modified != null) {
            return TimeFormatHelper.getDateString((long)modified.getTime());
        }
        return BuildUIHistoryMessages.AuditableHistoryLabelProvider_UNKNOWN_TIME;
    }

    @Override
    protected String getInputID() {
        IBuildDefinition definition = (IBuildDefinition)this.getInput();
        if (definition != null) {
            return definition.getId();
        }
        return null;
    }
}

