/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.history;

import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.history.AuditableHistoryLabelProvider;
import com.ibm.team.build.internal.ui.history.BuildHistoryViewContextMenuListener;
import com.ibm.team.build.internal.ui.history.BuildUIHistoryMessages;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.team.ui.history.HistoryPage;

public abstract class AuditableHistoryPage
extends HistoryPage {
    protected TableViewer fViewer;
    private Job fHistoryJob;

    public boolean inputSet() {
        this.fViewer.setInput(new ArrayList());
        final Object input = this.getInput();
        if (this.isValidInput(input)) {
            if (this.fHistoryJob != null) {
                this.fHistoryJob.cancel();
            }
            this.fHistoryJob = new Job(BuildUIHistoryMessages.AuditableHistoryPage_COMPUTING){

                protected IStatus run(IProgressMonitor monitor) {
                    AuditableHistoryPage.this.computeHistory(input, new StateCollector(), monitor);
                    return Status.OK_STATUS;
                }
            };
            this.fHistoryJob.schedule();
            return true;
        }
        return false;
    }

    protected abstract void computeHistory(Object var1, StateCollector var2, IProgressMonitor var3);

    public void createControl(Composite parent) {
        this.fViewer = new TableViewer(parent, 68354);
        Table table = this.fViewer.getTable();
        table.setLinesVisible(true);
        TableLayout layout = new TableLayout();
        table.setLayout((Layout)layout);
        table.setHeaderVisible(true);
        this.createColumn(table, layout, 50.0, BuildUIHistoryMessages.AuditableHistoryPage_TIME);
        this.createColumn(table, layout, 50.0, BuildUIHistoryMessages.AuditableHistoryPage_MODIFIED_BY);
        table.setLayoutData((Object)new GridData(1808));
        this.fViewer.setLabelProvider((IBaseLabelProvider)new AuditableHistoryLabelProvider(this.fViewer));
        this.fViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fViewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                IItem item1 = (IItem)e1;
                IItem item2 = (IItem)e2;
                if (item1.modified() != null && item2.modified() != null) {
                    return item2.modified().compareTo(item1.modified());
                }
                return 0;
            }
        });
        this.initContextMenuActions();
    }

    protected void createColumn(Table table, TableLayout layout, double ratio, String text) {
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData((int)Math.floor(ratio * 100.0), 100, true));
        TableColumn tc = new TableColumn(table, 0);
        tc.setAlignment(16384);
        tc.setText(text);
        tc.setMoveable(false);
        tc.setResizable(true);
    }

    public Control getControl() {
        return this.fViewer.getControl();
    }

    public void dispose() {
        super.dispose();
        this.fViewer.getTable().dispose();
    }

    public void setFocus() {
        this.getControl().setFocus();
    }

    public String getDescription() {
        return "";
    }

    public void refresh() {
        this.inputSet();
    }

    public Object getAdapter(Class adapter) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    protected void computeAuditableHistory(ITeamRepository repository, IAuditableHandle auditableHandle, StateCollector collector, IProgressMonitor monitor) {
        int maxChunkSize = 20;
        int chunkIncrement = 5;
        monitor.beginTask("", 1000);
        try {
            try {
                IItemManager itemManager = repository.itemManager();
                List allStateHandles = itemManager.fetchAllStateHandles(auditableHandle, (IProgressMonitor)new SubProgressMonitor(monitor, 200));
                int n = allStateHandles.size();
                ArrayList orderedAllStateHandles = new ArrayList(n);
                if (!allStateHandles.isEmpty()) {
                    orderedAllStateHandles.addAll(allStateHandles.subList(1, n));
                    Collections.reverse(orderedAllStateHandles);
                    orderedAllStateHandles.add(0, allStateHandles.get(0));
                }
                int chunkSize = 0;
                int i = 0;
                while (i < n) {
                    if (chunkSize < maxChunkSize) {
                        chunkSize += chunkIncrement;
                    }
                    List allStates = itemManager.fetchCompleteStates(orderedAllStateHandles.subList(i, Math.min(i + chunkSize, n)), (IProgressMonitor)new SubProgressMonitor(monitor, 800 * chunkSize / n));
                    collector.addStates(allStates);
                    i += chunkSize;
                }
            }
            catch (TeamRepositoryException e) {
                BuildUIPlugin.log(e);
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    private void initContextMenuActions() {
        MenuManager contextMenuManager = new MenuManager("#PopupMenu");
        contextMenuManager.setRemoveAllWhenShown(true);
        BuildHistoryViewContextMenuListener listener = new BuildHistoryViewContextMenuListener(this);
        contextMenuManager.addMenuListener((IMenuListener)listener);
        Menu contextMenu = contextMenuManager.createContextMenu(this.fViewer.getControl());
        this.fViewer.getControl().setMenu(contextMenu);
        contextMenu.addMenuListener((MenuListener)listener);
        this.getSite().registerContextMenu("COMPARE_HISTORY", contextMenuManager, (ISelectionProvider)this.fViewer);
    }

    protected ISelection getSelectedRows() {
        return this.fViewer.getSelection();
    }

    protected abstract String getPropertiesAsText(Object var1);

    protected abstract String getCompareInputItemLabel(Object var1);

    protected abstract String getInputID();

    protected class StateCollector {
        private List fStates = new ArrayList();

        public void addStates(List states) {
            this.fStates.addAll(states);
            final Control control = AuditableHistoryPage.this.fViewer.getControl();
            if (!control.isDisposed()) {
                control.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!control.isDisposed()) {
                            ((StateCollector)StateCollector.this).AuditableHistoryPage.this.fViewer.setInput((Object)StateCollector.this.fStates);
                        }
                    }
                });
            }
        }
    }
}

