/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.history;

import com.ibm.team.build.internal.common.helper.TimeFormatHelper;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.history.BuildUIHistoryMessages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.Date;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Table;

public class AuditableHistoryLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private final TableViewer fViewer;

    public AuditableHistoryLabelProvider(TableViewer viewer) {
        this.fViewer = viewer;
    }

    public String getColumnText(final Object element, int columnIndex) {
        if (element instanceof IItem) {
            final IItem item = (IItem)element;
            switch (columnIndex) {
                case 0: {
                    Date modified = item.modified();
                    if (modified != null) {
                        return TimeFormatHelper.getDateString((long)modified.getTime());
                    }
                    return BuildUIHistoryMessages.AuditableHistoryLabelProvider_UNKNOWN_TIME;
                }
                case 1: {
                    final IContributorHandle modifiedBy = item.getModifiedBy();
                    IContributor contributor = (IContributor)((ITeamRepository)item.getOrigin()).itemManager().getSharedItemIfKnown((IItemHandle)modifiedBy);
                    if (contributor != null) {
                        return contributor.getName();
                    }
                    new Job(BuildUIHistoryMessages.AuditableHistoryLabelProvider_FETCHING_CONTRIBUTOR){

                        protected IStatus run(IProgressMonitor monitor) {
                            try {
                                final IItem fetched = ((ITeamRepository)item.getOrigin()).itemManager().fetchCompleteItem((IItemHandle)modifiedBy, 0, monitor);
                                final Table table = AuditableHistoryLabelProvider.this.fViewer.getTable();
                                if (!table.isDisposed()) {
                                    table.getDisplay().asyncExec(new Runnable(){

                                        @Override
                                        public void run() {
                                            if (fetched != null && !table.isDisposed()) {
                                                AuditableHistoryLabelProvider.this.fViewer.update(element, null);
                                            }
                                        }
                                    });
                                }
                            }
                            catch (TeamRepositoryException e) {
                                BuildUIPlugin.log(e);
                            }
                            return Status.OK_STATUS;
                        }
                    }.schedule();
                    return "";
                }
            }
        }
        return null;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }
}

