/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.helper;

import com.ibm.team.build.common.BuildItemFactory;
import com.ibm.team.build.common.model.IBuildProperty;
import com.ibm.team.build.internal.common.helper.BuildEngineHelper;
import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.ui.helper.BuildUIHelperMessages;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.xml.sax.SAXParseException;

public class XMLBuildObjectHelper {
    private static final String ROOT_BUILD_PROPERTIES = "BuildProperties";
    private static final String ROOT_BUILD_PROPERTY = "BuildProperty";

    public static List<IBuildProperty> parseBuildPropertiesFromXML(String xmlString) throws TeamRepositoryException {
        ValidationHelper.validateNotNull((String)"xmlString", (Object)xmlString);
        ArrayList<IBuildProperty> buildProperties = new ArrayList<IBuildProperty>();
        try {
            XMLMemento rootMemento = XMLMemento.createReadRoot((Reader)new StringReader(xmlString.trim()));
            if (rootMemento.getType().equals(ROOT_BUILD_PROPERTIES)) {
                IMemento[] propertyChildren;
                IMemento[] iMementoArray = propertyChildren = rootMemento.getChildren(ROOT_BUILD_PROPERTY);
                int n = propertyChildren.length;
                int n2 = 0;
                while (n2 < n) {
                    IMemento currentProperty = iMementoArray[n2];
                    IBuildProperty parsedProperty = XMLBuildObjectHelper.parseBuildPropertyFromXML(currentProperty);
                    if (parsedProperty != null) {
                        buildProperties.add(parsedProperty);
                    }
                    ++n2;
                }
            }
            return buildProperties;
        }
        catch (WorkbenchException e) {
            if (e.getCause() instanceof SAXParseException) {
                SAXParseException parseException = (SAXParseException)e.getCause();
                throw new TeamRepositoryException(NLS.bind((String)BuildUIHelperMessages.XMLBuildObjectHelper_PARSER_ERROR_LINE_COLUMN, (Object)parseException.getLineNumber(), (Object)parseException.getColumnNumber()), (Throwable)e);
            }
            throw new TeamRepositoryException((Throwable)e);
        }
    }

    private static IBuildProperty parseBuildPropertyFromXML(IMemento buildPropertyMemento) {
        if (buildPropertyMemento != null) {
            HashMap<String, String> propertyValues = new HashMap<String, String>();
            BuildPropertyAttributes[] buildPropertyAttributesArray = BuildPropertyAttributes.values();
            int n = buildPropertyAttributesArray.length;
            int n2 = 0;
            while (n2 < n) {
                BuildPropertyAttributes attributeId = buildPropertyAttributesArray[n2];
                String currentAttribute = buildPropertyMemento.getString(attributeId.getId());
                propertyValues.put(attributeId.getId(), currentAttribute != null ? currentAttribute : "");
                ++n2;
            }
            if (!((String)propertyValues.get(BuildPropertyAttributes.NAME_ATTRIBUTE.getId())).equals("")) {
                IBuildProperty buildProperty = BuildItemFactory.createBuildProperty();
                buildProperty.setKind((String)propertyValues.get(BuildPropertyAttributes.KIND_ATTRIBUTE.getId()));
                buildProperty.setName((String)propertyValues.get(BuildPropertyAttributes.NAME_ATTRIBUTE.getId()));
                buildProperty.setValue((String)propertyValues.get(BuildPropertyAttributes.VALUE_ATTRIBUTE.getId()));
                buildProperty.setDescription((String)propertyValues.get(BuildPropertyAttributes.DESCRIPTION_ATTRIBUTE.getId()));
                boolean isHidden = Boolean.parseBoolean((String)propertyValues.get(BuildPropertyAttributes.HIDDEN_ATTRIBUTE.getId()));
                if (isHidden) {
                    buildProperty.setHidden(true);
                }
                return buildProperty;
            }
        }
        return null;
    }

    public static boolean isSanePropertyXML(String string) {
        if (string == null) {
            return false;
        }
        String trimmedString = string.trim();
        return trimmedString.charAt(0) == '<' && trimmedString.contains(ROOT_BUILD_PROPERTIES);
    }

    public static String getXMLFromBuildProperties(List<IBuildProperty> buildProperties) throws IllegalArgumentException, TeamRepositoryException {
        ValidationHelper.validateNotNull((String)"buildProperties", buildProperties);
        try {
            XMLMemento rootMemento = XMLMemento.createWriteRoot((String)ROOT_BUILD_PROPERTIES);
            for (IBuildProperty currentProperty : buildProperties) {
                String kind = currentProperty.getKind();
                String name = currentProperty.getName();
                String description = currentProperty.getDescription();
                String value = currentProperty.getValue();
                boolean hidden = currentProperty.isHidden();
                IMemento buildPropertyMemento = rootMemento.createChild(ROOT_BUILD_PROPERTY);
                XMLBuildObjectHelper.setAttribute(BuildPropertyAttributes.KIND_ATTRIBUTE.getId(), kind, buildPropertyMemento);
                XMLBuildObjectHelper.setAttribute(BuildPropertyAttributes.NAME_ATTRIBUTE.getId(), name, buildPropertyMemento);
                if (!BuildEngineHelper.isBuildForgeHiddenProperty((IBuildProperty)currentProperty) && !currentProperty.isHidden()) {
                    XMLBuildObjectHelper.setAttribute(BuildPropertyAttributes.VALUE_ATTRIBUTE.getId(), value, buildPropertyMemento);
                }
                XMLBuildObjectHelper.setAttribute(BuildPropertyAttributes.DESCRIPTION_ATTRIBUTE.getId(), description, buildPropertyMemento);
                if (!hidden) continue;
                XMLBuildObjectHelper.setAttribute(BuildPropertyAttributes.HIDDEN_ATTRIBUTE.getId(), Boolean.toString(hidden), buildPropertyMemento);
            }
            StringWriter writer = new StringWriter();
            rootMemento.save((Writer)writer);
            return writer.getBuffer().toString();
        }
        catch (IOException exception) {
            throw new TeamRepositoryException((Throwable)exception);
        }
    }

    private static void setAttribute(String elementName, String attributeText, IMemento memento) {
        if (attributeText != null && attributeText.length() > 0) {
            memento.putString(elementName, attributeText);
        }
    }

    private static enum BuildPropertyAttributes {
        KIND_ATTRIBUTE("kind"),
        NAME_ATTRIBUTE("name"),
        VALUE_ATTRIBUTE("value"),
        DESCRIPTION_ATTRIBUTE("description"),
        HIDDEN_ATTRIBUTE("hidden");

        private String fId;

        private BuildPropertyAttributes(String id) {
            this.fId = id;
        }

        public String getId() {
            return this.fId;
        }
    }
}

