/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.helper;

import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.helper.BuildUIHelper;
import com.ibm.team.build.internal.ui.helper.BuildUIHelperMessages;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class WorkspaceHelper {
    private static WorkspaceHelper SINGLETON_WORKSPACE_HELPER = new WorkspaceHelper();

    public static boolean openWorkspaceFile(IFile file, int lineNumber, IEditorSite editorSite) {
        ValidationHelper.validateNotNull((String)"file", (Object)file);
        ValidationHelper.validateNotNull((String)"editorSite", (Object)editorSite);
        return SINGLETON_WORKSPACE_HELPER.openWorkspaceFileToLocation(file, lineNumber, editorSite);
    }

    protected boolean openWorkspaceFileToLocation(IFile file, Object location, IEditorSite editorSite) {
        if (!file.exists()) {
            String errorMessage = NLS.bind((String)BuildUIHelperMessages.WorkspaceHelper_FILE_NOT_FOUND_ERROR_MESSAGE, (Object)file.getName());
            this.showErrorDialog(errorMessage, BuildUIHelperMessages.WorkspaceHelper_FILE_NOT_FOUND_DIALOG_TITLE, null);
            return false;
        }
        try {
            IEditorPart editorPart = this.openEditor(editorSite.getPage(), file);
            String fileName = file.getName();
            this.positionToLocationInEditor(editorPart, location, fileName);
            return true;
        }
        catch (CoreException exception) {
            BuildUIPlugin.log(exception.getStatus());
            this.showErrorDialog(BuildUIHelperMessages.WorkspaceHelper_ERROR_OPENING_FILE_MESSAGE, null, (Exception)((Object)exception));
            return false;
        }
    }

    protected void positionToLocationInEditor(IEditorPart editorPart, Object location, String fileName) {
        block8: {
            if (editorPart instanceof ITextEditor) {
                IEditorInput editorInput = editorPart.getEditorInput();
                ITextEditor textEditor = (ITextEditor)editorPart;
                IDocumentProvider provider = textEditor.getDocumentProvider();
                if (provider != null) {
                    try {
                        try {
                            this.connectProvider(provider, editorInput);
                            IDocument document = provider.getDocument((Object)editorInput);
                            if (document == null) break block8;
                            if (location instanceof Integer) {
                                int lineNumber = (Integer)location;
                                this.navigateToLineNumber(textEditor, document, lineNumber, fileName);
                                break block8;
                            }
                            this.navigateToTestMethod(textEditor, document, location.toString(), fileName);
                        }
                        catch (CoreException exception) {
                            String message = location instanceof Integer ? NLS.bind((String)BuildUIHelperMessages.WorkspaceHelper_NAVIGATE_TO_LINE_FAILURE, (Object)((Integer)location), (Object)fileName) : NLS.bind((String)BuildUIHelperMessages.WorkspaceHelper_NAVIGATE_TO_METHOD_FAILURE, (Object)location.toString(), (Object)fileName);
                            this.showErrorDialog(message, BuildUIHelperMessages.WorkspaceHelper_LOCATION_NOT_FOUND_DIALOG_TITLE, (Exception)((Object)exception));
                            BuildUIPlugin.log(exception.getStatus());
                            provider.disconnect((Object)editorInput);
                        }
                    }
                    finally {
                        provider.disconnect((Object)editorInput);
                    }
                }
            }
        }
    }

    protected void navigateToLineNumber(ITextEditor textEditor, IDocument document, int lineNumber, String fileName) {
        try {
            int editorLineNumber = lineNumber;
            if (editorLineNumber != 0) {
                --editorLineNumber;
            }
            IRegion line = document.getLineInformation(editorLineNumber);
            textEditor.selectAndReveal(line.getOffset(), line.getLength());
        }
        catch (BadLocationException e) {
            this.openWarningDialog(NLS.bind((String)BuildUIHelperMessages.WorkspaceHelper_LOCATION_NOT_FOUND_ERROR_MESSAGE, (Object[])new String[]{Integer.toString(lineNumber), fileName}), BuildUIHelperMessages.WorkspaceHelper_LOCATION_NOT_FOUND_DIALOG_TITLE);
        }
    }

    protected void navigateToTestMethod(ITextEditor textEditor, IDocument document, String testCaseName, String fileName) {
        Pattern testCasePattern = Pattern.compile("public[\\s]*void[\\s]*" + testCaseName + "[\\s]*\\(");
        Matcher testCaseMatcher = testCasePattern.matcher(document.get());
        if (testCaseMatcher.find()) {
            int start = testCaseMatcher.start() + testCaseMatcher.group().indexOf(testCaseName);
            textEditor.selectAndReveal(start, testCaseName.length());
        } else {
            this.openWarningDialog(NLS.bind((String)BuildUIHelperMessages.WorkspaceHelper_JUNIT_TESTCASE_NOT_FOUND_ERROR_MESSAGE, (Object[])new String[]{testCaseName, fileName}), BuildUIHelperMessages.WorkspaceHelper_LOCATION_NOT_FOUND_DIALOG_TITLE);
        }
    }

    protected IEditorPart openEditor(IWorkbenchPage page, IFile file) throws PartInitException {
        return IDE.openEditor((IWorkbenchPage)page, (IFile)file);
    }

    protected void connectProvider(IDocumentProvider provider, IEditorInput editorInput) throws CoreException {
        provider.connect((Object)editorInput);
    }

    protected void showErrorDialog(String message, String title, Exception exception) {
        BuildUIHelper.showErrorDialog(message, title, exception);
    }

    protected MessageDialog createWarningDialog(String message, String title) {
        return new MessageDialog(null, title, null, message, 4, new String[]{IDialogConstants.OK_LABEL}, 0);
    }

    protected void openWarningDialog(String message, String title) {
        this.createWarningDialog(message, title).open();
    }
}

