/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.helper;

import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.ui.BuildJob;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.editors.result.BuildResultEditorMessages;
import com.ibm.team.build.internal.ui.helper.BuildUIHelper;
import com.ibm.team.build.internal.ui.helper.BuildUIHelperMessages;
import com.ibm.team.build.internal.ui.helper.FileHelper;
import com.ibm.team.foundation.common.util.Adapters;
import com.ibm.team.foundation.rcp.core.IAuthenticatorChecker;
import com.ibm.team.foundation.rcp.core.hyperlinks.Hyperlinks;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.UUID;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public class URLHelper {
    public static final int BYTES_PER_KILOBYTE = 1024;
    private static URLHelper SINGLETON_URL_HELPER = new URLHelper();
    public static final int SIZE_NOT_AVAILABLE = Integer.MIN_VALUE;

    public static void saveURLToFile(String url, Shell shell) {
        ValidationHelper.validateNotNull((String)"url", (Object)url);
        ValidationHelper.validateNotNull((String)"shell", (Object)shell);
        SINGLETON_URL_HELPER.doSaveURLToFile(url, shell);
    }

    public static void openURL(String url, boolean openInBrowser, IWorkbenchPartSite partSite) {
        ValidationHelper.validateNotNull((String)"url", (Object)url);
        ValidationHelper.validateNotNull((String)"partSite", (Object)partSite);
        SINGLETON_URL_HELPER.doOpenURL(url, openInBrowser, partSite);
    }

    protected boolean isSpecialHandlingUrl(URL url) {
        return url.getProtocol().equals("ftp");
    }

    public static int getHttpURLContentSize(URL url) throws IOException {
        ValidationHelper.validateNotNull((String)"url", (Object)url);
        return SINGLETON_URL_HELPER.doGetHttpURLContentSize(url);
    }

    protected void doSaveURLToFile(String url, Shell shell) {
        String fileName = this.getDefaultFileName(url);
        String promptedFileName = this.promptToSaveFile(fileName, shell);
        if (promptedFileName == null) {
            return;
        }
        this.doOpenSaveURL(url, promptedFileName, shell, false, null);
    }

    protected String getDefaultFileName(String url) {
        String fileName = url;
        fileName = FileHelper.truncateQueryParameter(fileName);
        while (fileName.length() > 0 && this.endsWithSeparator(fileName)) {
            fileName = fileName.substring(0, fileName.length() - 1);
        }
        String filenameNormalized = fileName.replace('\\', '/');
        int index = filenameNormalized.lastIndexOf(47);
        if (index != -1) {
            fileName = filenameNormalized.substring(index + 1);
        }
        if ((fileName = FileHelper.sanitizeURLStringToFileName(fileName)).length() == 0) {
            fileName = "tempRTCFile" + UUID.randomUUID() + ".tmp";
        }
        return fileName;
    }

    private boolean endsWithSeparator(String string) {
        return string.endsWith("/") || string.endsWith("\\");
    }

    protected void openHyperlink(URL url) {
        URI uri = URI.create(url.toString());
        Hyperlinks.open((URI)uri, null);
    }

    protected void doOpenURL(String urlString, boolean openInBrowser, IWorkbenchPartSite partSite) {
        if (urlString.length() > 0) {
            URL url = null;
            try {
                url = new URL(urlString);
                if (openInBrowser || this.isSpecialHandlingUrl(url)) {
                    this.openHyperlink(url);
                } else {
                    this.doOpenSaveURL(urlString, FileHelper.createTemporaryFileName(this.getDefaultFileName(urlString)), partSite.getShell(), true, partSite);
                }
            }
            catch (MalformedURLException exception) {
                String errorMessage = BuildUIHelperMessages.URLHelper_ERROR_DOWNLOADING_FILE;
                String reason = NLS.bind((String)BuildUIHelperMessages.URLHelper_MALFORMED_URL, (Object)urlString);
                this.showErrorDialog(errorMessage, reason, exception);
            }
        }
    }

    protected void doOpenSaveURL(final String url, final String fileName, final Shell shell, final boolean openFile, final IWorkbenchPartSite partSite) {
        String jobTitle = openFile ? BuildResultEditorMessages.AbstractDownloadsPage_OPENING_TITLE : BuildResultEditorMessages.AbstractDownloadsPage_DOWNLOADING_TITLE;
        BuildJob downloadJob = new BuildJob(NLS.bind((String)jobTitle, (Object)url)){

            public IStatus run(IProgressMonitor monitor) {
                boolean success = URLHelper.this.initiateDownload(url, fileName, shell, monitor);
                if (openFile && success) {
                    URLHelper.this.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            URLHelper.this.openFileInEditor(new File(fileName), partSite);
                        }
                    });
                }
                return Status.OK_STATUS;
            }

            @Override
            public boolean belongsTo(Object family) {
                return family == BuildUIPlugin.getDefault();
            }
        };
        this.scheduleJob(downloadJob, shell);
    }

    protected void openFileInEditor(File file, IWorkbenchPartSite partSite) {
        try {
            BuildUIHelper.openFileInEditor(file, partSite.getPage());
        }
        catch (CoreException exception) {
            BuildUIPlugin.log(exception);
        }
    }

    protected int doGetHttpURLContentSize(URL url) throws IOException {
        URLConnection connection = this.openConnection(url);
        int size = -1;
        if (connection instanceof HttpURLConnection) {
            HttpURLConnection httpConnection = (HttpURLConnection)connection;
            if (httpConnection.getResponseCode() == 404) {
                throw new FileNotFoundException(url.toString());
            }
            if (httpConnection.getResponseCode() == 200 && (size = connection.getContentLength()) == -1 && httpConnection.getHeaderField("content-length") == null) {
                size = Integer.MIN_VALUE;
            }
        } else {
            size = Integer.MIN_VALUE;
        }
        return size;
    }

    protected void scheduleJob(BuildJob job, Shell shell) {
        IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
        progressService.showInDialog(shell, (Job)job);
        job.scheduleJob();
    }

    protected String promptToSaveFile(String filename, Shell shell) {
        return FileHelper.promptToSaveFile(filename, shell);
    }

    /*
     * Exception decompiling
     */
    protected boolean initiateDownload(String fileUrl, String fileName, Shell shell, IProgressMonitor monitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [26[CATCHBLOCK]], but top level block is 10[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected URLConnection openConnection(URL url) throws IOException {
        this.ensureAuthenticatorRegistered(url);
        return url.openConnection();
    }

    protected void ensureAuthenticatorRegistered(URL url) {
        IAuthenticatorChecker adapter = (IAuthenticatorChecker)Adapters.getAdapter((Object)url, IAuthenticatorChecker.class);
        if (adapter != null) {
            adapter.ensureAuthenticatorRegistered();
        }
    }

    protected void showErrorDialog(String errorMessage, String errorReason, Exception exception) {
        if (errorReason != null) {
            BuildUIHelper.showErrorDialog(errorMessage, errorReason, null, exception);
        } else {
            BuildUIHelper.showErrorDialog(errorMessage, null, exception);
        }
    }

    protected void asyncExec(Runnable runnable) {
        Display.getDefault().asyncExec(runnable);
    }

    protected void copyFile(InputStream inStream, OutputStream outStream, String fileName, int length, IProgressMonitor monitor) throws IOException {
        int retrieved = 0;
        byte[] buffer = new byte[32768];
        int taskLength = this.getMonitorLength(length);
        monitor.beginTask(NLS.bind((String)BuildUIHelperMessages.URLHelper_DOWNLOADING_STATUS_MESSAGE, (Object)fileName), taskLength);
        try {
            int bytesReadSinceUpdate = 0;
            int numbytes = inStream.read(buffer);
            while (numbytes > -1) {
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                outStream.write(buffer, 0, numbytes);
                bytesReadSinceUpdate += numbytes;
                bytesReadSinceUpdate = this.updateProgress(monitor, taskLength, retrieved += numbytes, bytesReadSinceUpdate);
                numbytes = inStream.read(buffer);
            }
        }
        finally {
            monitor.done();
        }
    }

    protected int updateProgress(IProgressMonitor monitor, int length, int retrieved, int bytesReadSinceUpdate) {
        if (length != -1) {
            monitor.subTask(NLS.bind((String)BuildResultEditorMessages.AbstractDownloadsPage_DOWNLOAD_PROGRESS_STATUS, (Object[])new Object[]{new Integer(retrieved / 1024), length}));
            int worked = bytesReadSinceUpdate / 1024;
            monitor.worked(worked);
            bytesReadSinceUpdate -= worked * 1024;
        } else {
            monitor.subTask(NLS.bind((String)BuildResultEditorMessages.AbstractDownloadsPage_DOWNLOAD_PROGRESS_STATUS_SIZE_UNKNOWN, (Object)new Integer(retrieved / 1024)));
        }
        return bytesReadSinceUpdate;
    }

    protected int getMonitorLength(int length) {
        int lengthInChunks = length <= 0 ? -1 : length / 1024;
        return lengthInChunks;
    }
}

