/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.helper;

import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.ui.helper.BuildUIHelperMessages;
import java.text.BreakIterator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Control;

public class StringFormatHelper {
    static final long TEN_KB = 10240L;
    static final long ONE_MB = 0x100000L;
    static final long TEN_MB = 0xA00000L;
    static final long ONE_GB = 0x40000000L;
    static final long TEN_GB = 0x280000000L;
    static final long ONE_TB = 0x10000000000L;
    static final long TEN_TB = 0xA0000000000L;

    public static String formatFileSize(long fileSizeInBytes) {
        String sizeStr = null;
        sizeStr = fileSizeInBytes > -1L ? (fileSizeInBytes < 1024L ? NLS.bind((String)BuildUIHelperMessages.StringFormatHelper_SIZE_IN_BYTES, (Object[])new String[]{String.format("%,d", fileSizeInBytes)}) : (fileSizeInBytes < 10240L ? NLS.bind((String)BuildUIHelperMessages.StringFormatHelper_SIZE_IN_KILOBYTES, (Object[])new String[]{String.format("%,.1f", Float.valueOf((float)fileSizeInBytes / 1024.0f))}) : (fileSizeInBytes < 0x100000L ? NLS.bind((String)BuildUIHelperMessages.StringFormatHelper_SIZE_IN_KILOBYTES, (Object[])new String[]{String.format("%,d", fileSizeInBytes / 1024L)}) : (fileSizeInBytes < 0xA00000L ? NLS.bind((String)BuildUIHelperMessages.StringFormatHelper_SIZE_IN_MEGABYTES, (Object[])new String[]{String.format("%,.1f", Float.valueOf((float)fileSizeInBytes / 1048576.0f))}) : (fileSizeInBytes < 0x40000000L ? NLS.bind((String)BuildUIHelperMessages.StringFormatHelper_SIZE_IN_MEGABYTES, (Object[])new String[]{String.format("%,d", fileSizeInBytes / 0x100000L)}) : (fileSizeInBytes < 0x280000000L ? NLS.bind((String)BuildUIHelperMessages.StringFormatHelper_SIZE_IN_GIGABYTES, (Object[])new String[]{String.format("%,.1f", Float.valueOf((float)fileSizeInBytes / 1.0737418E9f))}) : (fileSizeInBytes < 0x10000000000L ? NLS.bind((String)BuildUIHelperMessages.StringFormatHelper_SIZE_IN_GIGABYTES, (Object[])new String[]{String.format("%,d", fileSizeInBytes / 0x40000000L)}) : (fileSizeInBytes < 0xA0000000000L ? NLS.bind((String)BuildUIHelperMessages.StringFormatHelper_SIZE_IN_TERABYTES, (Object[])new String[]{String.format("%,.1f", Float.valueOf((float)fileSizeInBytes / 1.0995116E12f))}) : NLS.bind((String)BuildUIHelperMessages.StringFormatHelper_SIZE_IN_TERABYTES, (Object[])new String[]{String.format("%,d", fileSizeInBytes / 0x10000000000L)}))))))))) : BuildUIHelperMessages.StringFormatHelper_FILE_NOT_FOUND;
        return sizeStr;
    }

    public static String truncateString(String stringToTruncate, Control fontSupplier, int maxWidthInPixels) {
        ValidationHelper.validateNotNull((String)"fontSupplier", (Object)fontSupplier);
        ValidationHelper.validateNotNull((String)"stringToTruncate", (Object)stringToTruncate);
        StringBuffer buffer = new StringBuffer(stringToTruncate);
        int widthInPixels = StringFormatHelper.getWidth(stringToTruncate, fontSupplier);
        if (widthInPixels <= maxWidthInPixels) {
            return stringToTruncate;
        }
        BreakIterator wordBreakIterator = BreakIterator.getWordInstance();
        wordBreakIterator.setText(stringToTruncate);
        wordBreakIterator.last();
        while (widthInPixels > maxWidthInPixels) {
            int previousBoundary = wordBreakIterator.previous();
            if (previousBoundary == -1) {
                return "...";
            }
            buffer.delete(previousBoundary, buffer.length());
            widthInPixels = StringFormatHelper.getWidth(String.valueOf(buffer.toString()) + "...", fontSupplier);
        }
        return String.valueOf(buffer.toString()) + "...";
    }

    public static int getWidth(String string, Control fontSupplier) {
        GC gc = null;
        try {
            gc = new GC((Drawable)fontSupplier);
            int n = gc.textExtent((String)string).x;
            return n;
        }
        finally {
            if (gc != null) {
                gc.dispose();
            }
        }
    }
}

