/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.helper;

import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.dialogs.BuildUIDialogMessages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import java.util.Collections;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ItemNotFoundHelper {
    public static void handleDeletedBuildItem(IItemHandle buildItem, int severity) {
        ValidationHelper.validateNotNull((String)"buildItem", (Object)buildItem);
        ItemNotFoundHelper.handleDeletedBuildItem(buildItem, null, severity);
    }

    public static void handleDeletedBuildItem(IItemHandle buildItem, String message, int severity) {
        ValidationHelper.validateNotNull((String)"buildItem", (Object)buildItem);
        Status status = new Status(severity, BuildUIPlugin.getUniqueIdentifier(), BuildUIDialogMessages.SELECTED_BUILD_ITEM_DELETED);
        ItemNotFoundHelper.displayErrorDialog(BuildUIDialogMessages.BUILD_ITEM_DELETED_ERROR_DIALOG_TITLE, message, status);
        ItemNotFoundHelper.updateItemManager(buildItem);
    }

    public static void updateItemManager(IItemHandle buildItem) {
        ITeamRepository repository = (ITeamRepository)buildItem.getOrigin();
        if (repository != null) {
            repository.itemManager().applyItemDeletes(Collections.singletonList(buildItem));
        }
    }

    protected static void displayErrorDialog(String title, final String message, final Status status) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = new Shell();
                try {
                    ErrorDialog.openError((Shell)shell, (String)BuildUIDialogMessages.BUILD_ITEM_DELETED_ERROR_DIALOG_TITLE, (String)message, (IStatus)status);
                }
                finally {
                    shell.dispose();
                }
            }
        });
    }
}

