/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.helper;

import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.helper.BuildUIHelperMessages;
import com.ibm.team.repository.common.UUID;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class FileHelper {
    private static String URL_FILE_WHITE_LIST = "[\\w-~#\\[\\]@!()+,;=.]";
    private static FileHelper SINGLETON_FILE_HELPER = new FileHelper();
    public static final String PREFERENCE_SAVE_AS_PATH = String.valueOf(FileHelper.class.getName()) + "SaveAsFilePath";
    public static final String DEFAULT_FILE_EXTENSION = ".tmp";

    public static String createTemporaryFileName(String fileName) {
        ValidationHelper.validateNotEmpty((String)"fileName", (String)fileName);
        return SINGLETON_FILE_HELPER.doCreateTemporaryFileName(fileName);
    }

    public static String truncateQueryParameter(String urlPath) {
        if (urlPath.contains("?")) {
            urlPath = urlPath.substring(0, urlPath.indexOf("?"));
        }
        return urlPath;
    }

    public static String sanitizeURLStringToFileName(String url) {
        try {
            url = new URI(url).getPath();
        }
        catch (URISyntaxException exception) {
            exception.printStackTrace();
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < url.length()) {
            String s = String.valueOf(url.charAt(i));
            if (s.matches(URL_FILE_WHITE_LIST)) {
                sb.append(s);
            }
            ++i;
        }
        return sb.toString();
    }

    protected String doCreateTemporaryFileName(String fileName) {
        String tmpDir = System.getProperty("java.io.tmpdir");
        if (!tmpDir.endsWith(File.separator)) {
            tmpDir = String.valueOf(tmpDir) + File.separator;
        }
        String[] fileNameParts = this.doGetFileContributionFileNameParts(fileName);
        return String.valueOf(tmpDir) + fileNameParts[0] + System.currentTimeMillis() + fileNameParts[1];
    }

    protected String[] doGetFileContributionFileNameParts(String fileName) {
        String[] parts = new String[2];
        if (fileName.equals("")) {
            parts[0] = UUID.generate().getUuidValue();
            parts[1] = DEFAULT_FILE_EXTENSION;
        } else {
            int separatorIndex = fileName.indexOf(46);
            if (separatorIndex == -1) {
                parts[0] = fileName;
                parts[1] = DEFAULT_FILE_EXTENSION;
            } else {
                parts[0] = fileName.substring(0, separatorIndex);
                parts[1] = separatorIndex + 1 < fileName.length() ? fileName.substring(separatorIndex) : DEFAULT_FILE_EXTENSION;
            }
        }
        return parts;
    }

    public static String promptToSaveFile(String defaultFilename, Shell shell) {
        return SINGLETON_FILE_HELPER.doPromptToSaveFile(defaultFilename, shell);
    }

    protected String doPromptToSaveFile(String defaultFilename, Shell shell) {
        String filePath = null;
        while (filePath == null) {
            FileDialog fileDialog = new FileDialog(shell, 8192);
            fileDialog.setFileName(defaultFilename);
            String saveAsPath = BuildUIPlugin.getDefault().getPreferenceStore().getString(PREFERENCE_SAVE_AS_PATH);
            if (saveAsPath.length() > 0) {
                fileDialog.setFilterPath(saveAsPath);
            }
            fileDialog.setText(BuildUIHelperMessages.FileHelper_FILE_SAVE_AS_DIALOG_TITLE);
            String saveFileLocation = this.getFileLocation(fileDialog);
            if (saveFileLocation == null) break;
            File outputFile = new File(saveFileLocation);
            if (outputFile.exists() && !this.queryOverwriteFile(outputFile.getName(), shell)) continue;
            filePath = saveFileLocation;
            BuildUIPlugin.getDefault().getPreferenceStore().setValue(PREFERENCE_SAVE_AS_PATH, outputFile.getParent());
        }
        return filePath;
    }

    protected boolean queryOverwriteFile(String filename, Shell shell) {
        return MessageDialog.openQuestion((Shell)shell, (String)BuildUIHelperMessages.FileHelper_SAVING_FILE_DIALOG_TITLE, (String)NLS.bind((String)BuildUIHelperMessages.FileHelper_REPLACE_FILE_QUESTION, (Object)filename));
    }

    protected String getFileLocation(FileDialog fileDialog) {
        return fileDialog.open();
    }
}

