/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.helper;

import com.ibm.team.build.common.model.IBuildDefinition;

public class EnterpriseHelper {
    public static String getTemplateId(IBuildDefinition buildDefinition) {
        if (buildDefinition == null) {
            return null;
        }
        return buildDefinition.getPropertyValue("com.ibm.team.build.internal.template.id", null);
    }

    public static boolean isEnterpriseDefinition(IBuildDefinition buildDefinition) {
        return EnterpriseHelper.isEnterpriseTemplate(EnterpriseHelper.getTemplateId(buildDefinition));
    }

    public static boolean isEnterpriseTemplate(String templateId) {
        return EnterpriseHelper.isPackagingTemplate(templateId) || EnterpriseHelper.isDeploymentTemplate(templateId) || EnterpriseHelper.isPromotionTemplate(templateId);
    }

    public static boolean isPackagingTemplate(String templateId) {
        return templateId != null && templateId.startsWith("com.ibm.team.enterprise.packaging");
    }

    public static boolean isDeploymentTemplate(String templateId) {
        return templateId != null && templateId.startsWith("com.ibm.team.enterprise.deployment");
    }

    public static boolean isPromotionTemplate(String templateId) {
        return templateId != null && templateId.startsWith("com.ibm.team.enterprise.promotion");
    }

    public static boolean isNonSeqPackagingTemplate(IBuildDefinition buildDefinition) {
        return EnterpriseHelper.isNonSeqPackagingTemplate(EnterpriseHelper.getTemplateId(buildDefinition));
    }

    public static boolean isNonSeqPackagingTemplate(String templateId) {
        return templateId != null && templateId.startsWith("com.ibm.team.enterprise.packaging.nonseq");
    }

    public static boolean isNonSeqDeploymentTemplate(IBuildDefinition buildDefinition) {
        return EnterpriseHelper.isNonSeqDeploymentTemplate(EnterpriseHelper.getTemplateId(buildDefinition));
    }

    public static boolean isNonSeqDeploymentTemplate(String templateId) {
        return templateId != null && templateId.startsWith("com.ibm.team.enterprise.deployment.nonseq");
    }

    public static boolean canRequestFromBaseBuildUI(IBuildDefinition buildDefinition) {
        return !EnterpriseHelper.isNonSeqPackagingTemplate(buildDefinition) && !EnterpriseHelper.isNonSeqDeploymentTemplate(buildDefinition);
    }
}

