/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.helper;

import com.ibm.team.build.common.model.IBuildProperty;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.build.internal.common.events.BuildResultChangeEvent;
import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.common.model.dto.IBuildResultRecord;
import com.ibm.team.build.internal.ui.BuildResultHyperlinkHandler;
import com.ibm.team.build.internal.ui.BuildUIMessages;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.helper.BuildResultTextHelper;
import com.ibm.team.build.internal.ui.helper.BuildUIHelper;
import com.ibm.team.build.internal.ui.helper.BuildUIHelperMessages;
import com.ibm.team.build.internal.ui.helper.XMLBuildObjectHelper;
import com.ibm.team.build.internal.ui.query.BuildQueryRow;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Formatter;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.HTMLTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class ClipboardHelper {
    private static final String fLineSeparator = System.getProperty("line.separator");
    protected static final Transfer[] fTransfers = new Transfer[]{TextTransfer.getInstance(), HTMLTransfer.getInstance()};
    private static final ClipboardHelper fDefault = new ClipboardHelper();

    public static ClipboardHelper getDefault() {
        return fDefault;
    }

    public void copyTextToClipboard(String text, Display display) {
        ValidationHelper.validateNotNull((String)"text", (Object)text);
        ValidationHelper.validateNotNull((String)"display", (Object)display);
        this.copyToClipboard(new String[]{text}, new Transfer[]{fTransfers[0]}, display);
    }

    public void copyBuildSelectionToClipboard(IStructuredSelection selection, Display display) {
        ValidationHelper.validateNotNull((String)"selection", (Object)selection);
        ValidationHelper.validateNotNull((String)"display", (Object)display);
        String plainText = this.getCopyText(selection, false, false);
        String htmlText = this.getCopyText(selection, true, false);
        this.copyToClipboard(new String[]{plainText, htmlText}, fTransfers, display);
    }

    public void copyBuildPropertiesToClipboard(List<IBuildProperty> buildProperties, Display display) {
        ValidationHelper.validateNotNull((String)"buildProperties", buildProperties);
        ValidationHelper.validateNotNull((String)"display", (Object)display);
        try {
            this.copyTextToClipboard(this.getCopyText(buildProperties), display);
        }
        catch (TeamRepositoryException exception) {
            BuildUIPlugin.log(exception);
            BuildUIHelper.showErrorDialog(BuildUIHelperMessages.ClipboardHelper_ERROR_DATA_NOT_COPIED, BuildUIHelperMessages.ClipboardHelper_PROBLEM_COPYING_TO_CLIPBOARD, (Exception)((Object)exception));
        }
    }

    public List<IBuildProperty> getBuildPropertiesFromClipboard(Display display) {
        ValidationHelper.validateNotNull((String)"display", (Object)display);
        List<IBuildProperty> buildProperties = null;
        try {
            String clipboardText = this.getTextFromClipboard();
            if (XMLBuildObjectHelper.isSanePropertyXML(clipboardText)) {
                buildProperties = XMLBuildObjectHelper.parseBuildPropertiesFromXML(this.getTextFromClipboard());
            } else {
                BuildUIHelper.showErrorDialog(BuildUIHelperMessages.ClipboardHelper_INVALID_CLIPBOARD_CONTENTS_ERROR_MESSAGE, BuildUIHelperMessages.ClipboardHelper_ERROR_PASTING_BUILD_PROPERTY_DIALOG_TITLE, null);
            }
        }
        catch (TeamRepositoryException exception) {
            BuildUIPlugin.log(exception);
            BuildUIHelper.showErrorDialog(BuildUIHelperMessages.ClipboardHelper_ERROR_PASTING_BUILD_PROPERTY, BuildUIHelperMessages.ClipboardHelper_ERROR_PASTING_BUILD_PROPERTY_DIALOG_TITLE, null);
        }
        return buildProperties;
    }

    public void copyBuildSelectionURLToClipboard(IStructuredSelection selection, Display display) {
        ValidationHelper.validateNotNull((String)"selection", (Object)selection);
        ValidationHelper.validateNotNull((String)"display", (Object)display);
        String plainText = this.getCopyText(selection, false, true);
        String htmlText = this.getCopyText(selection, true, true);
        this.copyToClipboard(new String[]{plainText, htmlText}, fTransfers, display);
    }

    protected void copyToClipboard(String[] data, Transfer[] transfers, Display display) {
        Clipboard clipboard = null;
        try {
            try {
                clipboard = new Clipboard(display);
                this.doCopy(clipboard, data, transfers);
            }
            catch (Exception exception) {
                BuildUIPlugin.log(exception);
                BuildUIHelper.showErrorDialog(BuildUIHelperMessages.ClipboardHelper_ERROR_DATA_NOT_COPIED, BuildUIHelperMessages.ClipboardHelper_PROBLEM_COPYING_TO_CLIPBOARD, exception);
                if (clipboard != null && !clipboard.isDisposed()) {
                    clipboard.dispose();
                }
            }
        }
        finally {
            if (clipboard != null && !clipboard.isDisposed()) {
                clipboard.dispose();
            }
        }
    }

    protected void doCopy(Clipboard clipboard, String[] data, Transfer[] transfers) {
        try {
            this.setContentsOnClipboard(clipboard, data, transfers);
        }
        catch (SWTError e) {
            if (e.code != 2002) {
                throw e;
            }
            this.confirmRetry(clipboard, data, transfers);
        }
    }

    protected void setContentsOnClipboard(Clipboard clipboard, String[] data, Transfer[] transfers) {
        clipboard.setContents((Object[])data, transfers);
    }

    protected void confirmRetry(Clipboard clipboard, String[] data, Transfer[] transfers) {
        if (this.queryUserForRetry()) {
            this.doCopy(clipboard, data, transfers);
        }
    }

    protected boolean queryUserForRetry() {
        return BuildUIHelper.showQueryDialog(BuildUIHelperMessages.ClipboardHelper_PROBLEM_COPYING_TO_CLIPBOARD, BuildUIHelperMessages.ClipboardHelper_CLIPBOARD_PROBLEM_RETRY, 4);
    }

    protected String getCopyText(IStructuredSelection selection, boolean createHtmlText) {
        return this.getCopyText(selection, createHtmlText, false);
    }

    protected String getCopyText(IStructuredSelection selection, boolean createHtmlText, boolean copyURL) {
        ValidationHelper.validateNotNull((String)"selection", (Object)selection);
        StringBuilder buffer = new StringBuilder();
        for (Object object : selection) {
            String buildDefinitionId;
            String buildResultLabel;
            IBuildResult buildResult;
            ITeamRepository teamRepository;
            if (object instanceof BuildResultChangeEvent) {
                BuildResultChangeEvent event = (BuildResultChangeEvent)object;
                String buildResultLabel2 = event.getBuildLabel();
                String buildDefinitionId2 = event.getBuildDefinitionId();
                IBuildResultHandle buildResultHandle = (IBuildResultHandle)event.getChangeEvent().getItem();
                teamRepository = (ITeamRepository)event.getChangeEvent().getOrigin();
                this.appendBuildResultText(buildResultLabel2, buildDefinitionId2, buildResultHandle, teamRepository, buffer, createHtmlText, copyURL);
                continue;
            }
            if (object instanceof BuildQueryRow) {
                BuildQueryRow row = (BuildQueryRow)object;
                buildResult = row.getBuildResult();
                buildResultLabel = buildResult.getLabel();
                buildDefinitionId = row.getBuildDefinition().getId();
                teamRepository = row.getTeamRepository();
                this.appendBuildResultText(buildResultLabel, buildDefinitionId, (IBuildResultHandle)buildResult, teamRepository, buffer, createHtmlText, copyURL);
                continue;
            }
            if (!(object instanceof IBuildResultRecord)) continue;
            IBuildResultRecord record = (IBuildResultRecord)object;
            buildResult = record.getBuildResult();
            buildResultLabel = BuildResultTextHelper.getLabel(buildResult);
            buildDefinitionId = record.getBuildDefinition().getId();
            teamRepository = (ITeamRepository)buildResult.getOrigin();
            this.appendBuildResultText(buildResultLabel, buildDefinitionId, (IBuildResultHandle)buildResult, teamRepository, buffer, createHtmlText, copyURL);
        }
        return buffer.toString();
    }

    protected String getCopyText(List<IBuildProperty> buildProperties) throws TeamRepositoryException {
        if (!buildProperties.isEmpty() && ClipboardHelper.isValidCopy(buildProperties)) {
            return XMLBuildObjectHelper.getXMLFromBuildProperties(buildProperties);
        }
        return "";
    }

    public static boolean isValidCopy(List propertiesToCopy) {
        if (propertiesToCopy != null) {
            Iterator iterator = propertiesToCopy.iterator();
            while (iterator.hasNext()) {
                if (iterator.next() instanceof IBuildProperty) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected void appendBuildResultText(String buildResultLabel, String buildDefinitionId, IBuildResultHandle buildResultHandle, ITeamRepository teamRepository, StringBuilder textBuffer, boolean createHtmlLink) {
        this.appendBuildResultText(buildResultLabel, buildDefinitionId, buildResultHandle, teamRepository, textBuffer, createHtmlLink, false);
    }

    protected void appendBuildResultText(String buildResultLabel, String buildDefinitionId, IBuildResultHandle buildResultHandle, ITeamRepository teamRepository, StringBuilder textBuffer, boolean createHtmlLink, boolean copyURL) {
        ValidationHelper.validateNotNull((String)"textBuffer", (Object)textBuffer);
        if (textBuffer.length() != 0) {
            if (createHtmlLink) {
                textBuffer.append(BuildUIMessages.BUILD_RESULT_HTML_LABEL_SEPARATOR);
            } else {
                textBuffer.append(fLineSeparator);
            }
        }
        URI uri = null;
        if ((createHtmlLink || copyURL) && buildResultHandle != null) {
            uri = BuildResultHyperlinkHandler.getAbsoluteURI((IItemHandle)buildResultHandle, teamRepository);
        }
        if (buildResultLabel == null || buildResultLabel.length() == 0) {
            buildResultLabel = BuildUIMessages.BUILD_RESULT_LABEL_UNLABELED;
        }
        if (uri == null) {
            textBuffer.append(NLS.bind((String)BuildUIMessages.BUILD_RESULT_LABEL, (Object)buildDefinitionId, (Object)buildResultLabel));
        } else if (createHtmlLink) {
            Object[] args = new String[]{this.encodeForHTMLTransfer(uri.toString()), this.encodeForHTMLTransfer(buildDefinitionId), this.encodeForHTMLTransfer(buildResultLabel)};
            textBuffer.append(NLS.bind((String)BuildUIMessages.BUILD_RESULT_HTML_LABEL, (Object[])args));
        } else {
            textBuffer.append(uri.toString());
        }
    }

    public String getCopyTextForTable(Table table, boolean copyFirstColumnOnly) {
        ValidationHelper.validateNotNull((String)"focusTable", (Object)table);
        TableColumn[] columns = table.getColumns();
        TableItem[] items = table.getSelection();
        String lineSeparator = System.getProperty("line.separator");
        StringBuffer copyBuffer = new StringBuffer();
        if (items.length == 1 || columns.length == 1 || copyFirstColumnOnly) {
            int i = 0;
            while (i < items.length) {
                TableItem item = items[i];
                int j = 0;
                while (j < columns.length) {
                    copyBuffer.append(item.getText(j));
                    if (copyFirstColumnOnly) break;
                    if (j < columns.length - 1) {
                        copyBuffer.append('\t');
                    }
                    ++j;
                }
                if (i < items.length - 1) {
                    copyBuffer.append(lineSeparator);
                }
                ++i;
            }
        } else {
            String[][] data = new String[items.length][columns.length];
            int i = 0;
            while (i < items.length) {
                int j = 0;
                while (j < columns.length) {
                    data[i][j] = items[i].getText(j);
                    ++j;
                }
                ++i;
            }
            copyBuffer = this.formatColumnData(data);
        }
        return copyBuffer.toString();
    }

    public String getCopyTextForTree(Tree focusTree, boolean copyFirstColumnOnly) {
        ValidationHelper.validateNotNull((String)"focusTree", (Object)focusTree);
        TreeColumn[] columns = focusTree.getColumns();
        TreeItem[] items = focusTree.getSelection();
        String lineSeparator = System.getProperty("line.separator");
        StringBuffer copyBuffer = new StringBuffer();
        if (items.length == 1 || columns.length == 1 || copyFirstColumnOnly) {
            int i = 0;
            while (i < items.length) {
                TreeItem item = items[i];
                int j = 0;
                while (j < columns.length) {
                    copyBuffer.append(item.getText(j));
                    if (copyFirstColumnOnly) break;
                    if (j < columns.length - 1) {
                        copyBuffer.append('\t');
                    }
                    ++j;
                }
                if (i < items.length - 1) {
                    copyBuffer.append(lineSeparator);
                }
                ++i;
            }
        } else {
            String[][] data = new String[items.length][columns.length];
            int i = 0;
            while (i < items.length) {
                int j = 0;
                while (j < columns.length) {
                    data[i][j] = items[i].getText(j);
                    ++j;
                }
                ++i;
            }
            copyBuffer = this.formatColumnData(data);
        }
        return copyBuffer.toString();
    }

    protected StringBuffer formatColumnData(String[][] columnData) {
        int itemCount = columnData.length;
        int columnCount = columnData[0].length;
        int[] columnWidths = new int[columnCount];
        boolean[] columnJustifications = new boolean[columnCount];
        int i = 0;
        while (i < itemCount) {
            int j = 0;
            while (j < columnCount) {
                String columnText = columnData[i][j];
                columnWidths[j] = Math.max(columnWidths[j], columnText.length());
                if (columnText.length() > 0 && !Character.isDigit(columnText.charAt(0))) {
                    columnJustifications[j] = true;
                }
                ++j;
            }
            ++i;
        }
        String lineSeparator = System.getProperty("line.separator");
        StringBuffer text = new StringBuffer();
        Formatter formatter = new Formatter(text);
        int i2 = 0;
        while (i2 < itemCount) {
            int j = 0;
            while (j < columnCount) {
                String justify = columnJustifications[j] ? "-" : "";
                formatter.format("%" + justify + (columnWidths[j] == 0 ? "" : Integer.valueOf(columnWidths[j])) + "s", columnData[i2][j]);
                if (j < columnCount - 1) {
                    text.append('\t');
                }
                ++j;
            }
            if (i2 < itemCount - 1) {
                text.append(lineSeparator);
            }
            ++i2;
        }
        return text;
    }

    protected String encodeForHTMLTransfer(String string) {
        return string;
    }

    protected Charset getDefaultCharset() {
        return Charset.defaultCharset();
    }

    protected boolean isWindows() {
        return SWT.getPlatform().equals("win32");
    }

    private boolean clipboardContainsText(Clipboard clipboard) {
        TransferData[] data = clipboard.getAvailableTypes();
        int i = 0;
        while (i < data.length) {
            if (fTransfers[0].isSupportedType(data[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private String getTextFromClipboard() {
        Clipboard clipboard = null;
        try {
            clipboard = new Clipboard(Display.getCurrent());
            if (this.clipboardContainsText(clipboard)) {
                String string = (String)clipboard.getContents(fTransfers[0]);
                return string;
            }
            return null;
        }
        finally {
            if (clipboard != null && !clipboard.isDisposed()) {
                clipboard.dispose();
            }
        }
    }
}

