/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.helper;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.helper.BuildDefinitionHandleHelper;
import com.ibm.team.build.internal.ui.helper.BuildUIHelperMessages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.model.ItemHandle;
import java.net.URI;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class BuildUIPreferencesHelper {
    protected static final String SERIALIZATION_SEPARATOR = System.getProperty("line.separator", "\n");

    public static void storeBuildDefinitionPreferences(IBuildDefinition[] definitions, String key) {
        ValidationHelper.validateNotNull((String)"definitions", (Object[])definitions);
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < definitions.length) {
            IBuildDefinition definition = definitions[i];
            buffer.append(BuildUIPreferencesHelper.serializeBuildDefinition((IBuildDefinitionHandle)definition, definition.getId()));
            if (i < definitions.length - 1) {
                buffer.append(SERIALIZATION_SEPARATOR);
            }
            ++i;
        }
        BuildUIPlugin.getDefault().getPreferenceStore().setValue(key, buffer.toString());
        BuildUIPlugin.getDefault().savePluginPreferences();
    }

    public static void storeBuildDefinitionPreferences(BuildDefinitionHandleHelper[] helpers, String key) {
        ValidationHelper.validateNotNull((String)"helpers", (Object[])helpers);
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < helpers.length) {
            IBuildDefinitionHandle handle = helpers[i].getBuildDefinitionHandle();
            buffer.append(BuildUIPreferencesHelper.serializeBuildDefinition(handle, helpers[i].getBuildDefinitionId()));
            if (i < helpers.length - 1) {
                buffer.append(SERIALIZATION_SEPARATOR);
            }
            ++i;
        }
        BuildUIPlugin.getDefault().getPreferenceStore().setValue(key, buffer.toString());
        BuildUIPlugin.getDefault().savePluginPreferences();
    }

    protected static String serializeBuildDefinition(IBuildDefinitionHandle definition, String definitionId) {
        ITeamRepository repository = (ITeamRepository)definition.getOrigin();
        if (repository == null) {
            throw new IllegalArgumentException(NLS.bind((String)BuildUIHelperMessages.BuildUIPreferencesHelper_ORIGIN_NOT_SET, (Object)definitionId));
        }
        StringBuffer buffer = new StringBuffer(String.valueOf(definitionId) + SERIALIZATION_SEPARATOR);
        buffer.append(String.valueOf(repository.getId().getUuidValue()) + SERIALIZATION_SEPARATOR);
        Location definitionLocation = Location.itemLocation((IItemHandle)definition, (String)repository.getRepositoryURI());
        buffer.append(definitionLocation.toAbsoluteUri().toString());
        return buffer.toString();
    }

    public static List<BuildDefinitionHandleHelper> getBuildDefinitionPreferences(String key) {
        String serializedHandles = BuildUIPlugin.getDefault().getPreferenceStore().getString(key);
        if (serializedHandles.length() == 0) {
            return new LinkedList<BuildDefinitionHandleHelper>();
        }
        LinkedList<BuildDefinitionHandleHelper> helpers = new LinkedList<BuildDefinitionHandleHelper>();
        StringTokenizer tokenizer = new StringTokenizer(serializedHandles, SERIALIZATION_SEPARATOR);
        try {
            while (tokenizer.hasMoreTokens()) {
                String id = tokenizer.nextToken();
                UUID repoUUID = null;
                Location location = null;
                String nextToken = tokenizer.nextToken();
                try {
                    repoUUID = UUID.valueOf((String)nextToken);
                }
                catch (IllegalArgumentException e) {
                    location = Location.location((URI)new URI(nextToken));
                }
                if (location == null) {
                    location = Location.location((URI)new URI(tokenizer.nextToken()));
                }
                IBuildDefinitionHandle handle = (IBuildDefinitionHandle)location.getItemHandle();
                ITeamRepository repository = BuildUIPreferencesHelper.findRepository(location.getRepoUri(), repoUUID);
                if (repository != null) {
                    ((ItemHandle)handle).setOrigin((Object)repository);
                }
                helpers.add(new BuildDefinitionHandleHelper(id, handle));
            }
        }
        catch (Exception exception) {
            BuildUIPreferencesHelper.storeBuildDefinitionPreferences(new BuildDefinitionHandleHelper[0], key);
            String errorMessage = BuildUIHelperMessages.BuildUIPreferencesHelper_BUILD_DEFINITIONS_PREFERENCES_CORRUPT;
            BuildUIPlugin.log((IStatus)new Status(4, BuildUIPlugin.getUniqueIdentifier(), errorMessage, (Throwable)exception));
        }
        return helpers;
    }

    protected static ITeamRepository findRepository(String repoUri, UUID repoUUID) {
        ITeamRepository repository = null;
        if (repoUUID != null) {
            repository = TeamPlatform.getTeamRepositoryService().getTeamRepository(repoUUID);
        }
        if (repository == null && (repository = TeamPlatform.getTeamRepositoryService().getTeamRepository(repoUri, 4)) == null) {
            repoUri = repoUri.endsWith("/") ? repoUri.substring(0, repoUri.length() - 1) : String.valueOf(repoUri) + "/";
            repository = TeamPlatform.getTeamRepositoryService().getTeamRepository(repoUri, 4);
        }
        return repository;
    }
}

