/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.helper;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.TimeZone;
import com.ibm.team.build.common.model.IBuildScheduleEntry;
import com.ibm.team.build.internal.common.helper.BuildScheduleHelper;
import com.ibm.team.build.internal.common.model.impl.BuildScheduleEntryImpl;
import com.ibm.team.build.internal.ui.editors.builddefinition.BuildDefinitionEditorMessages;
import java.util.Date;
import java.util.Locale;
import org.eclipse.osgi.util.NLS;

public class BuildScheduleTextHelper {
    public static final String MONDAY = BuildDefinitionEditorMessages.BuildScheduleControl_BUILD_DAY_MONDAY;
    public static final String TUESDAY = BuildDefinitionEditorMessages.BuildScheduleControl_BUILD_DAY_TUESDAY;
    public static final String WEDNESDAY = BuildDefinitionEditorMessages.BuildScheduleControl_BUILD_DAY_WEDNESDAY;
    public static final String THURSDAY = BuildDefinitionEditorMessages.BuildScheduleControl_BUILD_DAY_THURSDAY;
    public static final String FRIDAY = BuildDefinitionEditorMessages.BuildScheduleControl_BUILD_DAY_FRIDAY;
    public static final String SATURDAY = BuildDefinitionEditorMessages.BuildScheduleControl_BUILD_DAY_SATURDAY;
    public static final String SUNDAY = BuildDefinitionEditorMessages.BuildScheduleControl_BUILD_DAY_SUNDAY;
    public static final String[] ALL_DAYS = new String[]{MONDAY, TUESDAY, WEDNESDAY, THURSDAY, FRIDAY, SATURDAY, SUNDAY};
    public static final String MON = BuildDefinitionEditorMessages.BuildScheduleControl_BUILD_DAY_MON;
    public static final String TUE = BuildDefinitionEditorMessages.BuildScheduleControl_BUILD_DAY_TUE;
    public static final String WED = BuildDefinitionEditorMessages.BuildScheduleControl_BUILD_DAY_WED;
    public static final String THU = BuildDefinitionEditorMessages.BuildScheduleControl_BUILD_DAY_THU;
    public static final String FRI = BuildDefinitionEditorMessages.BuildScheduleControl_BUILD_DAY_FRI;
    public static final String SAT = BuildDefinitionEditorMessages.BuildScheduleControl_BUILD_DAY_SAT;
    public static final String SUN = BuildDefinitionEditorMessages.BuildScheduleControl_BUILD_DAY_SUN;

    static {
        new BuildScheduleTextHelper();
    }

    private BuildScheduleTextHelper() {
    }

    public static String getScheduleEntryText(IBuildScheduleEntry entry, TimeZone defaultTimeZone) {
        TimeZone entryZone = BuildScheduleHelper.getTimeZone((IBuildScheduleEntry)entry, (TimeZone)defaultTimeZone);
        String time = BuildScheduleTextHelper.getScheduledTime(entry, entryZone);
        String days = BuildScheduleTextHelper.getScheduledDate(entry);
        if (time.equals(BuildDefinitionEditorMessages.BuildScheduleControl_BUILD_INTERVAL_INVALID)) {
            return time;
        }
        if (days.equals(BuildDefinitionEditorMessages.BuildScheduleControl_ERROR_NO_DAYS_SELECTED)) {
            return days;
        }
        String format = days.equals(BuildDefinitionEditorMessages.BuildScheduleControl_EVERY_DAY) ? BuildDefinitionEditorMessages.ScheduleConfigurationEditor_FORMAT_TIME_EVERY_DAY : BuildDefinitionEditorMessages.ScheduleConfigurationEditor_FORMAT_TIME_SPECIFIC_DAYS;
        String text = NLS.bind((String)format, (Object)time, (Object)days);
        String localTime = BuildScheduleTextHelper.getLocalTime(entry, entryZone);
        if (localTime != null) {
            text = NLS.bind((String)BuildDefinitionEditorMessages.ScheduleConfigurationEditor_FORMAT_LOCAL_TIME_SUFFIX, (Object)text, (Object)localTime);
        }
        return text;
    }

    private static String getScheduledTime(IBuildScheduleEntry entry, TimeZone entryZone) {
        int interval = entry.getBuildInterval();
        if (interval == 0) {
            return BuildScheduleTextHelper.formatTime(entry, entryZone, true);
        }
        if (interval < 1) {
            return BuildDefinitionEditorMessages.BuildScheduleControl_BUILD_INTERVAL_INVALID;
        }
        if (interval == 1) {
            return BuildDefinitionEditorMessages.BuildScheduleControl_BUILD_INTERVAL_EVERY_MINUTE;
        }
        return NLS.bind((String)BuildDefinitionEditorMessages.BuildScheduleControl_BUILD_INTERVAL_EVERY_X_MINUTES, (Object)Integer.toString(interval));
    }

    private static String getScheduledDate(IBuildScheduleEntry schedule) {
        int size = 0;
        String[] dates = new String[7];
        if (schedule.isBuildOnMonday()) {
            dates[size] = MON;
            ++size;
        }
        if (schedule.isBuildOnTuesday()) {
            dates[size] = TUE;
            ++size;
        }
        if (schedule.isBuildOnWednesday()) {
            dates[size] = WED;
            ++size;
        }
        if (schedule.isBuildOnThursday()) {
            dates[size] = THU;
            ++size;
        }
        if (schedule.isBuildOnFriday()) {
            dates[size] = FRI;
            ++size;
        }
        if (schedule.isBuildOnSaturday()) {
            dates[size] = SAT;
            ++size;
        }
        if (schedule.isBuildOnSunday()) {
            dates[size] = SUN;
            ++size;
        }
        return BuildScheduleTextHelper.getDates(dates, size);
    }

    private static String getDates(String[] dates, int size) {
        switch (size) {
            case 0: {
                return BuildDefinitionEditorMessages.BuildScheduleControl_ERROR_NO_DAYS_SELECTED;
            }
            case 1: {
                return dates[0];
            }
            case 2: {
                return NLS.bind((String)BuildDefinitionEditorMessages.BuildScheduleControl_LIST_OF_TWO_DAYS, (Object)dates[0], (Object)dates[1]);
            }
            case 3: {
                return NLS.bind((String)BuildDefinitionEditorMessages.BuildScheduleControl_LIST_OF_THREE_DAYS, (Object[])new Object[]{dates[0], dates[1], dates[2]});
            }
            case 4: {
                return NLS.bind((String)BuildDefinitionEditorMessages.BuildScheduleControl_LIST_OF_FOUR_DAYS, (Object[])new Object[]{dates[0], dates[1], dates[2], dates[3]});
            }
            case 5: {
                return NLS.bind((String)BuildDefinitionEditorMessages.BuildScheduleControl_LIST_OF_FIVE_DAYS, (Object[])new Object[]{dates[0], dates[1], dates[2], dates[3], dates[4]});
            }
            case 6: {
                return NLS.bind((String)BuildDefinitionEditorMessages.BuildScheduleControl_LIST_OF_SIX_DAYS, (Object[])new Object[]{dates[0], dates[1], dates[2], dates[3], dates[4], dates[5]});
            }
            case 7: {
                return BuildDefinitionEditorMessages.BuildScheduleControl_EVERY_DAY;
            }
        }
        throw new IllegalArgumentException();
    }

    private static String getLocalTime(IBuildScheduleEntry entry, TimeZone entryZone) {
        TimeZone localZone;
        if (entry.getBuildInterval() == 0 && !entryZone.hasSameRules(localZone = TimeZone.getDefault())) {
            IBuildScheduleEntry localEntry = ((BuildScheduleEntryImpl)entry).convertTimeZone(entryZone, localZone, new Date());
            return BuildScheduleTextHelper.formatTime(localEntry, localZone, false);
        }
        return null;
    }

    private static String formatTime(IBuildScheduleEntry entry, TimeZone timeZone, boolean includeTimeZone) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, entry.getBuildHour());
        calendar.set(12, entry.getBuildMinute());
        DateFormat format = DateFormat.getTimeInstance((int)3);
        String formattedTime = format.format(calendar.getTime());
        if (includeTimeZone) {
            String shortZoneName = BuildScheduleHelper.getShortTimeZoneName((TimeZone)timeZone, (boolean)true, (Locale)Locale.getDefault());
            formattedTime = NLS.bind((String)BuildDefinitionEditorMessages.BuildScheduleControl_TIME_AND_SHORT_ZONE, (Object)formattedTime, (Object)shortZoneName);
        }
        return formattedTime;
    }
}

