/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.feed;

import com.ibm.team.build.common.model.BuildState;
import com.ibm.team.build.common.model.BuildStatus;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.feed.Messages;
import com.ibm.team.build.ui.BuildUI;
import com.ibm.team.feed.core.model.NewsItem;
import com.ibm.team.foundation.rcp.core.notification.Notification;
import com.ibm.team.foundation.rcp.core.notification.NotificationInfo;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.osgi.util.NLS;

public class BuildNotification {
    public static final String EVENT_CATEGORY_BUILD = "com.ibm.team.build.eventcategory.Build";
    public static final String EVENT_TYPE_BUILD_FINISHED = "com.ibm.team.build.eventtype.BuildFinished";
    public static final String EVENT_TYPE_BUILD_ABANDONED = "com.ibm.team.build.eventtype.BuildAbandoned";
    private final ITeamRepository fTeamRepository;
    private final IBuildResultHandle fBuildResultHandle;
    private final BuildState fBuildState;
    private final BuildState fOldBuildState;
    private final BuildStatus fBuildStatus;
    private final String fBuildLabel;
    private final String fBuildDefinitionId;
    private final String fImageUrl;

    public BuildNotification(NewsItem newsItem) {
        try {
            this.fTeamRepository = this.getTeamRepository(newsItem);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(Messages.BuildNotification_NO_REPOSITORY, exception);
        }
        this.fBuildResultHandle = this.getBuildResultHandle(newsItem);
        this.fBuildState = this.getBuildState(newsItem);
        this.fOldBuildState = this.getOldBuildState(newsItem);
        this.fBuildStatus = this.getBuildStatus(newsItem);
        this.fBuildDefinitionId = this.getBuildDefinitionId(newsItem);
        if (this.fBuildDefinitionId == null || this.fBuildDefinitionId.length() < 1) {
            throw new IllegalArgumentException(Messages.BuildNotification_NO_BUILD_DEFINITION);
        }
        try {
            this.fImageUrl = this.getImageUrl();
        }
        catch (IOException exception) {
            throw new IllegalArgumentException(exception);
        }
        String label = this.getBuildLabel(newsItem);
        this.fBuildLabel = label != null && label.length() > 0 ? label : Messages.BuildNotification_BUILD_UNLABELED;
    }

    public void displayPopup() {
        String eventTypeId = null;
        NotificationInfo notificationInfo = null;
        if (this.fOldBuildState != null && this.fOldBuildState != this.fBuildState) {
            if (this.fBuildState == BuildState.COMPLETED) {
                eventTypeId = EVENT_TYPE_BUILD_FINISHED;
                notificationInfo = this.getNotificationInfo();
            } else if (this.fBuildState == BuildState.INCOMPLETE) {
                eventTypeId = EVENT_TYPE_BUILD_ABANDONED;
                notificationInfo = this.getNotificationInfo();
            }
        }
        if (notificationInfo != null) {
            notificationInfo.setRunnable((Runnable)new NotificationActivator(this.fBuildResultHandle, this.fTeamRepository));
            this.sendNotification(eventTypeId, notificationInfo);
        }
    }

    protected void sendNotification(String eventTypeId, NotificationInfo notificationInfo) {
        Notification.send((String)eventTypeId, (NotificationInfo)notificationInfo);
    }

    protected ITeamRepository getTeamRepository(NewsItem newsItem) throws TeamRepositoryException, URISyntaxException {
        String url = newsItem.getChannel().getUrl();
        url = url.replace("{$user}", "x");
        Location location = Location.location((URI)new URI(url));
        String repositoryUri = location.getRepoUri();
        return TeamPlatform.getTeamRepositoryService().getTeamRepository(repositoryUri);
    }

    private IBuildResultHandle getBuildResultHandle(NewsItem newsItem) {
        String uuid = newsItem.getCustomAttribute("http://www.ibm.com/jazz/0.1.0/syndication", "itemId");
        if (uuid == null) {
            throw new IllegalArgumentException(Messages.BuildNotification_NO_RESULT);
        }
        return (IBuildResultHandle)IBuildResult.ITEM_TYPE.createItemHandle(UUID.valueOf((String)uuid), null);
    }

    protected String getImageUrl() throws IOException {
        URL imageUrl = JazzResources.createImageURL((String)BuildUIPlugin.getUniqueIdentifier(), (String)"icons/obj16/build.gif");
        return JazzResources.getConformingURL((URL)imageUrl);
    }

    private BuildState getBuildState(NewsItem newsItem) {
        String state = newsItem.getCustomAttribute("http://www.ibm.com/jazz/0.1.0/syndication", "build.IBuildResult.state");
        return BuildState.valueOf((String)state);
    }

    private BuildState getOldBuildState(NewsItem newsItem) {
        String state = newsItem.getCustomAttribute("http://www.ibm.com/jazz/0.1.0/syndication", "build.IBuildResult.state.old");
        return state == null ? null : BuildState.valueOf((String)state);
    }

    private BuildStatus getBuildStatus(NewsItem newsItem) {
        String status = newsItem.getCustomAttribute("http://www.ibm.com/jazz/0.1.0/syndication", "build.IBuildResult.status");
        return BuildStatus.valueOf((String)status);
    }

    private String getBuildLabel(NewsItem newsItem) {
        return newsItem.getCustomAttribute("http://www.ibm.com/jazz/0.1.0/syndication", "build.IBuildResult.label");
    }

    private String getBuildDefinitionId(NewsItem newsItem) {
        return newsItem.getCustomAttribute("http://www.ibm.com/jazz/0.1.0/syndication", "build.IBuildResult.buildDefinitionId");
    }

    private NotificationInfo getNotificationInfo() {
        NotificationInfo notificationInfo = new NotificationInfo();
        int severity = 2;
        int priority = 3;
        String title = null;
        if (this.fBuildState == BuildState.COMPLETED) {
            title = this.getBuildFinishedTitle(this.fBuildStatus);
            severity = this.getBuildFinishedSeverity(this.fBuildStatus);
            if (this.fBuildStatus == BuildStatus.ERROR) {
                priority = 4;
            }
        } else if (this.fBuildState == BuildState.INCOMPLETE) {
            title = Messages.BuildNotification_ABANDONED;
            severity = 1;
            priority = 2;
        }
        String message = NLS.bind((String)Messages.BuildNotification_DEFINITION_LABEL, (Object)this.fBuildDefinitionId, (Object)this.fBuildLabel);
        notificationInfo.setTitle(title);
        notificationInfo.setSeverity(severity);
        notificationInfo.setPriority(priority);
        notificationInfo.setMessage(message);
        notificationInfo.setImageUrl(this.fImageUrl);
        return notificationInfo;
    }

    private String getBuildFinishedTitle(BuildStatus buildStatus) {
        if (buildStatus == BuildStatus.ERROR) {
            return Messages.BuildNotification_COMPLETE_ERRORS;
        }
        if (buildStatus == BuildStatus.WARNING) {
            return Messages.BuildNotification_COMPLETE_WARNINGS;
        }
        if (buildStatus == BuildStatus.OK) {
            return Messages.BuildNotification_COMPLETE_SUCCESS;
        }
        return Messages.BuildNotification_COMPLETE;
    }

    private int getBuildFinishedSeverity(BuildStatus buildStatus) {
        if (buildStatus == BuildStatus.ERROR) {
            return 0;
        }
        if (buildStatus == BuildStatus.WARNING) {
            return 1;
        }
        if (buildStatus == BuildStatus.OK) {
            return 2;
        }
        return 2;
    }

    private static class NotificationActivator
    implements Runnable {
        private IBuildResultHandle fBuildResultHandle;
        private ITeamRepository fTeamRepository;

        NotificationActivator(IBuildResultHandle buildResultHandle, ITeamRepository teamRepository) {
            this.fBuildResultHandle = buildResultHandle;
            this.fTeamRepository = teamRepository;
        }

        @Override
        public void run() {
            BuildUI.getDefault().open(this.fBuildResultHandle, this.fTeamRepository, null);
        }
    }
}

