/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.feed;

import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.build.internal.client.BuildRecordEventManager;
import com.ibm.team.build.internal.client.ITeamBuildRecordClient;
import com.ibm.team.build.internal.common.model.dto.IBuildDefinitionStatusRecord;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.feed.BuildNotification;
import com.ibm.team.build.internal.ui.feed.Messages;
import com.ibm.team.build.internal.ui.jobs.TeamBuildJob;
import com.ibm.team.feed.core.INewsListener;
import com.ibm.team.feed.core.NewsEvent;
import com.ibm.team.feed.core.model.NewsItem;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class BuildNewsListener
implements INewsListener {
    public void newsReceived(NewsEvent event) {
        ArrayList<NewsItem> buildNews = new ArrayList<NewsItem>();
        NewsItem[] newsItemArray = event.getAddedNews();
        int n = newsItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            NewsItem newsItem = newsItemArray[n2];
            if (this.isNewsItemFromBuildProvider(newsItem)) {
                buildNews.add(newsItem);
            }
            ++n2;
        }
        Collections.sort(buildNews, new Comparator<NewsItem>(){

            @Override
            public int compare(NewsItem newsItem1, NewsItem newsItem2) {
                return newsItem1.getPublishDate().compareTo(newsItem2.getPublishDate());
            }
        });
        this.processBuildNews(buildNews);
    }

    private void processBuildNews(List<NewsItem> sortedBuildNews) {
        HashMap<String, NewsItem> resultUuidToNewsItem = new HashMap<String, NewsItem>();
        HashMap<String, NewsItem> definitionIdToNewsItem = new HashMap<String, NewsItem>();
        for (NewsItem newsItem : sortedBuildNews) {
            String definitionid;
            String resultUuid = newsItem.getCustomAttribute("http://www.ibm.com/jazz/0.1.0/syndication", "itemId");
            if (resultUuid != null) {
                resultUuidToNewsItem.put(resultUuid, newsItem);
            }
            if ((definitionid = newsItem.getCustomAttribute("http://www.ibm.com/jazz/0.1.0/syndication", "build.IBuildResult.buildDefinitionId")) == null) continue;
            definitionIdToNewsItem.put(definitionid, newsItem);
        }
        if (!resultUuidToNewsItem.isEmpty()) {
            this.displayPopups(resultUuidToNewsItem.values());
            this.fetchBuildResultRecords(resultUuidToNewsItem);
        }
        if (!definitionIdToNewsItem.isEmpty()) {
            this.fetchBuildDefinitionStatusRecords(definitionIdToNewsItem);
        }
    }

    protected void displayPopups(Collection<NewsItem> newsItems) {
        for (NewsItem newsItem : newsItems) {
            try {
                BuildNotification notification = this.getBuildNotification(newsItem);
                notification.displayPopup();
            }
            catch (NullPointerException exception) {
                this.handleException(newsItem, exception);
            }
            catch (IllegalArgumentException exception) {
                this.handleException(newsItem, exception);
            }
        }
    }

    private void handleException(NewsItem newsItem, Exception exception) {
        String newline = System.getProperty("line.separator");
        StringBuffer buffer = new StringBuffer();
        buffer.append(Messages.BuildNewsListener_INVALID_NEWS);
        buffer.append(newline);
        buffer.append(newsItem.getChannel() != null ? newsItem.getChannel().getUrl() : Messages.BuildNewsListener_NULL_CHANNEL);
        buffer.append(newline);
        buffer.append(newsItem.getCategory());
        buffer.append(newline);
        Set entrySet = newsItem.getCustomFields().entrySet();
        for (Map.Entry entry : entrySet) {
            buffer.append(entry.getKey() + " = " + entry.getValue());
            buffer.append(newline);
        }
        buffer.append(newline);
        Status status = new Status(4, BuildUIPlugin.getUniqueIdentifier(), buffer.toString(), (Throwable)exception);
        BuildUIPlugin.log((IStatus)status);
    }

    private void fetchBuildResultRecords(final Map<String, NewsItem> resultUuidToNewsItem) {
        String jobName = Messages.BuildNewsListener_JOB_LABEL_FETCHING_RESULT_RECORDS;
        TeamBuildJob job = new TeamBuildJob(jobName, false){

            protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                NewsItem newsItem = (NewsItem)resultUuidToNewsItem.values().iterator().next();
                ITeamRepository teamRepository = BuildNewsListener.this.getTeamRepository(newsItem);
                LinkedList<IBuildResultHandle> handles = new LinkedList<IBuildResultHandle>();
                for (String resultUuid : resultUuidToNewsItem.keySet()) {
                    handles.add((IBuildResultHandle)IBuildResult.ITEM_TYPE.createItemHandle(UUID.valueOf((String)resultUuid), null));
                }
                if (BuildNewsListener.this.anyoneInterestedInBuildResults(teamRepository)) {
                    BuildNewsListener.this.fetchBuildResultRecords(teamRepository, handles, monitor);
                }
                return Status.OK_STATUS;
            }

            @Override
            protected void jobFinished(IStatus status) {
                BuildNewsListener.this.handleResultJobDone(status);
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    protected void handleResultJobDone(IStatus status) {
    }

    private boolean anyoneInterestedInBuildResults(ITeamRepository teamRepository) {
        return BuildRecordEventManager.getInstance().getBuildResultListenerCount() > 0 || teamRepository.itemManager().getKnownSharedItems(IBuildResult.ITEM_TYPE).size() > 0;
    }

    protected void fetchBuildResultRecords(ITeamRepository teamRepository, List<IBuildResultHandle> resultHandlesList, IProgressMonitor monitor) throws TeamRepositoryException {
        ITeamBuildRecordClient buildClient = (ITeamBuildRecordClient)teamRepository.getClientLibrary(ITeamBuildRecordClient.class);
        while (!resultHandlesList.isEmpty()) {
            IBuildResultHandle[] resultHandles = this.getPageOfHandles(resultHandlesList);
            buildClient.getBuildResultRecords(resultHandles, IBuildResult.PROPERTIES_COMPLETE, monitor);
        }
    }

    private IBuildResultHandle[] getPageOfHandles(List<IBuildResultHandle> resultHandlesList) {
        LinkedList<IBuildResultHandle> page = new LinkedList<IBuildResultHandle>();
        Iterator<IBuildResultHandle> iter = resultHandlesList.iterator();
        while (iter.hasNext() && page.size() < 512) {
            IBuildResultHandle resultHandle = iter.next();
            page.add(resultHandle);
            iter.remove();
        }
        return page.toArray(new IBuildResultHandle[page.size()]);
    }

    private void fetchBuildDefinitionStatusRecords(final Map<String, NewsItem> definitionIdToNewsItem) {
        if (BuildRecordEventManager.getInstance().getBuildDefinitionListenerCount() > 0) {
            String jobName = Messages.BuildNewsListener_JOB_LABEL_FETCHING_DEFINITION_RECORDS;
            TeamBuildJob job = new TeamBuildJob(jobName, false){

                protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                    NewsItem newsItem = (NewsItem)definitionIdToNewsItem.values().iterator().next();
                    ITeamRepository teamRepository = BuildNewsListener.this.getTeamRepository(newsItem);
                    String[] buildDefinitionIds = definitionIdToNewsItem.keySet().toArray(new String[definitionIdToNewsItem.keySet().size()]);
                    BuildNewsListener.this.fetchBuildDefinitionStatusRecords(teamRepository, buildDefinitionIds, monitor);
                    return Status.OK_STATUS;
                }

                @Override
                protected void jobFinished(IStatus status) {
                    BuildNewsListener.this.handleDefinitionJobDone(status);
                }
            };
            job.setSystem(true);
            job.schedule();
        }
    }

    protected void handleDefinitionJobDone(IStatus status) {
    }

    protected IBuildDefinitionStatusRecord[] fetchBuildDefinitionStatusRecords(ITeamRepository teamRepository, String[] definitionIds, IProgressMonitor monitor) throws TeamRepositoryException {
        ITeamBuildRecordClient buildClient = (ITeamBuildRecordClient)teamRepository.getClientLibrary(ITeamBuildRecordClient.class);
        return buildClient.getBuildDefinitionStatusRecords(definitionIds, monitor);
    }

    protected BuildNotification getBuildNotification(NewsItem newsItem) {
        return new BuildNotification(newsItem);
    }

    private boolean isNewsItemFromBuildProvider(NewsItem newsItem) {
        String buildProvider;
        String url = newsItem.getChannel().getUrl();
        if (url.contains(buildProvider = "provider=build")) {
            return "com.ibm.team.build.category.BuildResultChanged".equals(newsItem.getCategory());
        }
        return false;
    }

    public void newsRemoved(NewsEvent event) {
    }

    public void newsStateChanged(NewsEvent event) {
    }

    protected ITeamRepository getTeamRepository(NewsItem newsItem) throws TeamRepositoryException, URISyntaxException {
        String url = newsItem.getChannel().getUrl();
        url = url.replace("{$user}", "x");
        Location location = Location.location((URI)new URI(url));
        String repositoryUri = location.getRepoUri();
        return TeamPlatform.getTeamRepositoryService().getTeamRepository(repositoryUri);
    }
}

