/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.editors.result.workitem;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.build.internal.client.workitem.WorkItemHelper;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.editors.BuildItemEditorJob;
import com.ibm.team.build.internal.ui.editors.result.BuildResultEditor;
import com.ibm.team.build.internal.ui.editors.result.summary.AbstractSummarySectionContent;
import com.ibm.team.build.internal.ui.editors.result.workitem.Messages;
import com.ibm.team.build.internal.ui.editors.result.workitem.WorkItemAssociateHyperlinkListener;
import com.ibm.team.build.internal.ui.editors.result.workitem.WorkItemCreationHyperlinkListener;
import com.ibm.team.build.internal.ui.editors.result.workitem.WorkItemHyperlinkListener;
import com.ibm.team.build.internal.ui.editors.result.workitem.WorkItemOpenHyperlinkListener;
import com.ibm.team.build.internal.ui.editors.result.workitem.WorkItemViewHyperlinkListener;
import com.ibm.team.build.internal.ui.jobs.TeamBuildJob;
import com.ibm.team.build.internal.ui.tooltips.support.WorkItemQueryTooltipSupport;
import com.ibm.team.links.client.ILinkEvent;
import com.ibm.team.links.client.ILinkManager;
import com.ibm.team.links.common.IItemReference;
import com.ibm.team.links.common.ILink;
import com.ibm.team.links.common.IReference;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IListener;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.expression.AttributeExpression;
import com.ibm.team.workitem.common.expression.Expression;
import com.ibm.team.workitem.common.expression.Term;
import com.ibm.team.workitem.common.model.AttributeOperation;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.rcp.core.queries.Query;
import com.ibm.team.workitem.rcp.ui.ImagePool;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.Section;

public class WorkItemSection
extends AbstractSummarySectionContent
implements IListener {
    private Section fSection;
    private ImageHyperlink fReportedWorkItemsHyperlink;
    private ImageHyperlink fOpenWorkItemsHyperlink;
    private ImageHyperlink fAssociateHyperlink;
    private ImageHyperlink fCreateHyperlink;
    private IProcessArea fProcessArea;
    private List<IWorkItem> fReportedWorkItems;
    private List<IWorkItem> fOpenWorkItems;
    private Query fReportedWorkItemsQuery;
    private Query fOpenWorkItemsQuery;
    private WorkItemQueryTooltipSupport fReportedWorkItemsTooltipSupport;
    private WorkItemQueryTooltipSupport fOpenWorkItemsTooltipSupport;
    private Job fFetchWorkItemsJob;
    private BuildResultEditor fEditor;

    public WorkItemSection(BuildResultEditor editor) {
        this.fEditor = editor;
    }

    @Override
    public void createContents(Section section) {
        this.fSection = section;
        this.fSection.setLayout((Layout)new GridLayout(1, false));
        section.setText(Messages.SECTION_HEADER);
        section.setDescription(Messages.SECTION_DESCRIPTION);
        this.refresh();
        ILinkManager linkManager = (ILinkManager)this.getTeamRepository().getClientLibrary(ILinkManager.class);
        linkManager.addGenericListener((Object)"com.ibm.team.links.LinkSaveEvent", (IListener)this);
    }

    @Override
    public void dispose() {
        ILinkManager linkManager = (ILinkManager)this.getTeamRepository().getClientLibrary(ILinkManager.class);
        linkManager.removeGenericListener((Object)"com.ibm.team.links.LinkSaveEvent", (IListener)this);
        if (this.fFetchWorkItemsJob != null) {
            this.fFetchWorkItemsJob.cancel();
        }
    }

    public void refresh() {
        Control client = this.fSection.getClient();
        if (client != null && !client.isDisposed()) {
            client.dispose();
        }
        Composite composite = this.getFormToolkit().createComposite((Composite)this.fSection);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setLayoutData((Object)new GridData(1808));
        this.fSection.setClient((Control)composite);
        this.fetchData(this.getFormToolkit(), composite);
    }

    private void createWidgets(FormToolkit toolkit, Composite composite) {
        WorkItemHyperlinkListener listener;
        if (this.fReportedWorkItems.size() > 0) {
            this.fReportedWorkItemsHyperlink = toolkit.createImageHyperlink(composite, 0);
            this.fReportedWorkItemsHyperlink.setLayoutData((Object)new GridData(32, 4, false, true));
            this.fReportedWorkItemsHyperlink.setText(NLS.bind((String)Messages.WorkItemSection_REPORTED_WORK_ITEMS, (Object)this.fReportedWorkItems.size()));
            this.fReportedWorkItemsHyperlink.setImage(BuildUIPlugin.getImage("icons/obj16/wi_bug.gif"));
            listener = null;
            listener = this.fReportedWorkItems.size() == 1 ? new WorkItemOpenHyperlinkListener((IWorkItemHandle)this.fReportedWorkItems.get(0), this.getEditorSite().getPage(), this.getStatusLineManager()) : new WorkItemViewHyperlinkListener(this.fReportedWorkItemsQuery, this.getStatusLineManager());
            this.fReportedWorkItemsHyperlink.addHyperlinkListener((IHyperlinkListener)listener);
            this.fReportedWorkItemsTooltipSupport = new WorkItemQueryTooltipSupport((Hyperlink)this.fReportedWorkItemsHyperlink, this.fReportedWorkItemsQuery);
        } else {
            Composite group = toolkit.createComposite(composite);
            GridLayout gridLayout = new GridLayout(2, false);
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            group.setLayout((Layout)gridLayout);
            group.setLayoutData((Object)new GridData(768));
            Label label = toolkit.createLabel(group, "");
            label.setImage(BuildUIPlugin.getImage("icons/obj16/wi_bug.gif"));
            Text text = new Text(group, 8);
            text.setText(Messages.WorkItemSection_NONE_REPORTED);
            text.setLayoutData((Object)new GridData(768));
        }
        if (this.fOpenWorkItems.size() > 0) {
            this.fOpenWorkItemsHyperlink = toolkit.createImageHyperlink(composite, 0);
            this.fOpenWorkItemsHyperlink.setLayoutData((Object)new GridData(32, 4, false, true));
            this.fOpenWorkItemsHyperlink.setText(NLS.bind((String)Messages.WorkItemSection_OPEN_WORK_ITEMS, (Object)this.fOpenWorkItems.size(), (Object)this.getBuildResultRecord().getBuildDefinition().getId()));
            this.fOpenWorkItemsHyperlink.setImage(BuildUIPlugin.getImage("icons/obj16/wi_bug.gif"));
            listener = null;
            listener = this.fOpenWorkItems.size() == 1 ? new WorkItemOpenHyperlinkListener((IWorkItemHandle)this.fOpenWorkItems.get(0), this.getEditorSite().getPage(), this.getStatusLineManager()) : new WorkItemViewHyperlinkListener(this.fOpenWorkItemsQuery, this.getStatusLineManager());
            this.fOpenWorkItemsHyperlink.addHyperlinkListener((IHyperlinkListener)listener);
            this.fOpenWorkItemsTooltipSupport = new WorkItemQueryTooltipSupport((Hyperlink)this.fOpenWorkItemsHyperlink, this.fOpenWorkItemsQuery);
        }
        if (this.fProcessArea != null) {
            listener = new WorkItemCreationHyperlinkListener(this.getTeamRepository(), this.getStatusLineManager(), this.getBuildResult(), this.fProcessArea.getProjectArea());
            this.fCreateHyperlink = toolkit.createImageHyperlink(composite, 0);
            this.fCreateHyperlink.setLayoutData((Object)new GridData(32, 4, false, true));
            this.fCreateHyperlink.setText(Messages.CREATE_WORK_ITEM);
            this.fCreateHyperlink.setImage(BuildUIPlugin.getImage(ImagePool.WORKITEM_CREATE));
            this.fCreateHyperlink.addHyperlinkListener((IHyperlinkListener)listener);
        }
        this.fAssociateHyperlink = toolkit.createImageHyperlink(composite, 0);
        this.fAssociateHyperlink.setLayoutData((Object)new GridData(32, 4, false, true));
        this.fAssociateHyperlink.setText(Messages.ASSOCIATE_WORK_ITEM);
        this.fAssociateHyperlink.setImage(BuildUIPlugin.getImage("icons/obj16/attach_obj.gif"));
        this.fAssociateHyperlink.addHyperlinkListener((IHyperlinkListener)new WorkItemAssociateHyperlinkListener(this.getTeamRepository(), this.getStatusLineManager(), this.getBuildResult()));
    }

    protected SubStatusLineManager getStatusLineManager() {
        return (SubStatusLineManager)this.getEditorSite().getActionBars().getStatusLineManager();
    }

    protected void handleFetchDataComplete(IStatus status, boolean isExpectedError, FormToolkit toolkit, Composite composite, Label pendingLabel) {
        if (status.getSeverity() == 4) {
            if (pendingLabel != null && !pendingLabel.isDisposed()) {
                if (isExpectedError) {
                    pendingLabel.setText(NLS.bind((String)Messages.FETCH_ERROR, (Object)status.getMessage()));
                } else {
                    pendingLabel.setText(Messages.FETCH_ERROR_SEE_LOG);
                }
                pendingLabel.pack(true);
            }
        } else if (status.getSeverity() == 8) {
            if (pendingLabel != null && !pendingLabel.isDisposed()) {
                pendingLabel.setText(Messages.OPERATION_CANCELED);
                pendingLabel.pack(true);
            }
        } else if (composite != null && !composite.isDisposed()) {
            if (pendingLabel != null && !pendingLabel.isDisposed()) {
                pendingLabel.dispose();
            }
            this.createWidgets(toolkit, composite);
            composite.pack(true);
            this.fSection.pack(true);
            this.fSection.getParent().pack(true);
            this.getManagedForm().reflow(true);
        }
    }

    private void fetchData(FormToolkit toolkit, Composite composite) {
        Label pendingLabel = toolkit.createLabel(composite, Messages.PENDING);
        this.fSection.layout(true);
        this.fFetchWorkItemsJob = this.getFetchDataJob(toolkit, composite, pendingLabel);
        this.fFetchWorkItemsJob.schedule();
    }

    protected TeamBuildJob getFetchDataJob(final FormToolkit toolkit, final Composite composite, final Label pendingLabel) {
        BuildItemEditorJob job = new BuildItemEditorJob(Messages.FETCHING_WORK_ITEMS, false, this.fEditor){

            @Override
            protected void internalRunProtected(IProgressMonitor monitor) throws Exception {
                WorkItemSection.this.doFetchData(toolkit, composite, pendingLabel, monitor);
            }

            @Override
            protected void internalJobFinished(final IStatus status) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        WorkItemSection.this.handleFetchDataComplete(status, this.isExpectedStatus(status), toolkit, composite, pendingLabel);
                    }
                });
            }
        };
        return job;
    }

    protected void doFetchData(FormToolkit toolkit, Composite composite, Label pendingLabel, IProgressMonitor monitor) throws Exception {
        this.fReportedWorkItems = this.getReportedWorkItems(monitor);
        this.fOpenWorkItems = this.getUnresolvedWorkItems(monitor);
        this.fReportedWorkItemsQuery = this.getWorkItemQuery(this.fReportedWorkItems, NLS.bind((String)Messages.WorkItemSection_QUERY_NAME_REPORTED, (Object)this.getBuildResult().getLabel()), monitor);
        this.fOpenWorkItemsQuery = this.getWorkItemQuery(this.fOpenWorkItems, NLS.bind((String)Messages.WorkItemSection_QUERY_NAME_OPEN_WORK_ITEMS, (Object)this.getBuildResultRecord().getBuildDefinition().getId()), monitor);
        this.fProcessArea = this.getProcessArea(monitor);
    }

    private Query getWorkItemQuery(List<IWorkItem> workItems, String queryName, IProgressMonitor monitor) throws TeamRepositoryException {
        ITeamRepository repository = (ITeamRepository)this.getBuildResult().getOrigin();
        IWorkItemClient workItemClient = (IWorkItemClient)repository.getClientLibrary(IWorkItemClient.class);
        IAuditableClient auditableClient = (IAuditableClient)repository.getClientLibrary(IAuditableClient.class);
        ArrayList<AttributeExpression> expressions = new ArrayList<AttributeExpression>(workItems.size());
        for (IWorkItem workItem : workItems) {
            IAttribute idAttribute = workItemClient.findAttribute(workItem.getProjectArea(), IWorkItem.ID_PROPERTY, monitor);
            AttributeExpression expression = new AttributeExpression((IAuditableCommon)auditableClient, idAttribute, AttributeOperation.EQUALS, (Object)new Integer(workItem.getId()));
            expressions.add(expression);
        }
        Term expression = new Term(1, expressions.toArray(new Expression[expressions.size()]));
        return new Query(repository, queryName, (Expression)expression);
    }

    protected List<IWorkItem> getReportedWorkItems(IProgressMonitor monitor) throws TeamRepositoryException {
        IWorkItemHandle[] handles = WorkItemHelper.getReportedWorkItems((ITeamRepository)this.getTeamRepository(), (IBuildResultHandle)this.getBuildResult(), (IProgressMonitor)monitor);
        return this.getTeamRepository().itemManager().fetchPartialItemsPermissionAware(Arrays.asList(handles), 0, IWorkItem.SMALL_PROFILE.getProperties(), monitor).getRetrievedItems();
    }

    protected List<IWorkItem> getUnresolvedWorkItems(IProgressMonitor monitor) throws TeamRepositoryException {
        IWorkItemHandle[] handles = WorkItemHelper.getUnresolvedWorkItems((ITeamRepository)this.getTeamRepository(), (IBuildDefinitionHandle)this.getBuildResultRecord().getBuildDefinition(), (IProgressMonitor)monitor);
        return this.getTeamRepository().itemManager().fetchPartialItemsPermissionAware(Arrays.asList(handles), 0, IWorkItem.SMALL_PROFILE.getProperties(), monitor).getRetrievedItems();
    }

    private IProcessArea getProcessArea(IProgressMonitor monitor) throws IllegalArgumentException, TeamRepositoryException {
        IProcessAreaHandle processAreaHandle;
        IBuildDefinition buildDefinition = this.getBuildResultRecord().getBuildDefinition();
        if (buildDefinition != null && (processAreaHandle = buildDefinition.getProcessArea()) != null) {
            return (IProcessArea)this.getTeamRepository().itemManager().fetchCompleteItem((IItemHandle)processAreaHandle, 1, monitor);
        }
        return null;
    }

    protected ImageHyperlink getAssociateHyperlink() {
        return this.fAssociateHyperlink;
    }

    protected ImageHyperlink getReportedWorkItemsHyperlink() {
        return this.fReportedWorkItemsHyperlink;
    }

    protected ImageHyperlink getOpenWorkItemsHyperlink() {
        return this.fOpenWorkItemsHyperlink;
    }

    protected ImageHyperlink getCreateHyperlink() {
        return this.fCreateHyperlink;
    }

    public void handleEvents(List events) {
        for (Object object : events) {
            IItemReference itemReference;
            IItemHandle itemHandle;
            IReference reference;
            ILinkEvent linkEvent;
            ILink link;
            if (!(object instanceof ILinkEvent) || !(link = (linkEvent = (ILinkEvent)object).getLink()).getLinkTypeId().equals("com.ibm.team.build.linktype.reportedWorkItems") || !(reference = link.getSourceRef()).isItemReference() || !(itemHandle = (itemReference = (IItemReference)reference).getReferencedItem()).getItemId().equals((Object)this.getBuildResult().getItemId())) continue;
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    WorkItemSection.this.refresh();
                }
            });
            return;
        }
    }

    protected WorkItemQueryTooltipSupport getReportedWorkItemsTooltipSupport() {
        return this.fReportedWorkItemsTooltipSupport;
    }

    protected WorkItemQueryTooltipSupport getOpenWorkItemsTooltipSupport() {
        return this.fOpenWorkItemsTooltipSupport;
    }
}

