/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.editors.result.workitem;

import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.build.internal.client.workitem.WorkItemHelper;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.editors.result.workitem.Messages;
import com.ibm.team.build.internal.ui.editors.result.workitem.WorkItemHyperlinkListener;
import com.ibm.team.build.internal.ui.jobs.TeamBuildJob;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.rcp.ui.workitempicker.WorkItemSelectionDialog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkEvent;

public class WorkItemAssociateHyperlinkListener
extends WorkItemHyperlinkListener {
    private ITeamRepository fTeamRepository;
    private IBuildResult fBuildResult;

    public WorkItemAssociateHyperlinkListener(ITeamRepository teamRepository, SubStatusLineManager statusLineManager, IBuildResult buildResult) {
        super(statusLineManager);
        this.fTeamRepository = teamRepository;
        this.fBuildResult = buildResult;
    }

    public void linkActivated(HyperlinkEvent e) {
        IWorkItemClient workItemClient = (IWorkItemClient)this.fTeamRepository.getClientLibrary(IWorkItemClient.class);
        if (workItemClient == null) {
            BuildUIPlugin.log(Messages.WORK_ITEM_CLIENT_LIB_MISSING);
            return;
        }
        final IWorkItemHandle workItemHandle = this.getWorkItem();
        if (workItemHandle == null) {
            return;
        }
        String jobName = Messages.ASSOCIATING_WORK_ITEM_PROGRESS;
        TeamBuildJob job = new TeamBuildJob(jobName, true, this.fTeamRepository){

            protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                WorkItemAssociateHyperlinkListener.this.associateWorkItem(workItemHandle, monitor);
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    protected IWorkItemHandle getWorkItem() {
        return WorkItemSelectionDialog.getWorkItem((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (ITeamRepository)this.fTeamRepository);
    }

    @Override
    protected String getStatusLineText() {
        return Messages.ASSOCIATING_WORK_ITEM_STATUS;
    }

    protected void associateWorkItem(IWorkItemHandle workItemHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        WorkItemHelper.linkReportedWorkItem((ITeamRepository)this.fTeamRepository, (IBuildResultHandle)this.fBuildResult, (IWorkItemHandle)workItemHandle, (IProgressMonitor)monitor);
    }

    protected void asyncExec(Runnable runnable) {
        Display.getDefault().asyncExec(runnable);
    }

    protected void runJob(Job job) {
        job.schedule();
    }
}

