/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.editors.result.summary;

import com.ibm.team.build.common.model.BuildState;
import com.ibm.team.build.common.model.BuildStatus;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.build.internal.common.helper.BuildActivityHelper;
import com.ibm.team.build.internal.common.model.dto.IBuildResultRecord;
import com.ibm.team.build.internal.common.model.dto.IBuildResultStatusRecord;
import com.ibm.team.build.internal.common.model.dto.IBuildResultStatusTrend;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.PersonalBuildTransparentCompositeImageDescriptor;
import com.ibm.team.build.internal.ui.editors.result.BuildResultEditorMessages;
import com.ibm.team.build.internal.ui.helper.BuildResultTimeHelper;
import com.ibm.team.build.internal.ui.helper.BuildUIHelper;
import com.ibm.team.build.ui.BuildUI;
import com.ibm.team.jface.ColorUtils;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.jface.tooltip.TooltipSupport;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributor;
import java.util.Collection;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class BuildStatusSection {
    private LocalResourceManager fResourceManager;
    protected IBuildResultRecord fBuildResultRecord;
    protected IBuildResultStatusTrend[] fBuildResultStatusTrends;
    protected IWorkbenchPage fWorkbenchPage;
    private Color fSectionForeground;
    private Color fSectionBackground;
    private int fBuildStatusTrendType;
    private Composite fSectionContent;
    private Composite fStatusTrendComposite;
    private FormToolkit fFormToolkit;

    public BuildStatusSection(IBuildResultRecord record, IBuildResultStatusTrend[] trends, IWorkbenchPage workbenchPage, int trendType) {
        this.fBuildResultRecord = record;
        this.fBuildResultStatusTrends = trends;
        this.fWorkbenchPage = workbenchPage;
        this.fBuildStatusTrendType = trendType;
    }

    public Composite createContent(Composite parent, FormToolkit formToolkit) {
        this.fResourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)parent);
        final Composite content = formToolkit.createComposite(parent);
        content.setLayoutData((Object)new GridData(768));
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.verticalSpacing = 0;
        content.setLayout((Layout)gridLayout);
        this.fSectionBackground = this.getBackgroundColor(this.getBuildResult());
        final Color sectionBorder = this.getBorderColor(this.getBuildResult());
        content.setBackground(this.fSectionBackground);
        Composite headerComposite = formToolkit.createComposite(content);
        headerComposite.setLayoutData((Object)new GridData(768));
        gridLayout = new GridLayout(3, false);
        headerComposite.setLayout((Layout)gridLayout);
        headerComposite.setBackground(this.fSectionBackground);
        Image image = this.getStatusImage(this.getBuildResult());
        Label label = new Label(headerComposite, 0);
        label.setBackground(this.fSectionBackground);
        label.setImage(image);
        this.fSectionForeground = this.getStatusHeaderForeground(this.getBuildResult());
        Text headerLabel = BuildUIHelper.createNonEditableText(formToolkit, headerComposite, this.getStatusHeaderText(this.getBuildResult()), 4);
        headerLabel.setForeground(this.fSectionForeground);
        headerLabel.setBackground(this.fSectionBackground);
        headerLabel.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont"));
        if (this.getBuildResult().getState() == BuildState.IN_PROGRESS) {
            String progressPercentString = BuildResultTimeHelper.getProgressPercentString(this.getBuildResult(), this.fBuildResultRecord);
            if (!progressPercentString.equals("")) {
                this.createTitleLabel(headerComposite, formToolkit, progressPercentString);
            } else {
                GridData layoutData = new GridData();
                layoutData.horizontalSpan = 2;
                headerLabel.setLayoutData((Object)layoutData);
            }
        } else {
            GridData layoutData = new GridData();
            layoutData.horizontalSpan = 2;
            headerLabel.setLayoutData((Object)layoutData);
        }
        Composite infoComposite = formToolkit.createComposite(content);
        infoComposite.setLayoutData((Object)new GridData(768));
        infoComposite.setLayout((Layout)new GridLayout(2, false));
        infoComposite.setBackground(this.fSectionBackground);
        if (this.getBuildResult().getState() == BuildState.IN_PROGRESS) {
            Text text;
            String estimatedCompletion;
            String currentActivity = BuildActivityHelper.getCurrentActivityText((Collection)this.fBuildResultRecord.getCurrentBuildActivities());
            if (currentActivity != null && !currentActivity.equals("")) {
                this.createTitleLabel(infoComposite, formToolkit, BuildResultEditorMessages.StatusSection_ACTIVITY_MESSAGE);
                Text text2 = BuildUIHelper.createNonEditableText(formToolkit, infoComposite, currentActivity, 64);
                text2.setBackground(this.fSectionBackground);
                GridDataFactory.fillDefaults().hint(150, -1).grab(true, false).applyTo((Control)text2);
            }
            if (!(estimatedCompletion = BuildResultTimeHelper.getEstimatedCompletionTimeString(this.getBuildResult(), this.fBuildResultRecord)).equals("")) {
                this.createTitleLabel(infoComposite, formToolkit, BuildResultEditorMessages.StatusSection_ESTIMATED_COMPLETION);
                text = BuildUIHelper.createNonEditableText(formToolkit, infoComposite, estimatedCompletion, 4);
                text.setBackground(this.fSectionBackground);
            }
            this.createTitleLabel(infoComposite, formToolkit, BuildResultEditorMessages.StatusSection_LAST_UPDATE);
            text = BuildUIHelper.createNonEditableText(formToolkit, infoComposite, BuildResultTimeHelper.getLastUpdateTimeString(this.fBuildResultRecord), 0);
            text.setBackground(this.fSectionBackground);
        }
        this.createTitleLabel(infoComposite, formToolkit, BuildResultEditorMessages.StatusSection_DURATION);
        Text text = BuildUIHelper.createNonEditableText(formToolkit, infoComposite, BuildResultTimeHelper.getDurationString(this.getBuildResult()), 4);
        text.setBackground(this.fSectionBackground);
        this.createTitleLabel(infoComposite, formToolkit, BuildResultEditorMessages.StatusSection_STARTED_AT);
        text = BuildUIHelper.createNonEditableText(formToolkit, infoComposite, BuildResultTimeHelper.getStartTimeString(this.getBuildResult()), 4);
        text.setBackground(this.fSectionBackground);
        if (this.getBuildResult().getState() != BuildState.IN_PROGRESS) {
            if (this.getBuildResult().getState() == BuildState.INCOMPLETE) {
                String abandonerName = BuildResultEditorMessages.StatusSection_UNKNOWN_ABANDONER;
                IContributor abandoner = this.fBuildResultRecord.getAbandoner();
                if (abandoner != null) {
                    abandonerName = abandoner.getName();
                }
                this.createTitleLabel(infoComposite, formToolkit, BuildResultEditorMessages.StatusSection_ABANDONED_BY);
                text = BuildUIHelper.createNonEditableText(formToolkit, infoComposite, NLS.bind((String)BuildResultEditorMessages.StatusSection_ABANDONED_AT, (Object)abandonerName, (Object)BuildResultTimeHelper.getCompletedTime(this.getBuildResult())), 4);
                text.setBackground(this.fSectionBackground);
            } else {
                this.createTitleLabel(infoComposite, formToolkit, BuildResultEditorMessages.StatusSection_COMPLETED_AT);
                text = BuildUIHelper.createNonEditableText(formToolkit, infoComposite, BuildResultTimeHelper.getCompletedTime(this.getBuildResult()), 4);
                text.setBackground(this.fSectionBackground);
            }
        }
        this.fStatusTrendComposite = this.createStatusTrend(content, formToolkit);
        content.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                GC gc = event.gc;
                gc.setForeground(sectionBorder);
                Rectangle rect = content.getClientArea();
                gc.drawRoundRectangle(rect.x, rect.y, rect.width - 1, rect.height - 1, 6, 6);
            }
        });
        this.fSectionContent = content;
        this.fFormToolkit = formToolkit;
        return content;
    }

    private Composite createStatusTrend(Composite content, FormToolkit formToolkit) {
        Composite statusTrendComposite = formToolkit.createComposite(content);
        statusTrendComposite.setLayoutData((Object)new GridData(768));
        statusTrendComposite.setLayout((Layout)new GridLayout(2, false));
        statusTrendComposite.setBackground(this.fSectionBackground);
        if (this.fBuildResultStatusTrends != null && this.fBuildResultStatusTrends.length > 0) {
            boolean emptyTrends = this.isTrendsEmpty();
            IBuildResultStatusTrend statusTrend = this.getStatusTrend(this.fBuildStatusTrendType);
            if (statusTrend != null && !emptyTrends) {
                boolean indistinct = this.isTrendsIndistinct();
                this.createStatusTrendBar(statusTrend, statusTrendComposite, formToolkit, this.fSectionBackground);
                GridData gridData = new GridData();
                gridData.horizontalIndent = 25;
                gridData.grabExcessHorizontalSpace = true;
                final Link personalBuildsLink = new Link(statusTrendComposite, 0);
                personalBuildsLink.setBackground(this.fSectionBackground);
                personalBuildsLink.setLayoutData((Object)gridData);
                if (indistinct) {
                    this.setLinkText(personalBuildsLink, BuildResultEditorMessages.StatusSection_STATUS_TREND_LINK_ALL_BUILDS_VISIBLE, false);
                } else {
                    Menu filterMenu = new Menu((Decorations)personalBuildsLink.getShell(), 8);
                    final MenuItem hidePersonalBuildsItem = new MenuItem(filterMenu, 32);
                    hidePersonalBuildsItem.setText(BuildResultEditorMessages.StatusSection_STATUS_TREND_LINK_CONTEXT_HIDE_PERSONAL_BUILDS);
                    if (this.fBuildStatusTrendType == this.getTrendType(true)) {
                        this.setLinkText(personalBuildsLink, BuildResultEditorMessages.StatusSection_STATUS_TREND_LINK_PERSONAL_BUILDS_HIDDEN, !indistinct);
                        hidePersonalBuildsItem.setSelection(true);
                    } else if (this.fBuildStatusTrendType == this.getTrendType(false)) {
                        this.setLinkText(personalBuildsLink, BuildResultEditorMessages.StatusSection_STATUS_TREND_LINK_ALL_BUILDS_VISIBLE, !indistinct);
                        hidePersonalBuildsItem.setSelection(false);
                    }
                    hidePersonalBuildsItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            BuildStatusSection.this.handleChangeTrendType(hidePersonalBuildsItem.getSelection());
                        }
                    });
                    personalBuildsLink.setMenu(filterMenu);
                    personalBuildsLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            personalBuildsLink.getMenu().setVisible(true);
                        }
                    });
                }
            }
        }
        return statusTrendComposite;
    }

    protected boolean isTrendsEmpty() {
        IBuildResultStatusTrend[] iBuildResultStatusTrendArray = this.fBuildResultStatusTrends;
        int n = this.fBuildResultStatusTrends.length;
        int n2 = 0;
        while (n2 < n) {
            IBuildResultStatusTrend currentTrend = iBuildResultStatusTrendArray[n2];
            if (currentTrend.getPreviousBuilds().length > 0 || currentTrend.getNextBuilds().length > 0) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    protected IBuildResultStatusTrend getStatusTrend(int type) {
        IBuildResultStatusTrend[] iBuildResultStatusTrendArray = this.fBuildResultStatusTrends;
        int n = this.fBuildResultStatusTrends.length;
        int n2 = 0;
        while (n2 < n) {
            IBuildResultStatusTrend currentTrend = iBuildResultStatusTrendArray[n2];
            if (currentTrend.getType() == type) {
                return currentTrend;
            }
            ++n2;
        }
        return null;
    }

    private void setLinkText(Link link, String text, boolean asHyperLink) {
        if (asHyperLink) {
            link.setText("<a>" + text + "</a>");
        } else {
            link.setText(text);
        }
    }

    protected boolean isTrendsIndistinct() {
        boolean state = this.getBuildResult().isPersonalBuild();
        boolean allPersonal = true;
        boolean allNormal = true;
        IBuildResultStatusTrend[] iBuildResultStatusTrendArray = this.fBuildResultStatusTrends;
        int n = this.fBuildResultStatusTrends.length;
        int n2 = 0;
        while (n2 < n) {
            IBuildResultStatusRecord buildResult;
            IBuildResultStatusTrend currentTrend = iBuildResultStatusTrendArray[n2];
            IBuildResultStatusRecord[] iBuildResultStatusRecordArray = currentTrend.getPreviousBuilds();
            int n3 = iBuildResultStatusRecordArray.length;
            int n4 = 0;
            while (n4 < n3) {
                buildResult = iBuildResultStatusRecordArray[n4];
                allPersonal &= buildResult.isPersonalBuild();
                allNormal &= !buildResult.isPersonalBuild();
                ++n4;
            }
            iBuildResultStatusRecordArray = currentTrend.getNextBuilds();
            n3 = iBuildResultStatusRecordArray.length;
            n4 = 0;
            while (n4 < n3) {
                buildResult = iBuildResultStatusRecordArray[n4];
                allPersonal &= buildResult.isPersonalBuild();
                allNormal &= !buildResult.isPersonalBuild();
                ++n4;
            }
            if (!(allNormal || allPersonal && state)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    protected int getTrendType(boolean hidePersonal) {
        if (hidePersonal) {
            return 1;
        }
        return 0;
    }

    protected void handleChangeTrendType(boolean hidePersonal) {
        this.setBuildStatusTrendType(this.getTrendType(hidePersonal));
        this.updateStatusTrend();
    }

    public void setBuildStatusTrendType(int trendType) {
        this.fBuildStatusTrendType = trendType;
    }

    private void updateStatusTrend() {
        Rectangle bounds = this.fStatusTrendComposite.getBounds();
        this.fStatusTrendComposite.dispose();
        this.fStatusTrendComposite = this.createStatusTrend(this.fSectionContent, this.fFormToolkit);
        this.fStatusTrendComposite.setBounds(bounds);
    }

    private void createTitleLabel(Composite parent, FormToolkit formToolkit, String text) {
        Label label = formToolkit.createLabel(parent, text);
        label.setBackground(this.fSectionBackground);
    }

    private String getStatusHeaderText(IBuildResult buildResult) {
        String text = null;
        if (buildResult.getState() == BuildState.COMPLETED) {
            text = BuildResultEditorMessages.StatusSection_COMPLETED_TITLE;
        } else if (buildResult.getState() == BuildState.IN_PROGRESS) {
            text = BuildResultEditorMessages.StatusSection_IN_PROGRESS_TITLE;
        } else if (buildResult.getState() == BuildState.INCOMPLETE) {
            text = BuildResultEditorMessages.StatusSection_ABANDONED_TITLE;
        }
        return text;
    }

    private Color getStatusHeaderForeground(IBuildResult buildResult) {
        RGB foregroundRGB = this.getBaseForegroundRGB(buildResult.getStatus(), buildResult.getState());
        return JazzResources.getColor((ResourceManager)this.fResourceManager, (RGB)foregroundRGB);
    }

    private Image getStatusImage(IBuildResult buildResult) {
        Image image = BuildUIPlugin.getImage("icons/obj16/completedblds_obj.gif");
        if (buildResult.getState() == BuildState.INCOMPLETE) {
            image = BuildUIPlugin.getImage("icons/obj16/abanblds_obj.gif");
        } else if (buildResult.getStatus() == BuildStatus.ERROR) {
            ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
            image = sharedImages.getImage("IMG_OBJS_ERROR_TSK");
        } else if (buildResult.getStatus() == BuildStatus.WARNING) {
            ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
            image = sharedImages.getImage("IMG_OBJS_WARN_TSK");
        } else if (buildResult.getState() == BuildState.IN_PROGRESS) {
            image = BuildUIPlugin.getImage("icons/obj16/rung_bld.gif");
        }
        return image;
    }

    private Color getBorderColor(IBuildResult buildResult) {
        RGB foregroundRGB = this.getBaseForegroundRGB(buildResult.getStatus(), buildResult.getState());
        RGB blend = ColorUtils.addColor((RGB)foregroundRGB, (float)70.0f);
        return JazzResources.getColor((ResourceManager)this.fResourceManager, (RGB)blend);
    }

    private void createStatusTrendBar(IBuildResultStatusTrend statusTrend, Composite parent, FormToolkit toolkit, Color background) {
        Composite trendBarContainer = toolkit.createComposite(parent);
        trendBarContainer.setLayoutData((Object)new GridData());
        trendBarContainer.setBackground(background);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        trendBarContainer.setLayout((Layout)gridLayout);
        this.createTitleLabel(trendBarContainer, toolkit, BuildResultEditorMessages.StatusSection_STATUS_TREND);
        Composite trendBar = toolkit.createComposite(trendBarContainer, 0);
        GridData layoutData = new GridData();
        trendBar.setLayoutData((Object)layoutData);
        trendBar.setBackground(background);
        RowLayout layout = new RowLayout();
        layout.marginLeft = 0;
        layout.marginRight = 0;
        trendBar.setLayout((Layout)layout);
        IBuildResultStatusRecord[] previousBuilds = statusTrend.getPreviousBuilds();
        int i = 0;
        while (i < previousBuilds.length) {
            this.createTrendBarItem(trendBar, toolkit, previousBuilds[i].getBuildResult(), previousBuilds[i].getStatus(), previousBuilds[i].getState(), previousBuilds[i].isPersonalBuild(), false);
            ++i;
        }
        this.createTrendBarItem(trendBar, toolkit, (IBuildResultHandle)this.getBuildResult(), this.getBuildResult().getStatus(), this.getBuildResult().getState(), this.getBuildResult().isPersonalBuild(), true);
        IBuildResultStatusRecord[] nextBuilds = statusTrend.getNextBuilds();
        int i2 = 0;
        while (i2 < nextBuilds.length) {
            this.createTrendBarItem(trendBar, toolkit, nextBuilds[i2].getBuildResult(), nextBuilds[i2].getStatus(), nextBuilds[i2].getState(), nextBuilds[i2].isPersonalBuild(), false);
            ++i2;
        }
    }

    private void createTrendBarItem(Composite parent, FormToolkit toolkit, IBuildResultHandle buildResultHandle, BuildStatus buildStatus, BuildState buildState, boolean personalBuild, boolean selected) {
        Label label = toolkit.createLabel(parent, "");
        final Image image = this.getStatusTrendItemImage(buildStatus, buildState, personalBuild, selected);
        label.setImage(image);
        if (!buildResultHandle.getItemId().equals((Object)this.getBuildResult().getItemId())) {
            this.addMouseListener(label, buildResultHandle);
        }
        this.getTooltipSupport(label, buildResultHandle);
        label.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                image.dispose();
            }
        });
    }

    protected TooltipSupport getTooltipSupport(Label label, final IBuildResultHandle buildResultHandle) {
        return new TooltipSupport((Control)label, true, true, true){

            public Object getElement(Control control, int x, int y) {
                return buildResultHandle;
            }
        };
    }

    private void addMouseListener(Label label, IBuildResultHandle buildResultHandle) {
        final Cursor cursor = new Cursor((Device)Display.getDefault(), 21);
        label.setCursor(cursor);
        label.addMouseListener(this.getMouseListener(buildResultHandle));
        label.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                cursor.dispose();
            }
        });
    }

    protected MouseListener getMouseListener(final IBuildResultHandle buildResultHandle) {
        return new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                BuildUI.getDefault().open(buildResultHandle, (ITeamRepository)buildResultHandle.getOrigin(), BuildStatusSection.this.fWorkbenchPage);
            }
        };
    }

    private Color getBackgroundColor(IBuildResult buildResult) {
        String key = "com.ibm.team.build.ui.SUCCESS_COLOR_BACKGROUND";
        if (buildResult.getState() == BuildState.INCOMPLETE) {
            key = "com.ibm.team.build.ui.INCOMPLETE_COLOR_BACKGROUND";
        } else if (buildResult.getStatus() == BuildStatus.ERROR) {
            key = "com.ibm.team.build.ui.ERROR_COLOR_BACKGROUND";
        } else if (buildResult.getStatus() == BuildStatus.WARNING) {
            key = "com.ibm.team.build.ui.WARNING_COLOR_BACKGROUND";
        } else if (buildResult.getState() == BuildState.IN_PROGRESS) {
            key = "com.ibm.team.build.ui.IN_PROGRESS_COLOR_BACKGROUND";
        }
        RGB backgroundRGB = this.getRGB(key);
        return JazzResources.getColor((ResourceManager)this.fResourceManager, (RGB)backgroundRGB);
    }

    private RGB getRGB(String key) {
        return PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getColorRegistry().getRGB(key);
    }

    private Image getStatusTrendItemImage(BuildStatus buildStatus, BuildState buildState, boolean personalBuild, boolean selected) {
        RGB baseRGB = this.getRGB("com.ibm.team.build.ui.SUCCESS_COLOR_TREND");
        if (buildState == BuildState.INCOMPLETE) {
            baseRGB = this.getRGB("com.ibm.team.build.ui.INCOMPLETE_COLOR_TREND");
        } else if (buildStatus == BuildStatus.ERROR) {
            baseRGB = this.getRGB("com.ibm.team.build.ui.ERROR_COLOR_TREND");
        } else if (buildStatus == BuildStatus.WARNING) {
            baseRGB = this.getRGB("com.ibm.team.build.ui.WARNING_COLOR_TREND");
        }
        RGB blend = ColorUtils.addColor((RGB)baseRGB, (float)50.0f);
        Color fillColor = JazzResources.getColor((ResourceManager)this.fResourceManager, (RGB)blend);
        blend = ColorUtils.addColor((RGB)baseRGB, (float)40.0f);
        Color borderColor = JazzResources.getColor((ResourceManager)this.fResourceManager, (RGB)blend);
        Color backgroundColor = this.getBackgroundColor(this.getBuildResult());
        Image image = new Image((Device)Display.getDefault(), 11, 26);
        GC gc = new GC((Drawable)image);
        Rectangle bounds = image.getBounds();
        gc.setBackground(backgroundColor);
        gc.fillRectangle(bounds);
        gc.setBackground(fillColor);
        gc.fillRectangle(bounds.x, bounds.y + 4, bounds.width - 1, bounds.height - 9);
        gc.setForeground(borderColor);
        gc.drawRectangle(bounds.x, bounds.y + 4, bounds.width - 1, bounds.height - 9);
        if (selected) {
            gc.setForeground(Display.getDefault().getSystemColor(17));
            if (!personalBuild) {
                gc.drawLine(2, 0, 8, 0);
                gc.drawLine(3, 1, 7, 1);
                gc.drawLine(4, 2, 6, 2);
                gc.drawLine(5, 3, 5, 3);
            }
            gc.drawLine(5, bounds.height - 4, 5, bounds.height - 4);
            gc.drawLine(4, bounds.height - 3, 6, bounds.height - 3);
            gc.drawLine(3, bounds.height - 2, 7, bounds.height - 2);
            gc.drawLine(2, bounds.height - 1, 8, bounds.height - 1);
        }
        gc.dispose();
        if (personalBuild) {
            Image newImage = new PersonalBuildTransparentCompositeImageDescriptor(image).createImage();
            image.dispose();
            return newImage;
        }
        return image;
    }

    private RGB getBaseForegroundRGB(BuildStatus buildStatus, BuildState buildState) {
        RGB baseRGB = this.getRGB("com.ibm.team.build.ui.SUCCESS_COLOR_FOREGROUND");
        if (buildState == BuildState.INCOMPLETE) {
            baseRGB = this.getRGB("com.ibm.team.build.ui.INCOMPLETE_COLOR_FOREGROUND");
        } else if (buildStatus == BuildStatus.ERROR) {
            baseRGB = this.getRGB("com.ibm.team.build.ui.ERROR_COLOR_FOREGROUND");
        } else if (buildStatus == BuildStatus.WARNING) {
            baseRGB = this.getRGB("com.ibm.team.build.ui.WARNING_COLOR_FOREGROUND");
        } else if (buildState == BuildState.IN_PROGRESS) {
            baseRGB = this.getRGB("com.ibm.team.build.ui.WARNING_COLOR_FOREGROUND");
        }
        return baseRGB;
    }

    public int getCurrentTrendType() {
        return this.fBuildStatusTrendType;
    }

    private IBuildResult getBuildResult() {
        return this.fBuildResultRecord.getBuildResult();
    }
}

