/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.editors.result.summary;

import com.ibm.icu.text.Collator;
import com.ibm.team.build.common.model.IBuildRequest;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.common.model.IExpectedContribution;
import com.ibm.team.build.internal.client.BuildRecordEventManager;
import com.ibm.team.build.internal.client.IBuildResultRecordListener;
import com.ibm.team.build.internal.common.model.dto.IBuildResultRecord;
import com.ibm.team.build.internal.common.model.dto.IBuildResultStatusTrend;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.editors.result.BuildResultEditor;
import com.ibm.team.build.internal.ui.editors.result.BuildResultEditorInput;
import com.ibm.team.build.internal.ui.editors.result.BuildResultEditorMessages;
import com.ibm.team.build.internal.ui.editors.result.BuildResultPage;
import com.ibm.team.build.internal.ui.editors.result.download.CopyToClipboardAction;
import com.ibm.team.build.internal.ui.editors.result.summary.BuildStatusSection;
import com.ibm.team.build.internal.ui.editors.result.summary.ContributionSummaryItem;
import com.ibm.team.build.internal.ui.editors.result.summary.GeneralInfoSummarySection;
import com.ibm.team.build.internal.ui.editors.result.summary.ISummaryItemListener;
import com.ibm.team.build.internal.ui.editors.result.summary.ReleaseSection;
import com.ibm.team.build.internal.ui.editors.result.workitem.WorkItemSection;
import com.ibm.team.build.ui.editors.result.AbstractBuildResultContributionProvider;
import com.ibm.team.build.ui.editors.result.AbstractBuildResultPage;
import com.ibm.team.build.ui.editors.result.IBuildResultContext;
import com.ibm.team.repository.client.ITeamRepository;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.Section;

public class BuildResultSummaryPage
extends BuildResultPage
implements ISummaryItemListener,
IBuildResultRecordListener {
    private static final String INTERNAL_PROPERTY_RELEASE_NOT_SUPPORTED = "com.ibm.team.build.internal.release.not.supported";
    private GeneralInfoSummarySection fGeneralInfoSummarySection;
    private WorkItemSection fWorkItemSection;
    protected ArrayList<ContributionSummaryItem> fSummaryItems;
    protected AbstractBuildResultContributionProvider[] fContributionProviders;
    protected Composite fSummaryComposite;
    protected Composite fParent;
    private BuildResultEditor fBuildResultEditor;
    private Composite fStatusSectionContainer;
    private Composite fStatusSectionContent;
    protected BuildStatusSection fStatusSection;
    protected int fNumberOfSummaryItemsFinished;
    private ReleaseSection fReleaseSection;

    public BuildResultSummaryPage(BuildResultEditor buildResultEditor, String id, String title, AbstractBuildResultContributionProvider[] contributionProviders, IBuildResultContext buildResultContext) {
        super((FormEditor)buildResultEditor, id, title, new String[0], buildResultContext);
        this.fBuildResultEditor = buildResultEditor;
        this.fContributionProviders = contributionProviders;
        this.fDoRefreshWorkaroundOnPageCreation = false;
    }

    @Override
    public AbstractBuildResultPage.PageGroup getPageGroup() {
        return AbstractBuildResultPage.PageGroup.SUMMARY;
    }

    @Override
    public ImageDescriptor getStatusImageDescriptor() {
        return null;
    }

    @Override
    protected void doCreatePageContent(Composite parent) {
        this.fNumberOfSummaryItemsFinished = 0;
        this.fParent = parent;
        this.fParent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                BuildResultSummaryPage.this.handleDispose();
            }
        });
        FormToolkit toolkit = this.getManagedForm().getToolkit();
        toolkit.setBorderStyle(2048);
        GridLayoutFactory.fillDefaults().numColumns(2).spacing(20, 12).applyTo(parent);
        BuildStatusSection statusSection = this.fStatusSection != null ? new BuildStatusSection(this.getBuildResultRecord(), this.getBuildStatusTrends(), this.getWorkbenchPage(), this.fStatusSection.getCurrentTrendType()) : (this.fBuildResultEditor != null && this.fBuildResultEditor.getBuildResult() != null && !this.fBuildResultEditor.getBuildResult().isPersonalBuild() ? new BuildStatusSection(this.getBuildResultRecord(), this.getBuildStatusTrends(), this.getWorkbenchPage(), 1) : new BuildStatusSection(this.getBuildResultRecord(), this.getBuildStatusTrends(), this.getWorkbenchPage(), 0));
        this.fStatusSectionContent = statusSection.createContent(this.createStatusSectionContainer(parent, toolkit), toolkit);
        this.fStatusSection = statusSection;
        this.createReportedProblemsSection(parent, toolkit);
        this.createContributionSummarySection(parent, toolkit);
        GeneralInfoSummarySection generalInfoSection = this.createGeneralInfoSection(parent, toolkit);
        if (this.shouldShowReleaseSection()) {
            this.createReleaseSection(parent, toolkit, generalInfoSection);
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ibm.team.build.ui.editor_buildresultsummary");
        BuildRecordEventManager.getInstance().addListener((IBuildResultRecordListener)this);
    }

    protected IWorkbenchPage getWorkbenchPage() {
        return this.getEditorSite().getPage();
    }

    protected IBuildResultStatusTrend[] getBuildStatusTrends() {
        return this.fBuildResultEditor.getBuildStatusTrends();
    }

    private boolean shouldShowReleaseSection() {
        if (this.getBuildResult().isPersonalBuild()) {
            return false;
        }
        return !this.isDisableReleasePropertyPresent();
    }

    private boolean isDisableReleasePropertyPresent() {
        IBuildRequest[] buildRequests = this.getBuildResultRecord().getBuildRequests();
        return buildRequests.length > 0 && buildRequests[0].getBuildDefinitionInstance().getProperty(INTERNAL_PROPERTY_RELEASE_NOT_SUPPORTED) != null;
    }

    protected void handleDispose() {
        if (this.fGeneralInfoSummarySection != null) {
            this.fGeneralInfoSummarySection.dispose();
        }
        if (this.fWorkItemSection != null) {
            this.fWorkItemSection.dispose();
        }
        if (this.fReleaseSection != null) {
            this.fReleaseSection.dispose();
        }
    }

    private Composite createStatusSectionContainer(Composite parent, FormToolkit toolkit) {
        this.fStatusSectionContainer = toolkit.createComposite(parent);
        GridData gridData = new GridData(768);
        gridData.verticalAlignment = 1;
        this.fStatusSectionContainer.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.fStatusSectionContainer.setLayout((Layout)gridLayout);
        return this.fStatusSectionContainer;
    }

    protected GeneralInfoSummarySection createGeneralInfoSection(Composite parent, FormToolkit toolkit) {
        Section section = toolkit.createSection(parent, 256);
        GridData gridData = new GridData(768);
        gridData.verticalAlignment = 1;
        section.setLayoutData((Object)gridData);
        this.fGeneralInfoSummarySection = new GeneralInfoSummarySection(this, this.getBuildResultContext().getBuildResultRecord(), toolkit, this.getEditorSite(), this.getRepository(), this.getManagedForm());
        this.fGeneralInfoSummarySection.createContents(section);
        return this.fGeneralInfoSummarySection;
    }

    protected WorkItemSection createReportedProblemsSection(Composite parent, FormToolkit toolkit) {
        Section section = toolkit.createSection(parent, 384);
        GridData gridData = new GridData(768);
        gridData.verticalAlignment = 1;
        section.setLayoutData((Object)gridData);
        this.fWorkItemSection = new WorkItemSection(this.fBuildResultEditor);
        this.fWorkItemSection.setTeamRepository(this.getRepository());
        this.fWorkItemSection.setEditorSite(this.getEditorSite());
        this.fWorkItemSection.setFormToolkit(toolkit);
        this.fWorkItemSection.setManagedForm(this.getManagedForm());
        this.fWorkItemSection.setBuildResultRecord(this.getBuildResultRecord());
        this.fWorkItemSection.createContents(section);
        return this.fWorkItemSection;
    }

    protected Section createContributionSummarySection(Composite parent, FormToolkit toolkit) {
        Section section = toolkit.createSection(parent, 256);
        GridData gridData = new GridData(768);
        gridData.verticalAlignment = 1;
        section.setLayoutData((Object)gridData);
        section.setText(BuildResultEditorMessages.BuildResultSummaryPage_CONTRIBUTION_SUMMARY_SECTION_TITLE);
        this.fSummaryComposite = toolkit.createComposite((Composite)section);
        this.fSummaryComposite.setLayout((Layout)new GridLayout(3, false));
        section.setClient((Control)this.fSummaryComposite);
        this.createSummaryItems(this.fSummaryComposite, toolkit);
        return section;
    }

    protected ReleaseSection createReleaseSection(Composite parent, FormToolkit toolkit, GeneralInfoSummarySection generalInfoSection) {
        Section section = toolkit.createSection(parent, 384);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        gridData.verticalAlignment = 1;
        section.setLayoutData((Object)gridData);
        this.fReleaseSection = new ReleaseSection(this, generalInfoSection, this.getBuildResultContext().getBuildResultRecord(), toolkit, this.getEditorSite(), this.getRepository(), this.getManagedForm());
        this.fReleaseSection.createContents(section);
        return this.fReleaseSection;
    }

    protected List<IExpectedContribution> getExpectedContributions() {
        return this.getBuildResultRecord().getBuildDefinition().getExpectedContributions();
    }

    protected void createSummaryItems(Composite parent, FormToolkit toolkit) {
        this.fSummaryItems = new ArrayList();
        if (this.fContributionProviders.length != 0) {
            AbstractBuildResultContributionProvider[] abstractBuildResultContributionProviderArray = this.fContributionProviders;
            int n = this.fContributionProviders.length;
            int n2 = 0;
            while (n2 < n) {
                AbstractBuildResultContributionProvider provider = abstractBuildResultContributionProviderArray[n2];
                boolean expected = false;
                this.fSummaryItems.add(this.createContributionSummaryItem(parent, toolkit, provider, expected));
                ++n2;
            }
        }
        this.sortSummaryItems(this.fSummaryItems);
        for (ContributionSummaryItem item : this.fSummaryItems) {
            try {
                item.createContents();
            }
            catch (Exception exception) {
                BuildUIPlugin.log(exception);
            }
        }
    }

    protected ContributionSummaryItem createContributionSummaryItem(Composite parent, FormToolkit toolkit, AbstractBuildResultContributionProvider provider, boolean expected) {
        return new ContributionSummaryItem(parent, toolkit, provider, expected, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void summaryItemDone() {
        ArrayList<ContributionSummaryItem> arrayList = this.fSummaryItems;
        synchronized (arrayList) {
            ++this.fNumberOfSummaryItemsFinished;
            if (this.fNumberOfSummaryItemsFinished == this.fSummaryItems.size()) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!BuildResultSummaryPage.this.fParent.isDisposed()) {
                            BuildResultSummaryPage.this.fSummaryComposite.getParent().getParent().pack(true);
                            BuildResultSummaryPage.this.getManagedForm().reflow(true);
                        }
                    }
                });
            }
        }
    }

    private void sortSummaryItems(ArrayList<ContributionSummaryItem> successfulSummaryItems) {
        Collections.sort(this.fSummaryItems, new Comparator<ContributionSummaryItem>(){

            @Override
            public int compare(ContributionSummaryItem item1, ContributionSummaryItem item2) {
                return Collator.getInstance().compare(item1.getTitle(), item2.getTitle());
            }
        });
    }

    protected void createHyperlinkContextMenu(Hyperlink hyperlink, boolean linkIsUrl) {
        MenuManager menuMgr = this.createMenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(this.createMenuListener(hyperlink, linkIsUrl));
        Menu menu = menuMgr.createContextMenu((Control)hyperlink);
        hyperlink.setMenu(menu);
    }

    protected MenuManager createMenuManager() {
        return new MenuManager("#PopupMenu");
    }

    protected IMenuListener createMenuListener(final Hyperlink hyperlink, final boolean linkIsUrl) {
        return new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IAction)new CopyToClipboardAction((String)hyperlink.getHref(), linkIsUrl));
            }
        };
    }

    protected ITeamRepository getRepository() {
        return ((BuildResultEditorInput)this.getEditorInput()).getTeamRepository();
    }

    @Override
    protected void doHandleBuildResultChanged(IBuildResult oldResult) {
        this.updateStatusSection(this.getBuildResultRecord());
    }

    protected void updateStatusSection(IBuildResultRecord record) {
        if (!this.fStatusSectionContainer.isDisposed()) {
            this.fStatusSectionContent.dispose();
            BuildStatusSection statusSection = new BuildStatusSection(record, this.fBuildResultEditor.getBuildStatusTrends(), this.getEditorSite().getPage(), this.fStatusSection.getCurrentTrendType());
            FormToolkit toolkit = this.getManagedForm().getToolkit();
            toolkit.setBorderStyle(2048);
            this.fStatusSectionContent = statusSection.createContent(this.fStatusSectionContainer, toolkit);
            this.fStatusSectionContent.pack(true);
            this.fStatusSectionContainer.pack(true);
            this.fStatusSectionContainer.getParent().pack(true);
            this.fStatusSection = statusSection;
            this.getManagedForm().reflow(true);
            if (this.fGeneralInfoSummarySection != null) {
                this.fGeneralInfoSummarySection.handleWorkingCopyUpdated();
            }
        }
    }

    @Override
    protected Viewer getViewer() {
        return null;
    }

    @Override
    public boolean validate() {
        if (this.fGeneralInfoSummarySection != null) {
            return this.fGeneralInfoSummarySection.validate();
        }
        return true;
    }

    @Override
    public void postSave() {
        if (this.fGeneralInfoSummarySection != null) {
            this.fGeneralInfoSummarySection.handleWorkingCopyUpdated();
        }
        if (this.fReleaseSection != null) {
            this.fReleaseSection.postSave();
        }
    }

    protected void setGeneralInfoSummarySection(GeneralInfoSummarySection generalInfoSummarySection) {
        this.fGeneralInfoSummarySection = generalInfoSummarySection;
    }

    @Override
    protected String getContextHelpId() {
        return "com.ibm.team.build.ui.editor_buildresultsummary";
    }

    public void dispose() {
        BuildRecordEventManager.getInstance().removeListener((IBuildResultRecordListener)this);
        super.dispose();
    }

    public void recordsReceived(final IBuildResultRecord[] records) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!BuildResultSummaryPage.this.fParent.isDisposed()) {
                    BuildResultSummaryPage.this.handleRecordsReceivedAsync(records);
                }
            }
        });
    }

    protected void handleRecordsReceivedAsync(IBuildResultRecord[] records) {
        IBuildResultRecord[] iBuildResultRecordArray = records;
        int n = records.length;
        int n2 = 0;
        while (n2 < n) {
            IBuildResultRecord record = iBuildResultRecordArray[n2];
            if (record.getBuildResult().getItemId().equals((Object)this.getBuildResult().getItemId()) && record.getLastModified() > this.getBuildResultRecord().getLastModified()) {
                this.updateStatusSection(record);
                return;
            }
            ++n2;
        }
    }
}

