/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.editors.result.properties;

import com.ibm.team.build.common.model.IBuildProperty;
import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.ui.BuildPropertyControl;
import com.ibm.team.build.internal.ui.editors.result.BuildResultPage;
import com.ibm.team.build.internal.ui.editors.result.properties.Messages;
import com.ibm.team.build.ui.editors.result.AbstractBuildResultPage;
import com.ibm.team.build.ui.editors.result.IBuildResultContext;
import com.ibm.team.repository.client.ITeamRepository;
import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class BuildPropertiesPage
extends BuildResultPage {
    public static final String CONTEXT_MENU_ID = "com.ibm.team.build.ui.buildPropertiesPageContextMenu";
    private List<IBuildProperty> fBuildProperties;
    private BuildPropertyControl fControl;

    public BuildPropertiesPage(FormEditor editor, String id, String title, String[] contributionIds, IBuildResultContext buildResultContext, List<IBuildProperty> buildProperties) {
        super(editor, id, title, contributionIds, buildResultContext);
        ValidationHelper.validateNotNull((String)"buildProperties", buildProperties);
        this.fBuildProperties = buildProperties;
    }

    @Override
    protected void doCreatePageContent(Composite parent) {
        FormToolkit toolkit = this.getManagedForm().getToolkit();
        toolkit.setBorderStyle(2048);
        GridLayoutFactory.fillDefaults().margins(0, 0).spacing(0, 1).applyTo(parent);
        this.addPropertiesControl(parent, toolkit);
        this.fControl.createAndRegisterDefaultContextMenu(this.getSite());
        this.fControl.replaceGlobalActionsOnFocus(this.getEditorSite());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ibm.team.build.ui.editorpage_buildresultproperties");
    }

    protected boolean copyFirstColumnOnly(Control tableOrTree) {
        return false;
    }

    @Override
    protected Viewer getViewer() {
        if (this.fControl == null) {
            return null;
        }
        return this.fControl.getViewer();
    }

    private void addPropertiesControl(Composite body, FormToolkit toolkit) {
        Section section = toolkit.createSection(body, 384);
        section.setText(Messages.BuildPropertiesPage_SECTION_TITLE);
        GridDataFactory.fillDefaults().grab(true, false).minSize(400, -1).applyTo((Control)section);
        GridLayoutFactory.fillDefaults().applyTo((Composite)section);
        Label descriptionLabel = toolkit.createLabel(body, Messages.BuildPropertiesPage_DESCRIPTION);
        GridDataFactory.swtDefaults().indent(8, -1).applyTo((Control)descriptionLabel);
        if (this.fBuildProperties.size() == 0) {
            toolkit.createLabel(body, Messages.BuildPropertiesPage_NO_PROPERTIES);
            GridDataFactory.fillDefaults().indent(0, 10).applyTo((Control)this.fControl.getComposite());
        } else {
            this.fControl = new BuildPropertyControl(body, this.getEditor().getToolkit(), this.fBuildProperties, this.getTeamRepository(), false, BuildPropertyControl.LayoutSize.FULL, true);
            GridDataFactory.fillDefaults().indent(0, 10).grab(true, true).hint(250, 150).applyTo((Control)this.fControl.getComposite());
        }
    }

    protected ITeamRepository getTeamRepository() {
        return this.getBuildResultContext().getTeamRepository();
    }

    @Override
    public AbstractBuildResultPage.PageGroup getPageGroup() {
        return AbstractBuildResultPage.PageGroup.ADDITIONS;
    }

    @Override
    protected String getContextHelpId() {
        return "com.ibm.team.build.ui.editorpage_buildresultproperties";
    }

    @Override
    public boolean performGlobalAction(String id) {
        Table table;
        Control focusControl = this.getFocusControl();
        if (focusControl instanceof Table && (table = (Table)focusControl).equals(this.fControl.getViewer().getControl()) && ActionFactory.COPY.getId().equals(id)) {
            this.fControl.performCopy();
            return true;
        }
        return super.performGlobalAction(id);
    }
}

